/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.multiLayer;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.multiLayer.BFS_from_dst;
import es.tid.pce.computingEngine.algorithms.multiLayer.BFS_from_src;
import es.tid.pce.computingEngine.algorithms.multiLayer.Multilayer_MinLP_AlgorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.multiLayer.Operacion1;
import es.tid.pce.computingEngine.algorithms.multiLayer.Operacion2;
import es.tid.pce.computingEngine.algorithms.multiLayer.Operacion3;
import es.tid.pce.computingEngine.algorithms.multiLayer.OperationsCounter;
import es.tid.pce.computingEngine.algorithms.wson.GenericLambdaReservation;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.ServerLayerInfo;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.MultiLayerTEDB;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multilayer_MinLP_Algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Logger log_OP = LoggerFactory.getLogger((String)"OpMultiLayer");
    private ComputingRequest pathReq;
    private Multilayer_MinLP_AlgorithmPreComputation preComp;
    static Operacion3 op3;
    static BFS_from_src Op4a;
    static BFS_from_dst Op4b;
    private ReservationManager reservationManager;
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;
    private OperationsCounter OP_Counter;
    private Lock graphLock;
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs_precomp;

    public Multilayer_MinLP_Algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, OperationsCounter OPcounter) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
        this.OP_Counter = OPcounter;
    }

    @Override
    public ComputingResponse call() {
        GraphPath<Object, IntraDomainEdge> gp3;
        GraphPath<Object, IntraDomainEdge> gp2;
        this.log.debug("Starting Multilayer Min Ligth Paths Algorithm");
        this.graphLock = this.preComp.getGraphLock();
        if (this.pathReq.getSvec() != null) {
            this.log.info("Numero de requests -- > " + this.pathReq.getSvec().getSvec().getRequestIDlist().size());
        }
        int u = 0;
        if (this.pathReq.getSvec() != null) {
            ComputingResponse m_resp = new ComputingResponse();
            m_resp.setEncodingType(this.pathReq.getEcodingType());
            this.networkGraphs_precomp = new ArrayList(this.preComp.getWSONInfo().getNumLambdas());
            for (int t = 0; t <= this.preComp.getWSONInfo().getNumLambdas() - 1; ++t) {
                this.networkGraphs_precomp.add(t, (SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)((MultiLayerTEDB)this.ted).getDuplicatedLowerLayerkGraph());
            }
            while (u < this.pathReq.getSvec().getSvec().getRequestIDlist().size()) {
                GraphPath<Object, IntraDomainEdge> gp22;
                long tiempoini = System.nanoTime();
                ComputingResponse m_resp_individual = new ComputingResponse();
                Request req = this.pathReq.getRequestList().get(u);
                long reqId = req.getRequestParameters().getRequestID();
                this.log.info("Request id: " + reqId + ", getting endpoints");
                Response response = new Response();
                RequestParameters rp = new RequestParameters();
                rp.setBidirect(req.getRequestParameters().isBidirect());
                rp.setRequestID(reqId);
                response.setRequestParameters(rp);
                m_resp.addResponse(response);
                BandwidthRequested bandwidth = new BandwidthRequested();
                bandwidth.setBw(((BandwidthRequested)req.getBandwidth()).getBw());
                response.setBandwidth((Bandwidth)bandwidth);
                m_resp_individual.addResponse(response);
                EndPoints EP = req.getEndPoints();
                Inet4Address source_router_id_addr = null;
                Inet4Address dest_router_id_addr = null;
                if (EP.getOT() == 1) {
                    EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
                    source_router_id_addr = ep.getSourceIP();
                    dest_router_id_addr = ep.getDestIP();
                } else if (EP.getOT() != 2 && EP.getOT() == 5) {
                    GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                    if (gep.getGeneralizedEndPointsType() == 0) {
                        P2PEndpoints p2pep = gep.getP2PEndpoints();
                        EndPoint sourceep = p2pep.getSourceEndPoint();
                        EndPoint destep = p2pep.getDestinationEndPoint();
                        source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                        dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                    }
                    if (gep.getGeneralizedEndPointsType() == 1) {
                        P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                        EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                        EndPoint sourceep = epandrest.getEndPoint();
                        source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                        int cont = 0;
                        while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                            epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                            EndPoint destep = epandrest.getEndPoint();
                            source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                            dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                        }
                    }
                }
                this.log.error("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
                if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
                    this.log.error("Source or destination are NOT in the TED");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                        this.log.error("Unknown source");
                        noPathTLV.setUnknownSource(true);
                    }
                    if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                        this.log.error("Unknown destination");
                        noPathTLV.setUnknownDestination(true);
                    }
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    return m_resp;
                }
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> GraphIP = this.preComp.getnetworkGraphIP();
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> InterlayerGraph = this.preComp.getInterLayerGraph();
                ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs = this.preComp.getNetworkGraphs();
                boolean grooming = false;
                boolean nopath = true;
                GraphPath<Object, IntraDomainEdge> gp_chosen = null;
                Object gp_chosen_a = null;
                Object gp_chosen_b = null;
                Object gp_chosen_a2 = null;
                Object gp_chosen_b2 = null;
                int lambda_chosen = 0;
                boolean EROMultilayer_op3 = false;
                boolean EROMultilayer_op4 = false;
                boolean terminado = false;
                int numLambdas = this.ted.getWSONinfo().getNumLambdas();
                int numberHops = 0;
                boolean NoLambda = false;
                boolean prueba_demo = false;
                boolean op4a_flag = false;
                boolean op4b_flag = false;
                float bwt_req = ((BandwidthRequested)req.getBandwidth()).getBw();
                GraphPath<Object, IntraDomainEdge> gp = Operacion1.get_op1(GraphIP, source_router_id_addr, dest_router_id_addr, this.graphLock, bwt_req);
                if (gp != null) {
                    if (gp.getEdgeList().size() == 1) {
                        nopath = false;
                        gp_chosen = gp;
                        terminado = true;
                        NoLambda = true;
                    } else {
                        this.log.info("Hay PATH pero > 1 salto at Operation 1");
                    }
                } else if (gp == null) {
                    this.log.info("No ligthpath available: Continue to Operation 3");
                }
                if (!terminado && (gp22 = Operacion2.get_op2(GraphIP, source_router_id_addr, dest_router_id_addr, bwt_req, this.graphLock)) != null) {
                    this.log.warn("Multiple LigthPath found at Operation 2");
                    nopath = false;
                    gp_chosen = gp22;
                    numberHops = gp22.getEdgeList().size();
                    NoLambda = true;
                    terminado = true;
                }
                if (!terminado) {
                    op3 = new Operacion3(this.networkGraphs_precomp);
                    GraphPath<Object, IntraDomainEdge> gp32 = op3.get_op3(source_router_id_addr, dest_router_id_addr, InterlayerGraph, numLambdas);
                    if (gp32 != null) {
                        nopath = false;
                        gp_chosen = gp32;
                        EROMultilayer_op3 = true;
                        lambda_chosen = op3.getLambda_chosen();
                    } else {
                        this.log.info("No hay camino \u00d3ptico disponible: NO PATH");
                    }
                }
                if (nopath) {
                    this.log.info("No path found");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    return m_resp;
                }
                if (!nopath) {
                    int i;
                    int m;
                    Path path = new Path();
                    ExplicitRouteObject ero = new ExplicitRouteObject();
                    List edge_list_pre = null;
                    if (!EROMultilayer_op4) {
                        edge_list_pre = gp_chosen.getEdgeList();
                    }
                    LinkedList<IntraDomainEdge> edge_list = new LinkedList<IntraDomainEdge>();
                    if (EROMultilayer_op3) {
                        edge_list.add(op3.getEdge_ini());
                        for (m = 0; m < edge_list_pre.size(); ++m) {
                            edge_list.add((IntraDomainEdge)edge_list_pre.get(m));
                        }
                        edge_list.add(op3.getEdge_end());
                    } else if (!EROMultilayer_op3 && !EROMultilayer_op4) {
                        for (m = 0; m < edge_list_pre.size(); ++m) {
                            edge_list.add((IntraDomainEdge)edge_list_pre.get(m));
                        }
                    } else if (!EROMultilayer_op3 && EROMultilayer_op4) {
                        if (op4a_flag) {
                            for (m = 0; m < gp_chosen_a2.getEdgeList().size(); ++m) {
                                edge_list.add((IntraDomainEdge)gp_chosen_a2.getEdgeList().get(m));
                            }
                            int i2 = 0;
                            while (i2 < gp_chosen_a.getEdgeList().size()) {
                                edge_list.add((IntraDomainEdge)gp_chosen_a.getEdgeList().get(i2));
                                ++i2;
                                ++m;
                            }
                        } else if (op4b_flag) {
                            for (m = 0; m < gp_chosen_b2.getEdgeList().size(); ++m) {
                                edge_list.add((IntraDomainEdge)gp_chosen_b2.getEdgeList().get(m));
                            }
                            int n = 0;
                            while (n < gp_chosen_b.getEdgeList().size()) {
                                edge_list.add((IntraDomainEdge)gp_chosen_b.getEdgeList().get(n));
                                ++n;
                                ++m;
                            }
                        }
                    }
                    for (i = 0; i < edge_list.size(); ++i) {
                        if (NoLambda) {
                            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                            eroso.setLoosehop(false);
                            ero.addEROSubobject((EROSubobject)eroso);
                            continue;
                        }
                        if (NoLambda) continue;
                        if (op4a_flag) {
                            // empty if block
                        }
                        if (op4b_flag) {
                            // empty if block
                        }
                        if (EROMultilayer_op3 && i == 0) {
                            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                            eroso.setLoosehop(false);
                            ero.addEROSubobject((EROSubobject)eroso);
                            ServerLayerInfo eroso1 = new ServerLayerInfo();
                            eroso1.setEncoding(8);
                            eroso1.setSwitchingCap(150);
                            ero.addEROSubobject((EROSubobject)eroso1);
                        } else if (EROMultilayer_op3 && i != 0) {
                            UnnumberIfIDEROSubobject eroso = new UnnumberIfIDEROSubobject();
                            eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                            eroso.setInterfaceID(edge_list.get(i).getSrc_if_id());
                            eroso.setLoosehop(false);
                            ero.addEROSubobject((EROSubobject)eroso);
                            GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                            ero.addEROSubobject((EROSubobject)genLabel);
                            DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                            WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                            WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                            WDMlabel.setN(lambda_chosen + this.preComp.getWSONInfo().getnMin());
                            WDMlabel.setIdentifier(0);
                            try {
                                WDMlabel.encode();
                            }
                            catch (RSVPProtocolViolationException e) {
                                e.printStackTrace();
                            }
                            genLabel.setLabel(WDMlabel.getBytes());
                        }
                        if (!EROMultilayer_op3 || i != edge_list.size() - 1) continue;
                        ServerLayerInfo eroso1 = new ServerLayerInfo();
                        eroso1.setEncoding(8);
                        eroso1.setSwitchingCap(150);
                        ero.addEROSubobject((EROSubobject)eroso1);
                    }
                    IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
                    eroso.setPrefix(32);
                    ero.addEROSubobject((EROSubobject)eroso);
                    path.setEro(ero);
                    PCEPUtils.completeMetric(path, req, edge_list);
                    response.addPath(path);
                    LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                    LinkedList<Object> targetVertexList = new LinkedList<Object>();
                    for (i = 0; i < edge_list.size(); ++i) {
                        sourceVertexList.add(edge_list.get(i).getSource());
                        targetVertexList.add(edge_list.get(i).getTarget());
                    }
                    if (req.getReservation() != null) {
                        this.reserv = new GenericLambdaReservation();
                        this.reserv.setResp(m_resp_individual);
                        this.reserv.setLambda_chosen(lambda_chosen);
                        this.reserv.setReservation(req.getReservation());
                        this.reserv.setSourceVertexList(sourceVertexList);
                        this.reserv.setTargetVertexList(targetVertexList);
                        if (rp.isBidirect()) {
                            this.reserv.setBidirectional(true);
                        } else {
                            this.reserv.setBidirectional(false);
                        }
                        this.reserv.setReservationManager(this.reservationManager);
                    } else {
                        this.log.info("Reservation is FALSE");
                    }
                    this.notifyWavelengthReservation(sourceVertexList, targetVertexList, lambda_chosen);
                }
                long tiempofin = System.nanoTime();
                long tiempotot = tiempofin - tiempoini;
                this.log.info("Ha tardado " + tiempotot + " nanosegundos");
                ++u;
            }
            return m_resp;
        }
        ComputingResponse m_resp = new ComputingResponse();
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp_individual = new ComputingResponse();
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        BandwidthRequested bandwidth = new BandwidthRequested();
        bandwidth.setBw(((BandwidthRequested)req.getBandwidth()).getBw());
        response.setBandwidth((Bandwidth)bandwidth);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.error("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.error("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.error("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.error("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> GraphIP = this.preComp.getnetworkGraphIP();
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> InterlayerGraph = this.preComp.getInterLayerGraph();
        ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs = this.preComp.getNetworkGraphs();
        boolean grooming = false;
        boolean nopath = true;
        GraphPath<Object, IntraDomainEdge> gp_chosen = null;
        Object gp_chosen_a = null;
        Object gp_chosen_b = null;
        Object gp_chosen_a2 = null;
        Object gp_chosen_b2 = null;
        int lambda_chosen = 0;
        boolean EROMultilayer_op3 = false;
        boolean EROMultilayer_op4 = false;
        boolean terminado = false;
        int numLambdas = this.ted.getWSONinfo().getNumLambdas();
        int numberHops = 0;
        boolean NoLambda = false;
        boolean prueba_demo = false;
        boolean op4a_flag = false;
        boolean op4b_flag = false;
        float bwt_req = ((BandwidthRequested)req.getBandwidth()).getBw();
        GraphPath<Object, IntraDomainEdge> gp = Operacion1.get_op1(GraphIP, source_router_id_addr, dest_router_id_addr, this.graphLock, bwt_req);
        if (gp != null) {
            if (gp.getEdgeList().size() == 1) {
                nopath = false;
                gp_chosen = gp;
                terminado = true;
                NoLambda = true;
                this.OP_Counter.setNum_op1();
            } else {
                this.log.info("Hay PATH pero > 1 salto at Operation 1");
            }
        } else if (gp == null) {
            // empty if block
        }
        if (!terminado && (gp2 = Operacion2.get_op2(GraphIP, source_router_id_addr, dest_router_id_addr, bwt_req, this.graphLock)) != null) {
            this.log.warn("Multiple LigthPath found at Operation 2");
            nopath = false;
            gp_chosen = gp2;
            numberHops = gp2.getEdgeList().size();
            NoLambda = true;
            terminado = true;
            this.OP_Counter.setNum_op2();
        }
        if (!terminado && (gp3 = (op3 = new Operacion3(networkGraphs)).get_op3(source_router_id_addr, dest_router_id_addr, InterlayerGraph, numLambdas)) != null) {
            nopath = false;
            gp_chosen = gp3;
            EROMultilayer_op3 = true;
            terminado = true;
            lambda_chosen = op3.getLambda_chosen();
            this.OP_Counter.setNum_op3();
        }
        if (nopath) {
            this.log.debug("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            this.log_OP.info("NumOP_1: " + this.OP_Counter.getNum_op1());
            this.log_OP.info("NumOP_2: " + this.OP_Counter.getNum_op2());
            this.log_OP.info("NumOP_3: " + this.OP_Counter.getNum_op3());
            this.log_OP.info("NumOP_4: " + this.OP_Counter.getNum_op4());
            return m_resp;
        }
        if (!nopath) {
            int i;
            int m;
            this.log_OP.info("NumOP_1: " + this.OP_Counter.getNum_op1());
            this.log_OP.info("NumOP_2: " + this.OP_Counter.getNum_op2());
            this.log_OP.info("NumOP_3: " + this.OP_Counter.getNum_op3());
            this.log_OP.info("NumOP_4: " + this.OP_Counter.getNum_op4());
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list_pre = null;
            if (!EROMultilayer_op4) {
                edge_list_pre = gp_chosen.getEdgeList();
            }
            LinkedList<IntraDomainEdge> edge_list = new LinkedList<IntraDomainEdge>();
            if (EROMultilayer_op3) {
                edge_list.add(op3.getEdge_ini());
                for (m = 0; m < edge_list_pre.size(); ++m) {
                    edge_list.add((IntraDomainEdge)edge_list_pre.get(m));
                }
                edge_list.add(op3.getEdge_end());
            } else if (!EROMultilayer_op3 && !EROMultilayer_op4) {
                for (m = 0; m < edge_list_pre.size(); ++m) {
                    edge_list.add((IntraDomainEdge)edge_list_pre.get(m));
                }
            } else if (!EROMultilayer_op3 && EROMultilayer_op4) {
                if (op4a_flag) {
                    for (m = 0; m < gp_chosen_a2.getEdgeList().size(); ++m) {
                        edge_list.add((IntraDomainEdge)gp_chosen_a2.getEdgeList().get(m));
                    }
                    int i3 = 0;
                    while (i3 < gp_chosen_a.getEdgeList().size()) {
                        edge_list.add((IntraDomainEdge)gp_chosen_a.getEdgeList().get(i3));
                        ++i3;
                        ++m;
                    }
                } else if (op4b_flag) {
                    for (m = 0; m < gp_chosen_b2.getEdgeList().size(); ++m) {
                        edge_list.add((IntraDomainEdge)gp_chosen_b2.getEdgeList().get(m));
                    }
                    int n = 0;
                    while (n < gp_chosen_b.getEdgeList().size()) {
                        edge_list.add((IntraDomainEdge)gp_chosen_b.getEdgeList().get(n));
                        ++n;
                        ++m;
                    }
                }
            }
            for (i = 0; i < edge_list.size(); ++i) {
                if (NoLambda) {
                    IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                    eroso.setLoosehop(false);
                    ero.addEROSubobject((EROSubobject)eroso);
                    continue;
                }
                if (NoLambda) continue;
                if (op4a_flag) {
                    // empty if block
                }
                if (op4b_flag) {
                    // empty if block
                }
                if (EROMultilayer_op3 && i == 0) {
                    IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                    eroso.setLoosehop(false);
                    ero.addEROSubobject((EROSubobject)eroso);
                    ServerLayerInfo eroso1 = new ServerLayerInfo();
                    eroso1.setEncoding(8);
                    eroso1.setSwitchingCap(150);
                    ero.addEROSubobject((EROSubobject)eroso1);
                } else if (EROMultilayer_op3 && i != 0) {
                    UnnumberIfIDEROSubobject eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                    eroso.setInterfaceID(edge_list.get(i).getSrc_if_id());
                    eroso.setLoosehop(false);
                    ero.addEROSubobject((EROSubobject)eroso);
                    GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                    ero.addEROSubobject((EROSubobject)genLabel);
                    DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                    WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                    WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                    WDMlabel.setN(lambda_chosen + this.preComp.getWSONInfo().getnMin());
                    WDMlabel.setIdentifier(0);
                    try {
                        WDMlabel.encode();
                    }
                    catch (RSVPProtocolViolationException e) {
                        e.printStackTrace();
                    }
                    genLabel.setLabel(WDMlabel.getBytes());
                }
                if (!EROMultilayer_op3 || i != edge_list.size() - 1) continue;
                ServerLayerInfo eroso1 = new ServerLayerInfo();
                eroso1.setEncoding(8);
                eroso1.setSwitchingCap(150);
                ero.addEROSubobject((EROSubobject)eroso1);
            }
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
            LinkedList<Object> targetVertexList = new LinkedList<Object>();
            for (i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add(edge_list.get(i).getSource());
                targetVertexList.add(edge_list.get(i).getTarget());
            }
            if (req.getReservation() != null) {
                this.reserv = new GenericLambdaReservation();
                this.reserv.setResp(m_resp);
                this.reserv.setLambda_chosen(lambda_chosen);
                this.reserv.setReservation(req.getReservation());
                this.reserv.setSourceVertexList(sourceVertexList);
                this.reserv.setTargetVertexList(targetVertexList);
                if (rp.isBidirect()) {
                    this.reserv.setBidirectional(true);
                } else {
                    this.reserv.setBidirectional(false);
                }
                this.reserv.setReservationManager(this.reservationManager);
            } else {
                this.log.info("Reservation is FALSE");
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(Multilayer_MinLP_AlgorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs_precomp.get(wavelength);
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                networkGraph.removeEdge(sourceVertexList.get(i), targetVertexList.get(i));
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }
}

