/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.multidomain;

import es.tid.pce.pcep.objects.ExcludeRouteObject;
import es.tid.pce.pcep.objects.subobjects.UnnumberIfIDXROSubobject;
import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import es.tid.tedb.InterDomainEdge;
import es.tid.tedb.ReachabilityManager;
import java.net.Inet4Address;
import java.util.Set;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDFunctions {
    public static void processXRO(ExcludeRouteObject xro, ReachabilityManager reachabilityManager, DirectedWeightedMultigraph<Object, InterDomainEdge> networkGraph) {
        Logger log = LoggerFactory.getLogger((String)"PCEServer");
        try {
            if (xro != null) {
                log.info("XRO: Thre are " + xro.getXROSubobjectList().size() + " exclusions");
                for (int i = 0; i < xro.getXROSubobjectList().size(); ++i) {
                    XROSubobject eroso = (XROSubobject)xro.getXROSubobjectList().get(i);
                    if (eroso.getType() != 4) continue;
                    UnnumberIfIDXROSubobject eros = (UnnumberIfIDXROSubobject)eroso;
                    log.info("XRO: UNNUMBERED_IF_ID TO EXCLUDE: " + eros.getRouterID() + ":" + eros.getInterfaceID());
                    Inet4Address source_domain_id = reachabilityManager.getDomain(eros.getRouterID());
                    log.info("XRO: IT BELONGS TO DOMAIN " + source_domain_id);
                    boolean hasVertex = networkGraph.containsVertex((Object)source_domain_id);
                    log.info("XRO: EL GRAPH TIENE VERTEX " + hasVertex);
                    if (!hasVertex) continue;
                    Set setEdges = networkGraph.edgesOf((Object)source_domain_id);
                    for (InterDomainEdge edge : setEdges) {
                        log.info("XRO: LOOKING AT EDGE " + edge.getSrc_router_id());
                        if (!edge.getSrc_router_id().equals(eros.getRouterID()) || edge.getSrc_if_id() != eros.getInterfaceID()) continue;
                        networkGraph.removeEdge((Object)edge);
                        log.info("XRO: REMOVE EDGE " + eros.getRouterID() + ":" + edge.getSrc_if_id());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

