/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.multidomain;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.multidomain.MDFunctions;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.ParentPCESession;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.constructs.SwitchEncodingType;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExcludeRouteObject;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.InterLayer;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.SwitchLayer;
import es.tid.pce.pcep.objects.tlvs.EndPointIPv4TLV;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.InterDomainEdge;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinTransitDomainsInterLayerAlgorithm
implements ComputingAlgorithm {
    private DirectedWeightedMultigraph<Object, InterDomainEdge> networkGraph;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private ChildPCERequestManager childPCERequestManager;
    private ReachabilityManager reachabilityManager;

    public MinTransitDomainsInterLayerAlgorithm(ComputingRequest pathReq, TEDB ted, ChildPCERequestManager cprm, ReachabilityManager rm) {
        this.networkGraph = ted.isITtedb() ? ((ITMDTEDB)ted).getDuplicatedMDNetworkGraph() : ((MDTEDB)ted).getDuplicatedMDNetworkGraph();
        this.reachabilityManager = rm;
        this.pathReq = pathReq;
        this.childPCERequestManager = cprm;
    }

    @Override
    public ComputingResponse call() throws Exception {
        LinkedList<ComputingResponse> respList;
        SwitchEncodingType set;
        long requestID;
        NoPathTLV noPathTLV;
        NoPath noPath;
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Processing MultiDomain Path Computation with Interlayer Capabiilties for Request id: " + reqId);
        Response response = new Response();
        m_resp.addResponse(response);
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        Inet4Address source_domain_id = this.reachabilityManager.getDomain(source_router_id_addr);
        Inet4Address dest_domain_id = this.reachabilityManager.getDomain(dest_router_id_addr);
        this.log.info("MD Request from " + source_router_id_addr + " (domain " + source_domain_id + ") to " + dest_router_id_addr + " (domain " + dest_domain_id + ")");
        this.log.info("Check if SRC and Dest domains are OK");
        if (dest_domain_id == null || source_domain_id == null) {
            this.log.warn("One of the domains is not reachable, sending NOPATH");
            noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            response.setNoPath(noPath);
            return m_resp;
        }
        if (!this.networkGraph.containsVertex((Object)source_domain_id) || !this.networkGraph.containsVertex((Object)dest_domain_id)) {
            this.log.warn("Source or destination domains are NOT in the TED");
            noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            noPathTLV = new NoPathTLV();
            if (!this.networkGraph.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source domain");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.networkGraph.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination domain");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        if (source_domain_id.equals(dest_domain_id)) {
            this.log.warn("Source and destination domain is the same, case not allowed");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            noPathTLV = new NoPathTLV();
            noPath2.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath2);
            return m_resp;
        }
        this.log.info("Processing XRO");
        MDFunctions.processXRO(req.getXro(), this.reachabilityManager, this.networkGraph);
        this.log.info("Computing MD Sequence of domains");
        DijkstraShortestPath dsp = new DijkstraShortestPath(this.networkGraph, (Object)source_domain_id, (Object)dest_domain_id);
        LinkedList<PCEPRequest> reqList = new LinkedList<PCEPRequest>();
        LinkedList<Object> domainList = new LinkedList<Object>();
        GraphPath gp = dsp.getPath();
        if (gp == null) {
            this.log.error("Problem getting the domain sequence");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            NoPathTLV noPathTLV2 = new NoPathTLV();
            noPath2.setNoPathTLV(noPathTLV2);
            response.setNoPath(noPath2);
            return m_resp;
        }
        List edge_list = gp.getEdgeList();
        long tiempo2 = System.nanoTime();
        this.log.info("Vamos a comprobar InterLayer");
        boolean switchLayerPresent = false;
        boolean interLayerAllowed = false;
        int requestedLSPEncodingType = 0;
        int requestedSwitchingType = 0;
        int interDomainLinksSwitchingType = 150;
        int interDomainLinksEncodingType = 8;
        boolean interLayerComputation = false;
        if (req.getInterLayer() != null && (interLayerAllowed = req.getInterLayer().isIFlag())) {
            this.log.info("InterLayer Allowed!");
        }
        this.log.info("Vamos a comprobar SwitchLayer");
        if (req.getSwitchLayer() != null) {
            switchLayerPresent = true;
            if (req.getSwitchLayer().getSwitchLayers().size() >= 1 && ((SwitchEncodingType)req.getSwitchLayer().getSwitchLayers().getFirst()).isIflag()) {
                requestedLSPEncodingType = ((SwitchEncodingType)req.getSwitchLayer().getSwitchLayers().getFirst()).getLSPEncodingType();
                this.log.info("LSP Encoding Type: " + requestedLSPEncodingType);
                requestedSwitchingType = ((SwitchEncodingType)req.getSwitchLayer().getSwitchLayers().getFirst()).getSwitchingType();
                this.log.info("LSP Switching Type: " + requestedSwitchingType);
            }
        }
        if (switchLayerPresent && requestedSwitchingType != interDomainLinksSwitchingType && interLayerAllowed) {
            interLayerComputation = true;
        }
        int i = 0;
        Inet4Address destIP = null;
        EndPointsIPv4 endpointsRequest = null;
        if (EP.getOT() != 1) {
            this.createNoPath(m_resp);
            return m_resp;
        }
        endpointsRequest = new EndPointsIPv4();
        endpointsRequest.setSourceIP(source_router_id_addr);
        destIP = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id();
        endpointsRequest.setDestIP(destIP);
        Inet4Address domain = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSource();
        this.log.info("First part of the LSP is in domain: " + domain + " from " + source_router_id_addr + " to " + destIP);
        boolean first_domain_equal = false;
        if (source_router_id_addr.equals(destIP)) {
            this.log.info("Origin and destination are the same");
            first_domain_equal = true;
        } else {
            PCEPRequest pcreqToFirstDomain = new PCEPRequest();
            if (this.pathReq.getMonitoring() != null) {
                pcreqToFirstDomain.setMonitoring(this.pathReq.getMonitoring());
            }
            if (this.pathReq.getPccReqId() != null) {
                pcreqToFirstDomain.setPccReqId(this.pathReq.getPccReqId());
            }
            Request requestToFirstDomain = new Request();
            this.addXRO(req.getXro(), requestToFirstDomain);
            requestToFirstDomain.setEndPoints((EndPoints)endpointsRequest);
            RequestParameters rpFirstDomain = new RequestParameters();
            requestID = ParentPCESession.getNewReqIDCounter();
            rpFirstDomain.setRequestID(requestID);
            rpFirstDomain.setPbit(true);
            InterLayer interLayerFirstDomain = new InterLayer();
            interLayerFirstDomain.setIFlag(false);
            SwitchLayer switchLayerFirstDomain = new SwitchLayer();
            set = new SwitchEncodingType();
            switchLayerFirstDomain.getSwitchLayers().add(set);
            if (interLayerComputation) {
                set.setLSPEncodingType(requestedLSPEncodingType);
                set.setSwitchingType(requestedSwitchingType);
            } else {
                set.setLSPEncodingType(interDomainLinksEncodingType);
                set.setSwitchingType(interDomainLinksSwitchingType);
            }
            set.setIflag(true);
            requestToFirstDomain.setInterLayer(interLayerFirstDomain);
            requestToFirstDomain.setSwitchLayer(switchLayerFirstDomain);
            requestToFirstDomain.setRequestParameters(rpFirstDomain);
            pcreqToFirstDomain.addRequest(requestToFirstDomain);
            reqList.add(pcreqToFirstDomain);
            domainList.add(domain);
            this.log.info("Sending 1st request to domain " + domain);
        }
        for (i = 1; i < edge_list.size(); ++i) {
            domain = (Inet4Address)((InterDomainEdge)edge_list.get(i)).getSource();
            if (EP.getOT() == 1) {
                endpointsRequest = new EndPointsIPv4();
                endpointsRequest.setSourceIP((Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id());
                endpointsRequest.setDestIP((Inet4Address)((InterDomainEdge)edge_list.get(i)).getSrc_router_id());
            } else if (EP.getOT() == 2) {
                // empty if block
            }
            if (EP.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                if (gep.getGeneralizedEndPointsType() == 0) {
                    EndPointIPv4TLV sourceIPv4TLV = new EndPointIPv4TLV();
                    EndPointIPv4TLV destIPv4TLV = new EndPointIPv4TLV();
                    sourceIPv4TLV.setIPv4address((Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id());
                    destIP = (Inet4Address)((InterDomainEdge)edge_list.get(i)).getSrc_router_id();
                    destIPv4TLV.setIPv4address(destIP);
                    EndPoint sourceEP = new EndPoint();
                    EndPoint destEP = new EndPoint();
                    sourceEP.setEndPointIPv4TLV(sourceIPv4TLV);
                    destEP.setEndPointIPv4TLV(destIPv4TLV);
                    P2PEndpoints p2pep = new P2PEndpoints();
                    p2pep.setSourceEndpoint(sourceEP);
                    p2pep.setDestinationEndPoints(destEP);
                    endpointsRequest = new GeneralizedEndPoints();
                    ((GeneralizedEndPoints)endpointsRequest).setP2PEndpoints(p2pep);
                }
                if (gep.getGeneralizedEndPointsType() == 1) {
                    // empty if block
                }
            }
            this.log.info("New part of the LSP is in domain: " + domain + " from " + ((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id() + " to " + ((InterDomainEdge)edge_list.get(i)).getSrc_router_id());
            PCEPRequest pcreq = new PCEPRequest();
            if (this.pathReq.getMonitoring() != null) {
                pcreq.setMonitoring(this.pathReq.getMonitoring());
            }
            if (this.pathReq.getPccReqId() != null) {
                pcreq.setPccReqId(this.pathReq.getPccReqId());
            }
            Request request = new Request();
            this.addXRO(req.getXro(), request);
            request.setEndPoints((EndPoints)endpointsRequest);
            RequestParameters rp2 = new RequestParameters();
            requestID = ParentPCESession.getNewReqIDCounter();
            rp2.setRequestID(requestID);
            rp2.setPbit(true);
            request.setRequestParameters(rp2);
            InterLayer interLayer = new InterLayer();
            interLayer.setIFlag(false);
            SwitchLayer switchLayer = new SwitchLayer();
            set = new SwitchEncodingType();
            switchLayer.getSwitchLayers().add(set);
            set.setLSPEncodingType(interDomainLinksEncodingType);
            set.setSwitchingType(interDomainLinksSwitchingType);
            set.setIflag(true);
            request.setInterLayer(interLayer);
            request.setSwitchLayer(switchLayer);
            pcreq.addRequest(request);
            reqList.add(pcreq);
            domainList.add(domain);
            this.log.info("Sending request " + i + " to domain " + domain);
        }
        EndPointsIPv4 endpointsLastDomain = null;
        Inet4Address Last_domain = (Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getTarget();
        Inet4Address last_source_IP = (Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id();
        this.log.info("Last part of the LSP is in domain: " + Last_domain + " from " + last_source_IP + " to " + dest_router_id_addr);
        if (EP.getOT() == 1) {
            endpointsLastDomain = new EndPointsIPv4();
            endpointsLastDomain.setDestIP(dest_router_id_addr);
            endpointsLastDomain.setSourceIP(last_source_IP);
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                EndPointIPv4TLV sourceIPv4TLV = new EndPointIPv4TLV();
                EndPointIPv4TLV destIPv4TLV = new EndPointIPv4TLV();
                sourceIPv4TLV.setIPv4address(last_source_IP);
                destIPv4TLV.setIPv4address(dest_router_id_addr);
                EndPoint sourceEP = new EndPoint();
                EndPoint destEP = new EndPoint();
                sourceEP.setEndPointIPv4TLV(sourceIPv4TLV);
                destEP.setEndPointIPv4TLV(destIPv4TLV);
                P2PEndpoints p2pep = new P2PEndpoints();
                p2pep.setSourceEndpoint(sourceEP);
                p2pep.setDestinationEndPoints(destEP);
                endpointsLastDomain = new GeneralizedEndPoints();
                ((GeneralizedEndPoints)endpointsLastDomain).setP2PEndpoints(p2pep);
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                // empty if block
            }
        }
        PCEPRequest pcreqToLastDomain = new PCEPRequest();
        if (this.pathReq.getMonitoring() != null) {
            pcreqToLastDomain.setMonitoring(this.pathReq.getMonitoring());
        }
        if (this.pathReq.getPccReqId() != null) {
            pcreqToLastDomain.setPccReqId(this.pathReq.getPccReqId());
        }
        Request requestToLastDomain = new Request();
        this.addXRO(req.getXro(), requestToLastDomain);
        requestToLastDomain.setEndPoints((EndPoints)endpointsLastDomain);
        RequestParameters rpLastDomain = new RequestParameters();
        requestID = ParentPCESession.getNewReqIDCounter();
        rpLastDomain.setRequestID(requestID);
        rpLastDomain.setPbit(true);
        requestToLastDomain.setRequestParameters(rpLastDomain);
        InterLayer interLayerToLastDomain = new InterLayer();
        interLayerToLastDomain.setIFlag(false);
        SwitchLayer switchLayerToLastDomain = new SwitchLayer();
        SwitchEncodingType setToLastDomain = new SwitchEncodingType();
        switchLayerToLastDomain.getSwitchLayers().add(setToLastDomain);
        if (interLayerComputation) {
            setToLastDomain.setLSPEncodingType(requestedLSPEncodingType);
            setToLastDomain.setSwitchingType(requestedSwitchingType);
        } else {
            setToLastDomain.setLSPEncodingType(interDomainLinksEncodingType);
            setToLastDomain.setSwitchingType(interDomainLinksSwitchingType);
        }
        setToLastDomain.setIflag(true);
        requestToLastDomain.setInterLayer(interLayerToLastDomain);
        requestToLastDomain.setSwitchLayer(switchLayerToLastDomain);
        pcreqToLastDomain.addRequest(requestToLastDomain);
        this.log.info("Sending last request to domain " + edge_list.get(i - 1));
        reqList.add(pcreqToLastDomain);
        domainList.add(Last_domain);
        long tiempo3 = System.nanoTime();
        try {
            respList = this.childPCERequestManager.executeRequests(reqList, domainList);
        }
        catch (Exception e) {
            this.log.error("PROBLEM SENDING THE REQUESTS");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            NoPathTLV noPathTLV3 = new NoPathTLV();
            noPath2.setNoPathTLV(noPathTLV3);
            response.setNoPath(noPath2);
            return m_resp;
        }
        Path path = new Path();
        ExplicitRouteObject ero = new ExplicitRouteObject();
        int j = 0;
        if (first_domain_equal) {
            IPv4prefixEROSubobject sobjt4 = new IPv4prefixEROSubobject();
            sobjt4.setIpv4address(source_router_id_addr);
            sobjt4.setPrefix(32);
            ero.addEROSubobject((EROSubobject)sobjt4);
            UnnumberIfIDEROSubobject idLink = new UnnumberIfIDEROSubobject();
            idLink.setInterfaceID(((InterDomainEdge)edge_list.get(0)).getSrc_if_id());
            idLink.setRouterID((Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id());
            ero.addEROSubobject((EROSubobject)idLink);
            ++j;
        }
        boolean childrenFailed = false;
        for (i = 0; i < respList.size(); ++i) {
            if (respList.get(i) == null) {
                childrenFailed = true;
                continue;
            }
            if (respList.get(i).getResponse(0).getNoPath() != null) {
                this.log.info("ALGUIEN RESPONDIO NOPATH");
                childrenFailed = true;
                continue;
            }
            ExplicitRouteObject eroInternal = respList.get(i).getResponse(0).getPath(0).geteRO();
            this.log.info(" eroInternal " + eroInternal.toString());
            ero.addEROSubobjectList(eroInternal.EROSubobjectList);
            UnnumberIfIDEROSubobject unnumberIfDEROSubobj = new UnnumberIfIDEROSubobject();
            if (edge_list == null || j >= edge_list.size()) continue;
            unnumberIfDEROSubobj.setInterfaceID(((InterDomainEdge)edge_list.get(j)).getSrc_if_id());
            unnumberIfDEROSubobj.setRouterID((Inet4Address)((InterDomainEdge)edge_list.get(j)).getSrc_router_id());
            this.log.info(" eroExternal " + unnumberIfDEROSubobj.toString());
            ero.addEROSubobject((EROSubobject)unnumberIfDEROSubobj);
            ++j;
        }
        if (childrenFailed) {
            this.log.warn("Some child has failed");
            NoPath noPath2 = new NoPath();
            response.setNoPath(noPath2);
        } else {
            path.setEro(ero);
            response.addPath(path);
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        Monitoring monitoring = this.pathReq.getMonitoring();
        if (monitoring == null || monitoring.isProcessingTimeBit()) {
            // empty if block
        }
        return m_resp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return null;
    }

    public void addXRO(ExcludeRouteObject xro, Request req) {
        req.setXro(xro);
    }

    private void createNoPath(ComputingResponse m_resp) {
        NoPath noPath = new NoPath();
        noPath.setNatureOfIssue(0);
        NoPathTLV noPathTLV = new NoPathTLV();
        noPath.setNoPathTLV(noPathTLV);
        noPathTLV.setPCEunavailable(true);
        m_resp.getResponseList().getFirst().setNoPath(noPath);
    }
}

