/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.sson.AURE_FF_SSON_algorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.sson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.utilities.bandwidthToSlotConversion;
import es.tid.pce.computingEngine.algorithms.utilities.graphs_comparator;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.GeneralizedBandwidthSSON;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AURE_FF_SSON_algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private AURE_FF_SSON_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private SSONInformation SSONInfo;
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;

    public AURE_FF_SSON_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, int mf) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        this.log.debug("Starting AURE Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        BandwidthRequested Bw = (BandwidthRequested)req.getBandwidth();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        graphs_comparator grc = new graphs_comparator();
        int num_slots = 0;
        int m = 0;
        bandwidthToSlotConversion conversion = new bandwidthToSlotConversion();
        if (Bw.getBw() != 0.0f) {
            this.SSONInfo = this.ted.getSSONinfo();
            int cs = this.SSONInfo.getCs();
            num_slots = conversion.getNumSlots(Bw.getBw(), cs);
        }
        this.log.info("Request num_slots: " + num_slots);
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.debug("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        boolean nopath = true;
        boolean end = false;
        int lambda = 0;
        int lambda_chosen = 0;
        int central_freq = 0;
        int counter = 0;
        boolean is_equal = false;
        this.log.debug("Starting the computation");
        GraphPath gp_chosen = null;
        GraphPath gp_trully_chosen = null;
        this.preComp.getGraphLock().lock();
        try {
            while (!end) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getNetworkGraphs().get(lambda);
                DijkstraShortestPath dsp = new DijkstraShortestPath(graphLambda, (Object)source_router_id_addr, (Object)dest_router_id_addr);
                GraphPath gp = dsp.getPath();
                if (gp == null) {
                    counter = 0;
                    if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                        if (nopath) {
                            this.log.debug("No path found");
                            NoPath noPath = new NoPath();
                            noPath.setNatureOfIssue(0);
                            NoPathTLV noPathTLV = new NoPathTLV();
                            noPath.setNoPathTLV(noPathTLV);
                            response.setNoPath(noPath);
                            ComputingResponse computingResponse = m_resp;
                            return computingResponse;
                        }
                        end = true;
                        continue;
                    }
                    ++lambda;
                    continue;
                }
                if (counter == 0) {
                    if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                        if (nopath) {
                            this.log.debug("No path found");
                            NoPath noPath = new NoPath();
                            noPath.setNatureOfIssue(0);
                            NoPathTLV noPathTLV = new NoPathTLV();
                            noPath.setNoPathTLV(noPathTLV);
                            response.setNoPath(noPath);
                            ComputingResponse computingResponse = m_resp;
                            return computingResponse;
                        }
                        end = true;
                        continue;
                    }
                    this.log.info("LAMBDA " + lambda + " with metric " + gp.getWeight());
                    gp_chosen = gp;
                    ++counter;
                    lambda_chosen = ++lambda;
                    end = false;
                    continue;
                }
                is_equal = grc.edges_comparator((GraphPath<Object, IntraDomainEdge>)gp, gp_chosen);
                if (is_equal) {
                    if (++counter == num_slots) {
                        gp_trully_chosen = gp;
                        central_freq = lambda - (num_slots - 1) / 2;
                        m = num_slots / 2;
                        counter = 0;
                        this.log.info("Central Frequency" + central_freq);
                        this.log.info("Frequency width" + m);
                        this.log.info("Path" + gp_trully_chosen);
                        nopath = false;
                        end = true;
                        if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                            nopath = false;
                            end = true;
                            continue;
                        }
                        ++lambda;
                        continue;
                    }
                    if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                        if (nopath) {
                            this.log.debug("No path found");
                            NoPath noPath = new NoPath();
                            noPath.setNatureOfIssue(0);
                            NoPathTLV noPathTLV = new NoPathTLV();
                            noPath.setNoPathTLV(noPathTLV);
                            response.setNoPath(noPath);
                            ComputingResponse computingResponse = m_resp;
                            return computingResponse;
                        }
                        end = true;
                        continue;
                    }
                    lambda_chosen = ++lambda;
                    continue;
                }
                counter = 0;
                gp_chosen = null;
                this.log.info("Camino Distinto en lambda " + lambda);
                if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                    if (nopath) {
                        this.log.debug("No path found");
                        NoPath noPath = new NoPath();
                        noPath.setNatureOfIssue(0);
                        NoPathTLV noPathTLV = new NoPathTLV();
                        noPath.setNoPathTLV(noPathTLV);
                        response.setNoPath(noPath);
                        ComputingResponse computingResponse = m_resp;
                        return computingResponse;
                    }
                    end = true;
                    continue;
                }
                end = false;
            }
        }
        finally {
            this.preComp.getGraphLock().unlock();
        }
        if (!nopath) {
            int i;
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_trully_chosen.getEdgeList();
            for (i = 0; i < edge_list.size(); ++i) {
                UnnumberIfIDEROSubobject eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                eroso.setLoosehop(false);
                ero.addEROSubobject((EROSubobject)eroso);
                DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                WDMlabel.setGrid(this.preComp.getSSONInfo().getGrid());
                WDMlabel.setChannelSpacing(this.preComp.getSSONInfo().getCs());
                WDMlabel.setN(central_freq + this.preComp.getSSONInfo().getnMin());
                WDMlabel.setIdentifier(0);
                try {
                    WDMlabel.encode();
                }
                catch (RSVPProtocolViolationException e) {
                    e.printStackTrace();
                }
                GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                ero.addEROSubobject((EROSubobject)genLabel);
                genLabel.setLabel(WDMlabel.getBytes());
            }
            BandwidthRequestedGeneralizedBandwidth gw = new BandwidthRequestedGeneralizedBandwidth();
            GeneralizedBandwidthSSON GB_SSON = new GeneralizedBandwidthSSON();
            GB_SSON.setM(m);
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            path.setBandwidth((Bandwidth)gw);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
            LinkedList<Object> targetVertexList = new LinkedList<Object>();
            for (i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
            }
            sourceVertexList.add(((IntraDomainEdge)edge_list.get(i - 1)).getSource());
            targetVertexList.add(((IntraDomainEdge)edge_list.get(i - 1)).getTarget());
            if (req.getReservation() != null) {
                this.reserv = new GenericLambdaReservation();
                this.reserv.setResp(m_resp);
                this.reserv.setLambda_chosen(central_freq);
                this.reserv.setBidirectional(req.getRequestParameters().isBidirect());
                this.reserv.setReservation(req.getReservation());
                this.reserv.setSourceVertexList(sourceVertexList);
                this.reserv.setTargetVertexList(targetVertexList);
                this.reserv.setReservationManager(this.reservationManager);
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(AURE_FF_SSON_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

