/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import java.util.Arrays;

public class BitmapChannelState {
    private byte[] bytesBitmap;
    private int length;
    private int sumBitsBitmap;

    public BitmapChannelState() {
    }

    public BitmapChannelState(int num_channels) {
        this.setLength(num_channels);
        this.bytesBitmap = new byte[this.length / 8 + 1];
    }

    public byte[] getBytesBitmap() {
        return this.bytesBitmap;
    }

    public void arraycopyBytesBitmap(byte[] bytesBitmap) {
        System.arraycopy(bytesBitmap, 0, this.bytesBitmap, 0, bytesBitmap.length);
    }

    public void setBytesBitmap(byte[] bytesBitmap) {
        this.bytesBitmap = bytesBitmap;
    }

    public int getNumberBytes() {
        return this.bytesBitmap.length;
    }

    public int getNumberBytes(int num) {
        int numberBytes = num / 8;
        if (numberBytes * 8 < num) {
            ++numberBytes;
        }
        return numberBytes;
    }

    public void Initialize() {
        for (int i = 0; i < (this.length / 8 + 1) * 8; ++i) {
            if (i >= this.length) {
                if (i % 8 > this.length % 8) {
                    this.bytesBitmap[i / 8] = (byte)(this.bytesBitmap[i / 8] & 254 << 8 - i % 8);
                    continue;
                }
                this.bytesBitmap[i / 8] = -1;
                continue;
            }
            this.bytesBitmap[i / 8] = -1;
        }
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    private boolean equalsBytes(byte[] bytes1, byte[] bytes2) {
        for (int i = 0; i < bytes1.length; ++i) {
            if ((bytes1[i] | bytes2[i]) == bytes1[i]) continue;
            return false;
        }
        return true;
    }

    public int getSumaBits() {
        this.sumBitsBitmap = 0;
        for (int i = 0; i < this.bytesBitmap.length * 8; ++i) {
            if ((this.bytesBitmap[i / 8] & 128 >> i % 8) != 128 >> i % 8) continue;
            ++this.sumBitsBitmap;
        }
        return this.sumBitsBitmap;
    }

    public String toString() {
        return "BitmapChannelState [bytesBitmap=" + Arrays.toString(this.bytesBitmap) + ", length=" + this.length + "]";
    }
}

