/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.sson.BitmapChannelState;
import es.tid.pce.computingEngine.algorithms.sson.CrossComponentIteratorModified;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class ClosestFirstIteratorModified<V, E>
extends CrossComponentIteratorModified<V, E, FibonacciHeapNode<QueueEntry<V, E>>> {
    private FibonacciHeap<QueueEntry<V, E>> heap = new FibonacciHeap();
    private double radius = Double.POSITIVE_INFINITY;
    private boolean initialized = false;

    public ClosestFirstIteratorModified(Graph<V, E> g) {
        this(g, null);
    }

    public ClosestFirstIteratorModified(Graph<V, E> g, V startVertex) {
        this(g, startVertex, Double.POSITIVE_INFINITY);
    }

    public ClosestFirstIteratorModified(Graph<V, E> g, V startVertex, double radius) {
        super(g, startVertex);
        System.out.print("WEE");
        this.radius = radius;
        this.checkRadiusTraversal(this.isCrossComponentTraversal());
        this.initialized = true;
    }

    public ClosestFirstIteratorModified(Graph<V, E> g, V startVertex, double radius, ArrayList<BitmapLabelSet> SetChannels, int num_slots) {
        super(g, startVertex, SetChannels, num_slots);
        this.radius = radius;
        this.checkRadiusTraversal(this.isCrossComponentTraversal());
        this.initialized = true;
    }

    public void setCrossComponentTraversal(boolean crossComponentTraversal) {
        if (this.initialized) {
            this.checkRadiusTraversal(crossComponentTraversal);
        }
        super.setCrossComponentTraversal(crossComponentTraversal);
    }

    public double getShortestPathLength(V vertex) {
        FibonacciHeapNode node = (FibonacciHeapNode)this.getSeenData(vertex);
        if (node == null) {
            return Double.POSITIVE_INFINITY;
        }
        return node.getKey();
    }

    public E getSpanningTreeEdge(V vertex) {
        FibonacciHeapNode node = (FibonacciHeapNode)this.getSeenData(vertex);
        if (node == null) {
            return null;
        }
        return ((QueueEntry)node.getData()).spanningTreeEdge;
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        if (this.heap.size() == 0) {
            return true;
        }
        if (this.heap.min().getKey() > this.radius) {
            this.heap.clear();
            return true;
        }
        return false;
    }

    @Override
    protected void encounterVertex(V vertex, E edge) {
        double shortestPathLength = edge == null ? 0.0 : this.calculatePathLength(vertex, edge);
        FibonacciHeapNode<QueueEntry<V, E>> node = this.createSeenData(vertex, edge);
        this.putSeenData(vertex, node);
        this.heap.insert(node, shortestPathLength);
    }

    @Override
    protected boolean encounterVertexAgain(V vertex, E edge) {
        FibonacciHeapNode node = (FibonacciHeapNode)this.getSeenData(vertex);
        if (((QueueEntry)node.getData()).frozen) {
            return false;
        }
        double candidatePathLength = this.calculatePathLength(vertex, edge);
        if (this.vertexSpectrumState.get(vertex).getSumaBits() == 0) {
            ((QueueEntry)node.getData()).spanningTreeEdge = edge;
            this.heap.decreaseKey(node, candidatePathLength);
            return true;
        }
        if (candidatePathLength < node.getKey()) {
            ((QueueEntry)node.getData()).spanningTreeEdge = edge;
            this.heap.decreaseKey(node, candidatePathLength);
            return true;
        }
        return false;
    }

    @Override
    protected V provideNextVertex() {
        FibonacciHeapNode node = this.heap.removeMin();
        ((QueueEntry)node.getData()).frozen = true;
        return ((QueueEntry)node.getData()).vertex;
    }

    private void assertNonNegativeEdge(E edge) {
        if (this.getGraph().getEdgeWeight(edge) < 0.0) {
            throw new IllegalArgumentException("negative edge weights not allowed");
        }
    }

    private double calculatePathLength(V vertex, E edge) {
        this.assertNonNegativeEdge(edge);
        Object otherVertex = Graphs.getOppositeVertex(this.getGraph(), edge, vertex);
        FibonacciHeapNode otherEntry = (FibonacciHeapNode)this.getSeenData(otherVertex);
        return otherEntry.getKey() + this.getGraph().getEdgeWeight(edge);
    }

    private void checkRadiusTraversal(boolean crossComponentTraversal) {
        if (crossComponentTraversal && this.radius != Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("radius may not be specified for cross-component traversal");
        }
    }

    private FibonacciHeapNode<QueueEntry<V, E>> createSeenData(V vertex, E edge) {
        QueueEntry entry = new QueueEntry();
        entry.vertex = vertex;
        entry.spanningTreeEdge = edge;
        return new FibonacciHeapNode(entry);
    }

    @Override
    public Hashtable<Object, BitmapChannelState> getVertexSpectrumState() {
        super.getVertexSpectrumState();
        return this.vertexSpectrumState;
    }

    static class QueueEntry<V, E> {
        E spanningTreeEdge;
        V vertex;
        boolean frozen;

        QueueEntry() {
        }
    }
}

