/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.sson.BitmapChannelState;
import es.tid.tedb.IntraDomainEdge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrossComponentIteratorModified<V, E, D>
extends AbstractGraphIterator<V, E> {
    private static final int CCS_BEFORE_COMPONENT = 1;
    private static final int CCS_WITHIN_COMPONENT = 2;
    private static final int CCS_AFTER_COMPONENT = 3;
    private final ConnectedComponentTraversalEvent ccFinishedEvent = new ConnectedComponentTraversalEvent((Object)this, 32);
    private final ConnectedComponentTraversalEvent ccStartedEvent = new ConnectedComponentTraversalEvent((Object)this, 31);
    private FlyweightEdgeEvent<V, E> reusableEdgeEvent;
    private FlyweightVertexEvent<V> reusableVertexEvent;
    private Iterator<V> vertexIterator = null;
    protected Hashtable<Object, BitmapChannelState> vertexSpectrumState;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private int numChannels;
    private int num_slots;
    private ArrayList<BitmapLabelSet> SetChannels;
    private Map<V, D> seen = new HashMap<V, D>();
    private V startVertex;
    private Specifics<V, E> specifics;
    private final Graph<V, E> graph;
    private int state = 1;

    public CrossComponentIteratorModified(Graph<V, E> g, V startVertex) {
        if (g == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.graph = g;
        this.specifics = CrossComponentIteratorModified.createGraphSpecifics(g);
        this.vertexIterator = g.vertexSet().iterator();
        while (this.vertexIterator.hasNext()) {
        }
        this.setCrossComponentTraversal(startVertex == null);
        this.reusableEdgeEvent = new FlyweightEdgeEvent((Object)this, null);
        this.reusableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, null);
        if (startVertex == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (g.containsVertex(startVertex)) {
            this.startVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public CrossComponentIteratorModified(Graph<V, E> g, V startVertex, ArrayList<BitmapLabelSet> SetChannels, int num_slots) {
        if (g == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.num_slots = num_slots;
        this.graph = g;
        this.numChannels = SetChannels.size();
        this.specifics = CrossComponentIteratorModified.createGraphSpecifics(g);
        Iterator iterFiberLink = g.edgeSet().iterator();
        this.vertexIterator = g.vertexSet().iterator();
        this.vertexSpectrumState = new Hashtable(g.vertexSet().size());
        this.SetChannels = SetChannels;
        while (this.vertexIterator.hasNext()) {
            BitmapChannelState Bitmap = new BitmapChannelState(this.numChannels);
            Bitmap.Initialize();
            this.vertexSpectrumState.put(this.vertexIterator.next(), Bitmap);
        }
        this.setCrossComponentTraversal(startVertex == null);
        this.reusableEdgeEvent = new FlyweightEdgeEvent((Object)this, null);
        this.reusableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, null);
        if (startVertex == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (g.containsVertex(startVertex)) {
            this.startVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public boolean hasNext() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.state == 2) {
                this.state = 3;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentFinished(this.ccFinishedEvent);
                }
            }
            if (this.isCrossComponentTraversal()) {
                while (this.vertexIterator.hasNext()) {
                    V v = this.vertexIterator.next();
                    if (this.isSeenVertex(v)) continue;
                    this.encounterVertex(v, null);
                    this.state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public V next() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.state == 1) {
                this.state = 2;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentStarted(this.ccStartedEvent);
                }
            }
            V nextvertex = this.provideNextVertex();
            if (this.nListeners != 0) {
                this.fireVertexTraversed(this.createVertexTraversalEvent(nextvertex));
            }
            this.spectrumAvailabilityCheckout(nextvertex, this.SetChannels);
            return nextvertex;
        }
        throw new NoSuchElementException();
    }

    protected abstract boolean isConnectedComponentExhausted();

    protected abstract void encounterVertex(V var1, E var2);

    protected abstract V provideNextVertex();

    protected D getSeenData(V vertex) {
        return this.seen.get(vertex);
    }

    protected boolean isSeenVertex(Object vertex) {
        return this.seen.containsKey(vertex);
    }

    protected abstract boolean encounterVertexAgain(V var1, E var2);

    protected D putSeenData(V vertex, D data) {
        return this.seen.put(vertex, data);
    }

    protected void finishVertex(V vertex) {
        if (this.nListeners != 0) {
            this.fireVertexFinished(this.createVertexTraversalEvent(vertex));
        }
    }

    static <V, E> Specifics<V, E> createGraphSpecifics(Graph<V, E> g) {
        if (g instanceof DirectedGraph) {
            return new DirectedSpecifics((DirectedGraph)g);
        }
        return new UndirectedSpecifics<V, E>(g);
    }

    private void addUnseenChildrenOf(V vertex) {
        for (E edge : this.specifics.edgesOf(vertex)) {
            Object oppositeV;
            if (this.nListeners != 0) {
                this.fireEdgeTraversed(this.createEdgeTraversalEvent(edge));
            }
            if (this.isSeenVertex(oppositeV = Graphs.getOppositeVertex(this.graph, edge, vertex))) {
                this.encounterVertexAgain(oppositeV, edge);
                continue;
            }
            this.encounterVertex(oppositeV, edge);
        }
    }

    private void spectrumAvailabilityCheckout(V vertex, ArrayList<BitmapLabelSet> SetChannels) {
        BitmapLabelSet bitmapAcc = new BitmapLabelSet();
        BitmapChannelState newState = new BitmapChannelState(this.vertexSpectrumState.get(vertex).getLength());
        byte[] comparator = new byte[SetChannels.get(0).getNumberBytes()];
        for (E edge : this.specifics.edgesOf(vertex)) {
            byte[] setBytesBitmap;
            int j;
            if (((BitmapLabelSet)((IntraDomainEdge)edge).getTE_info().getAvailableLabels().getLabelSet()).getSumaBits() < this.num_slots) continue;
            if (this.nListeners != 0) {
                this.fireEdgeTraversed(this.createEdgeTraversalEvent(edge));
            }
            for (int i = 0; i < SetChannels.size(); ++i) {
                if ((this.vertexSpectrumState.get(vertex).getBytesBitmap()[i / 8] & 128 >> i % 8) != 128 >> i % 8) continue;
                for (j = 0; j < SetChannels.get(i).getNumberBytes(); ++j) {
                    comparator[j] = (byte)(~(SetChannels.get(i).getBytesBitMap()[j] | (((BitmapLabelSet)((IntraDomainEdge)edge).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitMap()[j] | ((BitmapLabelSet)((IntraDomainEdge)edge).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[j])));
                    bitmapAcc.setBytesBitmap(comparator);
                }
                if (bitmapAcc.getSumaBits() != SetChannels.get(i).getNumberBytes() * 8 - SetChannels.get(i).getSumaBits()) continue;
                newState.getBytesBitmap()[i / 8] = (byte)(newState.getBytesBitmap()[i / 8] | 128 >> i % 8);
            }
            if (newState.getSumaBits() > 0) {
                Object oppositeV = Graphs.getOppositeVertex(this.graph, edge, vertex);
                if (this.isSeenVertex(oppositeV)) {
                    boolean updated = this.encounterVertexAgain(oppositeV, edge);
                    if (updated) {
                        this.VertexspectrumAvailabilityUpdate(oppositeV, newState);
                    }
                } else {
                    this.VertexspectrumAvailabilityUpdate(oppositeV, newState);
                    this.encounterVertex(oppositeV, edge);
                }
            } else {
                setBytesBitmap = new byte[newState.getNumberBytes()];
                for (j = 0; j < newState.getNumberBytes(); ++j) {
                    setBytesBitmap[j] = 0;
                }
                newState.setBytesBitmap(setBytesBitmap);
                Object oppositeV = Graphs.getOppositeVertex(this.graph, edge, vertex);
                if (!this.isSeenVertex(oppositeV)) {
                    this.VertexspectrumAvailabilityUpdate(oppositeV, newState);
                }
            }
            setBytesBitmap = new byte[newState.getNumberBytes()];
            for (j = 0; j < newState.getNumberBytes(); ++j) {
                setBytesBitmap[j] = 0;
            }
            newState.setBytesBitmap(setBytesBitmap);
        }
    }

    private void VertexspectrumAvailabilityUpdate(V vertex, BitmapChannelState newState) {
        this.vertexSpectrumState.get(vertex).arraycopyBytesBitmap(newState.getBytesBitmap());
    }

    private EdgeTraversalEvent<V, E> createEdgeTraversalEvent(E edge) {
        if (this.isReuseEvents()) {
            this.reusableEdgeEvent.setEdge(edge);
            return this.reusableEdgeEvent;
        }
        return new EdgeTraversalEvent((Object)this, edge);
    }

    private VertexTraversalEvent<V> createVertexTraversalEvent(V vertex) {
        if (this.isReuseEvents()) {
            this.reusableVertexEvent.setVertex(vertex);
            return this.reusableVertexEvent;
        }
        return new VertexTraversalEvent((Object)this, vertex);
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.startVertex, null);
        this.startVertex = null;
    }

    public Hashtable<Object, BitmapChannelState> getVertexSpectrumState() {
        return this.vertexSpectrumState;
    }

    public void setVertexSpectrumState(Hashtable<Object, BitmapChannelState> vertexSpectrumState) {
        this.vertexSpectrumState = vertexSpectrumState;
    }

    private static class UndirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private Graph<VV, EE> graph;

        public UndirectedSpecifics(Graph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<EE> edgesOf(VV vertex) {
            return this.graph.edgesOf(vertex);
        }
    }

    private static class DirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private DirectedGraph<VV, EE> graph;

        public DirectedSpecifics(DirectedGraph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<? extends EE> edgesOf(VV vertex) {
            return this.graph.outgoingEdgesOf(vertex);
        }
    }

    static class FlyweightVertexEvent<VV>
    extends VertexTraversalEvent<VV> {
        private static final long serialVersionUID = 3834024753848399924L;

        public FlyweightVertexEvent(Object eventSource, VV vertex) {
            super(eventSource, vertex);
        }

        protected void setVertex(VV vertex) {
            this.vertex = vertex;
        }
    }

    static class FlyweightEdgeEvent<VV, localE>
    extends EdgeTraversalEvent<VV, localE> {
        private static final long serialVersionUID = 4051327833765000755L;

        public FlyweightEdgeEvent(Object eventSource, localE edge) {
            super(eventSource, edge);
        }

        protected void setEdge(localE edge) {
            this.edge = edge;
        }
    }

    static abstract class Specifics<VV, EE> {
        Specifics() {
        }

        public abstract Set<? extends EE> edgesOf(VV var1);
    }

    static interface SimpleContainer<T> {
        public boolean isEmpty();

        public void add(T var1);

        public T remove();
    }

    protected static enum VisitColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

