/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.sson.BitmapChannelState;
import es.tid.pce.computingEngine.algorithms.sson.Dynamic_RSAPreComputation;
import es.tid.pce.computingEngine.algorithms.sson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.sson.ModifiedDijkstraSP;
import es.tid.pce.computingEngine.algorithms.utilities.bandwidthToSlotConversion;
import es.tid.pce.computingEngine.algorithms.utilities.channel_generator;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.GeneralizedBandwidth;
import es.tid.pce.pcep.constructs.GeneralizedBandwidthSSON;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.TEDB;
import es.tid.util.UtilsFunctions;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dynamic_RSA
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private Dynamic_RSAPreComputation preComp;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
    private ReservationManager reservationManager;
    private SSONInformation SSONInfo;
    private channel_generator genChannels;
    private ArrayList<BitmapLabelSet> setChannels;
    private DomainTEDB ted;
    private int num_slots = 0;
    private GenericLambdaReservation reserv;

    public Dynamic_RSA(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, int mf) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        this.log.info("Starting DynamicRSA Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        this.SSONInfo = new SSONInformation();
        this.SSONInfo = this.ted.getSSONinfo();
        EndPoints EP = req.getEndPoints();
        BandwidthRequested Bw = (BandwidthRequested)req.getBandwidth();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        GraphPath<Object, IntraDomainEdge> gp_chosen = null;
        boolean end = false;
        int num_labels = 0;
        int m = 0;
        boolean Bmod = false;
        num_labels = this.SSONInfo.getNumLambdas();
        this.log.info("Num_lambdas " + num_labels);
        bandwidthToSlotConversion conversion = new bandwidthToSlotConversion();
        if (Bw.getBw() != 0.0f) {
            this.SSONInfo = this.ted.getSSONinfo();
            int cs = this.SSONInfo.getCs();
            this.num_slots = conversion.getNumSlots(Bw.getBw(), cs);
        }
        this.log.info("Request num_slots: " + this.num_slots);
        this.setChannels = this.preComp.getTotalSetChannels().get(this.num_slots - 1);
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.info("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        if (((Object)source_router_id_addr).equals(dest_router_id_addr)) {
            this.log.info("Source and destination are the same!");
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address(source_router_id_addr);
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            if (req.getMetricList().size() != 0) {
                Metric metric = new Metric();
                metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                this.log.debug("Number of hops 0");
                float metricValue = 0.0f;
                metric.setMetricValue(metricValue);
                path.getMetricList().add(metric);
            }
            response.addPath(path);
            long tiempofin = System.nanoTime();
            long tiempotot = tiempofin - tiempoini;
            this.log.info("Ha tardado " + tiempotot + " nanosegundos");
            Monitoring monitoring = this.pathReq.getMonitoring();
            if (monitoring == null || monitoring.isProcessingTimeBit()) {
                // empty if block
            }
            m_resp.addResponse(response);
            return m_resp;
        }
        boolean nopath = true;
        int central_freq = 0;
        double max_metric = 2.147483647E9;
        this.preComp.getGraphLock().lock();
        try {
            while (!end) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getbaseSimplegraph();
                this.log.info("Antes de DSP" + this.preComp.printTopology(0));
                ModifiedDijkstraSP dsp = new ModifiedDijkstraSP(graphLambda, source_router_id_addr, dest_router_id_addr, Double.POSITIVE_INFINITY, this.setChannels, this.num_slots);
                this.log.info("Fin MDSP");
                GraphPath<Object, IntraDomainEdge> gp = dsp.getPath();
                if (gp == null) {
                    this.log.debug("No path found");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    nopath = true;
                    ComputingResponse computingResponse = m_resp;
                    return computingResponse;
                }
                BitmapChannelState valid_channels = new BitmapChannelState(dsp.getVertexSpectrumState().get(dest_router_id_addr).getLength());
                valid_channels.setBytesBitmap(dsp.getVertexSpectrumState().get(dest_router_id_addr).getBytesBitmap());
                for (int i = 0; i < valid_channels.getLength(); ++i) {
                    if ((valid_channels.getBytesBitmap()[i / 8] & 128 >> i % 8) != 128 >> i % 8) continue;
                    BitmapLabelSet chosen_channel = this.setChannels.get(i);
                    UtilsFunctions.printByte(chosen_channel.getBytesBitMap(), "Bitmap Channel " + i + ">>", this.log);
                    central_freq = i + (this.num_slots + 1) / 2;
                    break;
                }
                if (central_freq != 0) {
                    gp_chosen = gp;
                    max_metric = gp.getWeight();
                    m = this.num_slots / 2;
                    this.log.info("Central Frequency" + central_freq);
                    this.log.info("Frequency width" + m);
                    this.log.info("Path" + gp_chosen);
                    nopath = false;
                    end = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid central frequency for this request");
            }
        }
        finally {
            this.preComp.getGraphLock().unlock();
        }
        if (!nopath) {
            int i;
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_chosen.getEdgeList();
            for (i = 0; i < edge_list.size(); ++i) {
                UnnumberIfIDEROSubobject eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                eroso.setLoosehop(false);
                ero.addEROSubobject((EROSubobject)eroso);
                this.preComp.setReservation(m, central_freq + this.preComp.getWSONInfo().getnMin(), ((IntraDomainEdge)edge_list.get(i)).getSource(), ((IntraDomainEdge)edge_list.get(i)).getTarget());
                DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                WDMlabel.setN(central_freq + this.preComp.getWSONInfo().getnMin());
                WDMlabel.setIdentifier(0);
                WDMlabel.setM(m);
                try {
                    WDMlabel.encode();
                }
                catch (RSVPProtocolViolationException e) {
                    e.printStackTrace();
                }
                GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                ero.addEROSubobject((EROSubobject)genLabel);
                genLabel.setLabel(WDMlabel.getBytes());
            }
            BandwidthRequestedGeneralizedBandwidth gb = new BandwidthRequestedGeneralizedBandwidth();
            this.preComp.setTotalBandwidth((double)(m * 2) * 6.25 + this.preComp.getTotalBandwidth());
            GeneralizedBandwidthSSON GB_SSON = new GeneralizedBandwidthSSON();
            GB_SSON.setM(m);
            gb.setGeneralizedBandwidth((GeneralizedBandwidth)GB_SSON);
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            path.setBandwidth((Bandwidth)gb);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
            LinkedList<Object> targetVertexList = new LinkedList<Object>();
            for (i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
            }
            sourceVertexList.add(((IntraDomainEdge)edge_list.get(i - 1)).getSource());
            targetVertexList.add(((IntraDomainEdge)edge_list.get(i - 1)).getTarget());
            if (req.getReservation() != null) {
                this.reserv = new GenericLambdaReservation();
                this.reserv.setResp(m_resp);
                this.reserv.setLambda_chosen(central_freq);
                this.reserv.setBidirectional(req.getRequestParameters().isBidirect());
                this.reserv.setReservation(req.getReservation());
                this.reserv.setSourceVertexList(sourceVertexList);
                this.reserv.setTargetVertexList(targetVertexList);
                this.reserv.setReservationManager(this.reservationManager);
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        this.log.info("RESPONSE: " + m_resp.toString());
        return m_resp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }

    public void setPreComp(Dynamic_RSAPreComputation preComp) {
        this.preComp = preComp;
    }

    public static String toHexString(byte[] packetBytes) {
        StringBuffer sb = new StringBuffer(packetBytes.length * 2);
        for (int i = 0; i < packetBytes.length; ++i) {
            if ((packetBytes[i] & 0xFF) <= 15) {
                sb.append('0');
                sb.append(Integer.toHexString(packetBytes[i] & 0xFF));
                continue;
            }
            sb.append(Integer.toHexString(packetBytes[i] & 0xFF));
        }
        return sb.toString();
    }
}

