/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputationSSON;
import es.tid.pce.computingEngine.algorithms.utilities.channel_generator;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import es.tid.tedb.TE_Information;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dynamic_RSAPreComputation
implements ComputingAlgorithmPreComputationSSON {
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> baseSimplegraph;
    private int numLambdas;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Lock graphLock;
    private double totalBandwidth = 0.0;
    private ArrayList<ArrayList<BitmapLabelSet>> totalSetChannels;
    private DomainTEDB ted;
    private SSONInformation SSONInfo;

    @Override
    public void initialize() {
        this.log.info("initializing Dynamic_RSA Algorithm");
        this.graphLock = new ReentrantLock();
        Set nodes = this.baseSimplegraph.vertexSet();
        Set fiberEdges = this.baseSimplegraph.edgeSet();
        TE_Information tE_Info = null;
        this.networkGraphs = new ArrayList(this.numLambdas);
        SimpleDirectedWeightedGraph graphLambda = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        this.networkGraphs.add(0, (SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graphLambda);
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            graphLambda.addVertex(iter.next());
        }
        for (IntraDomainEdge fiberEdge : fiberEdges) {
            IntraDomainEdge edge = new IntraDomainEdge();
            edge.setDelay_ms(fiberEdge.getDelay_ms());
            edge.setSrc_if_id(fiberEdge.getSrc_if_id());
            edge.setDst_if_id(fiberEdge.getDst_if_id());
            tE_Info = new TE_Information();
            tE_Info.createBitmapLabelSet(this.SSONInfo.getNumLambdas(), this.SSONInfo.getGrid(), this.SSONInfo.getCs(), 0, this.SSONInfo.getnMin(), this.SSONInfo.getnMin() + this.SSONInfo.getNumLambdas());
            edge.setTE_info(tE_Info);
            graphLambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)edge);
        }
        this.totalSetChannels = new ArrayList();
        int counter = 16;
        for (int i = 0; i < counter; ++i) {
            ArrayList<BitmapLabelSet> setChannels = new ArrayList<BitmapLabelSet>(this.SSONInfo.getNumLambdas() - i + 1);
            channel_generator genChannels = new channel_generator();
            genChannels.getSetChannels(this.SSONInfo.getNumLambdas(), i + 1, setChannels);
            this.totalSetChannels.add(i, setChannels);
        }
        this.log.info("" + this.printTopology(0));
    }

    @Override
    public void setTEDB(TEDB ted) {
        try {
            this.baseSimplegraph = ((SimpleTEDB)ted).getNetworkGraph();
            this.log.info("Using SimpleTEDB");
            this.log.info(this.baseSimplegraph.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.log.info(" XXXX ted: " + ted);
        this.log.info(" XXXX (DomainTEDB)ted: " + (DomainTEDB)ted);
        this.SSONInfo = ((DomainTEDB)ted).getSSONinfo();
        this.ted = (DomainTEDB)ted;
        this.log.info(" XXXX SSONInfo: " + this.SSONInfo);
        this.log.info(" XXXX SSONInfo.getNumLambdas(): " + this.SSONInfo.getNumLambdas());
        this.numLambdas = this.SSONInfo.getNumLambdas();
        this.log.info(">>>>>Viendo informacion de copia:");
        this.log.info(this.ted.printTopology());
    }

    @Override
    public ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> getNetworkGraphs() {
        return this.networkGraphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, int m) {
        this.graphLock.lock();
        try {
            for (int j = 0; j < m * 2; ++j) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.baseSimplegraph;
                for (int i = 0; i < sourceVertexList.size(); ++i) {
                    IntraDomainEdge edge = (IntraDomainEdge)networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                    edge.getTE_info().setWavelengthReserved(wavelength - m + j);
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, int m) {
        this.graphLock.lock();
        try {
            for (int j = 0; j < m * 2; ++j) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.baseSimplegraph;
                for (int i = 0; i < sourceVertexList.size(); ++i) {
                    IntraDomainEdge edge = (IntraDomainEdge)networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                    edge.getTE_info().setWavelengthUnReserved(wavelength - m + j);
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public double getTotalBandwidth() {
        return this.totalBandwidth;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getbaseSimplegraph() {
        return this.baseSimplegraph;
    }

    public void setTotalBandwidth(double totalBandwidth) {
        this.totalBandwidth = totalBandwidth;
    }

    public Lock getGraphLock() {
        return this.graphLock;
    }

    public ArrayList<ArrayList<BitmapLabelSet>> getTotalSetChannels() {
        return this.totalSetChannels;
    }

    public void setTotalSetChannels(ArrayList<ArrayList<BitmapLabelSet>> totalSetChannels) {
        this.totalSetChannels = totalSetChannels;
    }

    public void setGraphLock(Lock graphLock) {
        this.graphLock = graphLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthStatusChange(Object source, Object destination, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        this.log.info("notifyWavelengthStatusChange in precomp");
        previousBitmapLabelSet.getNumLabels();
        int num_bytes = previousBitmapLabelSet.getBytesBitMap().length;
        int wavelength_to_occupy = -1;
        int wavelength_to_free = -1;
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.baseSimplegraph;
        this.log.info("Link antes de actualizar en el precomputo del algoritmo: " + ((IntraDomainEdge)networkGraph.getEdge(source, destination)).toString());
        try {
            this.graphLock.lock();
            for (int i = 0; i < num_bytes; ++i) {
                if (previousBitmapLabelSet.getBytesBitMap()[i] == newBitmapLabelSet.getBytesBitMap()[i]) continue;
                for (int k = 0; k < 8; ++k) {
                    IntraDomainEdge edge;
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) > (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k)) {
                        wavelength_to_occupy = k + i * 8;
                        edge = (IntraDomainEdge)networkGraph.getEdge(source, destination);
                        edge.getTE_info().setWavelengthOccupied(wavelength_to_occupy);
                        continue;
                    }
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) >= (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k)) continue;
                    wavelength_to_free = k + i * 8;
                    edge = (IntraDomainEdge)networkGraph.getEdge(source, destination);
                    edge.getTE_info().setWavelengthFree(wavelength_to_free);
                }
            }
            this.log.info("Link actualizado en el precomputo del algoritmo: " + ((IntraDomainEdge)networkGraph.getEdge(source, destination)).toString());
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void notifyNewVertex(Object vertex) {
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.baseSimplegraph;
        graph_lambda.addVertex(vertex);
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addVertex(vertex);
        }
    }

    public void notifyNewEdge(Object source, Object destination) {
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            IntraDomainEdge edge = new IntraDomainEdge();
            edge.setDelay_ms(((IntraDomainEdge)this.baseSimplegraph.getEdge(source, destination)).getDelay_ms());
            graph_lambda.addEdge(source, destination, (Object)edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.baseSimplegraph;
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                IntraDomainEdge edge = (IntraDomainEdge)networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                edge.getTE_info().setWavelengthReserved(wavelength);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.baseSimplegraph;
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                IntraDomainEdge edge = (IntraDomainEdge)networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                edge.getTE_info().setWavelengthUnReserved(wavelength);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void setReservation(int M, int N, Object source, Object dest) {
        ((BitmapLabelSet)((IntraDomainEdge)this.baseSimplegraph.getEdge(source, dest)).getTE_info().getAvailableLabels().getLabelSet()).setReservation(M, N);
    }

    public SSONInformation getWSONInfo() {
        return this.SSONInfo;
    }

    public void setWSONInfo(SSONInformation SSONInfo) {
        this.SSONInfo = SSONInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTEDBFullUpdate() {
        this.graphLock.lock();
        this.log.info("Entramos aqui????");
        try {
            Set nodes = this.baseSimplegraph.vertexSet();
            Set fiberEdges = this.baseSimplegraph.edgeSet();
            if (this.numLambdas > 0) {
                this.networkGraphs = new ArrayList(this.numLambdas);
                for (int i = 0; i < this.numLambdas; ++i) {
                    this.log.info("Looking at graph of lambda " + i);
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.baseSimplegraph;
                    Iterator iter = nodes.iterator();
                    for (IntraDomainEdge fiberEdge : fiberEdges) {
                        if (graph_lambda.containsEdge(fiberEdge.getSource(), fiberEdge.getTarget()) || !fiberEdge.getTE_info().isWavelengthFree(i) || !fiberEdge.getTE_info().isWavelengthUnreserved(i)) continue;
                        IntraDomainEdge edge = new IntraDomainEdge();
                        graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)edge);
                    }
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    @Override
    public boolean isMultifiber() {
        return false;
    }

    @Override
    public void setMultifiber(boolean multifiber) {
    }

    @Override
    public void setNetworkMultiGraphs(ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> networkMultiGraphs) {
    }

    @Override
    public ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> getNetworkMultiGraphs() {
        return null;
    }

    @Override
    public DirectedMultigraph<Object, IntraDomainEdge> getBaseMultigraph() {
        return null;
    }

    @Override
    public void setBaseMultigraph(DirectedMultigraph<Object, IntraDomainEdge> baseMultigraph) {
    }

    @Override
    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getBaseSimplegraph() {
        return null;
    }

    @Override
    public void setBaseSimplegraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> baseSimplegraph) {
    }

    @Override
    public String printEdge(Object source, Object destination) {
        return null;
    }

    @Override
    public String printBaseTopology() {
        return null;
    }

    @Override
    public String printTopology(int lambda) {
        Set vertexSet = null;
        vertexSet = this.baseSimplegraph.vertexSet();
        Iterator vertexIterator = vertexSet.iterator();
        String topoString = "Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = topoString + "\t" + vertex.toString() + "\r\n";
        }
        topoString = topoString + "Intradomain Link list: \r\n";
        Set edgeSet = null;
        edgeSet = this.baseSimplegraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = topoString + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    @Override
    public void notifyNewEdge_multiLink(Object source, Object destination, long srcIfId, long dstIfId) {
    }

    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
    }

    public void notificationEdgeIP_AuxGraph(Object src, Object dst, TE_Information informationTEDB) {
    }

    public void notificationEdgeOPTICAL_AuxGraph(Object src, Object dst, int lambda) {
    }
}

