/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.sson.BitmapChannelState;
import es.tid.pce.computingEngine.algorithms.sson.ClosestFirstIteratorModified;
import es.tid.tedb.IntraDomainEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.graph.GraphPathImpl;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiedDijkstraSP {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private GraphPath<Object, IntraDomainEdge> path;
    private Hashtable<Object, BitmapChannelState> spectrumVertexState;
    private static int num_slots;

    public ModifiedDijkstraSP(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph, Object startVertex, Object endVertex, ArrayList<BitmapLabelSet> SetChannels, int num_slots) {
        this(graph, startVertex, endVertex, Double.POSITIVE_INFINITY, SetChannels, num_slots);
        ModifiedDijkstraSP.num_slots = num_slots;
    }

    public ModifiedDijkstraSP(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph, Object startVertex, Object endVertex, double radius, ArrayList<BitmapLabelSet> SetChannels, int num_slots) {
        if (!graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIteratorModified<Object, IntraDomainEdge> iter = new ClosestFirstIteratorModified<Object, IntraDomainEdge>((Graph<Object, IntraDomainEdge>)graph, startVertex, radius, SetChannels, ModifiedDijkstraSP.num_slots);
        while (iter.hasNext()) {
            Object vertex = iter.next();
            if (!vertex.equals(endVertex)) continue;
            this.createEdgeList(graph, iter, startVertex, endVertex);
            this.spectrumVertexState = iter.getVertexSpectrumState();
            return;
        }
        this.path = null;
    }

    public List<IntraDomainEdge> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<Object, IntraDomainEdge> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static List<IntraDomainEdge> findPathBetween(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph, Object startVertex, Object endVertex) {
        ModifiedDijkstraSP alg = new ModifiedDijkstraSP(graph, startVertex, endVertex, null, num_slots);
        return alg.getPathEdgeList();
    }

    private void createEdgeList(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph, ClosestFirstIteratorModified<Object, IntraDomainEdge> iter, Object startVertex, Object endVertex) {
        IntraDomainEdge edge;
        ArrayList<IntraDomainEdge> edgeList = new ArrayList<IntraDomainEdge>();
        Object v = endVertex;
        while ((edge = iter.getSpanningTreeEdge(v)) != null) {
            edgeList.add(edge);
            v = Graphs.getOppositeVertex(graph, (Object)edge, (Object)v);
        }
        Collections.reverse(edgeList);
        double pathLength = iter.getShortestPathLength(endVertex);
        this.path = new GraphPathImpl(graph, startVertex, endVertex, edgeList, pathLength);
    }

    public Hashtable<Object, BitmapChannelState> getVertexSpectrumState() {
        return this.spectrumVertexState;
    }
}

