/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.sson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.sson.SR_path_algorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.utilities.bandwidthToSlotConversion;
import es.tid.pce.computingEngine.algorithms.utilities.graphs_comparator;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.subobjects.SREROSubobject;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SR_path_algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private SR_path_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private SSONInformation SSONInfo;
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;

    public SR_path_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, int mf) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        this.log.debug("Starting AURE Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        BandwidthRequested Bw = (BandwidthRequested)req.getBandwidth();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        graphs_comparator grc = new graphs_comparator();
        this.log.info("BW: " + Bw.getBw());
        boolean num_slots = false;
        boolean m = false;
        bandwidthToSlotConversion conversion = new bandwidthToSlotConversion();
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        }
        this.log.info("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.info("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        if (((Object)source_router_id_addr).equals(dest_router_id_addr)) {
            this.log.info("Source and destination are the same!");
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address(source_router_id_addr);
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            if (req.getMetricList().size() != 0) {
                Metric metric = new Metric();
                metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                this.log.debug("Number of hops 0");
                float metricValue = 0.0f;
                metric.setMetricValue(metricValue);
                path.getMetricList().add(metric);
            }
            response.addPath(path);
            long tiempofin = System.nanoTime();
            long tiempotot = tiempofin - tiempoini;
            this.log.info("Ha tardado " + tiempotot + " nanosegundos");
            Monitoring monitoring = this.pathReq.getMonitoring();
            if (monitoring == null || monitoring.isProcessingTimeBit()) {
                // empty if block
            }
            m_resp.addResponse(response);
            return m_resp;
        }
        boolean nopath = true;
        boolean end = false;
        this.log.info("Starting the computation");
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getNetworkGraphs().get(0);
        DijkstraShortestPath dsp = new DijkstraShortestPath(graphLambda, (Object)source_router_id_addr, (Object)dest_router_id_addr);
        GraphPath gp_trully_chosen = dsp.getPath();
        if (gp_trully_chosen != null) {
            Path path = new Path();
            ExplicitRouteObject srero = new ExplicitRouteObject();
            this.log.info("setting SRERO");
            List edge_list = gp_trully_chosen.getEdgeList();
            for (int i = 0; i < edge_list.size(); ++i) {
                SREROSubobject sreroso = new SREROSubobject();
                this.log.info("SRERO edge: " + edge_list.get(i));
                sreroso.setSID(((IntraDomainEdge)edge_list.get(i)).getDst_sid());
                sreroso.setLoosehop(false);
                srero.addEROSubobject((EROSubobject)sreroso);
                this.log.info("SRERO subobject added: " + sreroso.toString());
            }
            path.setEro(srero);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.setBandwidth((Bandwidth)Bw);
            response.addPath(path);
        } else {
            this.log.info("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(SR_path_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

