/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.sson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.sson.SVEC_AURE_SSON_algorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.utilities.bandwidthToSlotConversion;
import es.tid.pce.computingEngine.algorithms.utilities.graphs_comparator;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVEC_AURE_SSON_algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private SVEC_AURE_SSON_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs_precomp;
    private Lock graphLock;
    private SSONInformation SSONInfo;
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;

    public SVEC_AURE_SSON_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, int mf) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        int num_slots = 0;
        int m = 0;
        int t = 0;
        int num_responses = 0;
        this.graphLock = new ReentrantLock();
        this.log.info("Starting SVEC AURE_SSON Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        this.networkGraphs_precomp = new ArrayList(this.preComp.getSSONInfo().getNumLambdas());
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = new SimpleDirectedWeightedGraph<Object, IntraDomainEdge>(IntraDomainEdge.class);
        for (t = 0; t <= this.preComp.getSSONInfo().getNumLambdas() - 1; ++t) {
            networkGraph = PCEPUtils.duplicateTEDDB((SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)((SimpleTEDB)this.ted).getNetworkGraph());
            this.networkGraphs_precomp.add(t, networkGraph);
        }
        for (int k = 0; k < this.pathReq.getRequestList().size(); ++k) {
            int i;
            Request req = this.pathReq.getRequestList().get(k);
            long reqId = req.getRequestParameters().getRequestID();
            Response response = new Response();
            RequestParameters rp = new RequestParameters();
            rp.setRequestID(reqId);
            response.setRequestParameters(rp);
            EndPoints EP = req.getEndPoints();
            BandwidthRequested Bw = (BandwidthRequested)req.getBandwidth();
            Inet4Address source_router_id_addr = null;
            Inet4Address dest_router_id_addr = null;
            graphs_comparator grc = new graphs_comparator();
            bandwidthToSlotConversion conversion = new bandwidthToSlotConversion();
            boolean nopath = true;
            boolean end = false;
            int lambda = 0;
            int lambda_chosen = 0;
            int central_freq = 0;
            int counter = 0;
            boolean is_equal = false;
            if (Bw.getBw() != 0.0f) {
                this.SSONInfo = this.preComp.getSSONInfo();
                int cs = this.SSONInfo.getCs();
                num_slots = conversion.getNumSlots(Bw.getBw(), cs);
            }
            if (EP.getOT() == 1) {
                EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
                source_router_id_addr = ep.getSourceIP();
                dest_router_id_addr = ep.getDestIP();
            } else if (EP.getOT() != 2 && EP.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                if (gep.getGeneralizedEndPointsType() == 0) {
                    P2PEndpoints p2pep = gep.getP2PEndpoints();
                    EndPoint sourceep = p2pep.getSourceEndPoint();
                    EndPoint destep = p2pep.getDestinationEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
                if (gep.getGeneralizedEndPointsType() == 1) {
                    P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                    EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                    EndPoint sourceep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    int cont = 0;
                    while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                        epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                        EndPoint destep = epandrest.getEndPoint();
                        source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                        dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                    }
                }
            }
            this.log.info("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
            if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.warn("Source or destination are NOT in the TED");
                NoPath noPath = new NoPath();
                noPath.setNatureOfIssue(0);
                NoPathTLV noPathTLV = new NoPathTLV();
                if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                    this.log.debug("Unknown source");
                    noPathTLV.setUnknownSource(true);
                }
                if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                    this.log.debug("Unknown destination");
                    noPathTLV.setUnknownDestination(true);
                }
                noPath.setNoPathTLV(noPathTLV);
                response.setNoPath(noPath);
                m_resp.addResponse(response);
                end = true;
                nopath = true;
            }
            if (source_router_id_addr.equals(dest_router_id_addr)) {
                this.log.info("Source and destination are the same!");
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                eroso.setIpv4address(source_router_id_addr);
                eroso.setPrefix(32);
                ero.addEROSubobject((EROSubobject)eroso);
                path.setEro(ero);
                if (req.getMetricList().size() != 0) {
                    Metric metric = new Metric();
                    metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                    this.log.debug("Number of hops 0");
                    float metricValue = 0.0f;
                    metric.setMetricValue(metricValue);
                    path.getMetricList().add(metric);
                }
                response.addPath(path);
                long tiempofin = System.nanoTime();
                long tiempotot = tiempofin - tiempoini;
                this.log.info("Ha tardado " + tiempotot + " nanosegundos");
                Monitoring monitoring = this.pathReq.getMonitoring();
                if (monitoring == null || monitoring.isProcessingTimeBit()) {
                    // empty if block
                }
                m_resp.addResponse(response);
                end = true;
                nopath = true;
            }
            double max_metric = 2.147483647E9;
            this.log.debug("Starting the computation");
            GraphPath gp_chosen = null;
            GraphPath gp_trully_chosen = null;
            while (!end) {
                long tiempotot;
                long tiempofin;
                NoPathTLV noPathTLV;
                NoPath noPath;
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.networkGraphs_precomp.get(lambda);
                DijkstraShortestPath dsp = new DijkstraShortestPath(graphLambda, (Object)source_router_id_addr, (Object)dest_router_id_addr);
                GraphPath gp = dsp.getPath();
                if (gp == null) {
                    counter = 0;
                    if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                        if (nopath) {
                            this.log.info("No path found!");
                            noPath = new NoPath();
                            noPath.setNatureOfIssue(0);
                            noPathTLV = new NoPathTLV();
                            noPath.setNoPathTLV(noPathTLV);
                            response.setNoPath(noPath);
                            tiempofin = System.nanoTime();
                            tiempotot = tiempofin - tiempoini;
                            this.log.info("Ha tardado " + tiempotot + " nanosegundos");
                            m_resp.addResponse(response);
                            end = true;
                            nopath = true;
                            continue;
                        }
                        end = true;
                        continue;
                    }
                    ++lambda;
                    continue;
                }
                if (counter == 0) {
                    if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                        if (nopath) {
                            this.log.info("No path found");
                            noPath = new NoPath();
                            noPath.setNatureOfIssue(0);
                            noPathTLV = new NoPathTLV();
                            noPath.setNoPathTLV(noPathTLV);
                            response.setNoPath(noPath);
                            tiempofin = System.nanoTime();
                            tiempotot = tiempofin - tiempoini;
                            this.log.info("Ha tardado " + tiempotot + " nanosegundos");
                            m_resp.addResponse(response);
                            end = true;
                            nopath = true;
                            continue;
                        }
                        end = true;
                        continue;
                    }
                    if (gp.getWeight() < max_metric) {
                        gp_chosen = gp;
                        ++counter;
                        lambda_chosen = ++lambda;
                        end = false;
                        continue;
                    }
                    ++lambda;
                    counter = 0;
                    continue;
                }
                is_equal = grc.edges_comparator((GraphPath<Object, IntraDomainEdge>)gp, gp_chosen);
                if (is_equal) {
                    if (++counter == num_slots) {
                        gp_trully_chosen = gp;
                        max_metric = gp.getWeight();
                        central_freq = lambda - (num_slots - 1) / 2;
                        m = num_slots / 2;
                        counter = 0;
                        nopath = false;
                        end = true;
                        if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                            nopath = false;
                            end = true;
                            continue;
                        }
                        ++lambda;
                        continue;
                    }
                    if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                        if (!nopath) continue;
                        this.log.info("No path found");
                        noPath = new NoPath();
                        noPath.setNatureOfIssue(0);
                        noPathTLV = new NoPathTLV();
                        noPath.setNoPathTLV(noPathTLV);
                        response.setNoPath(noPath);
                        tiempofin = System.nanoTime();
                        tiempotot = tiempofin - tiempoini;
                        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
                        m_resp.addResponse(response);
                        end = true;
                        nopath = true;
                        continue;
                    }
                    lambda_chosen = ++lambda;
                    continue;
                }
                counter = 0;
                gp_chosen = null;
                if (lambda >= this.preComp.getSSONInfo().getNumLambdas() - 1) {
                    end = true;
                    continue;
                }
                end = false;
            }
            if (nopath) continue;
            ++num_responses;
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_trully_chosen.getEdgeList();
            for (i = 0; i < edge_list.size(); ++i) {
                UnnumberIfIDEROSubobject eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                eroso.setLoosehop(false);
                ero.addEROSubobject((EROSubobject)eroso);
                DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                WDMlabel.setGrid(this.preComp.getSSONInfo().getGrid());
                WDMlabel.setChannelSpacing(this.preComp.getSSONInfo().getCs());
                WDMlabel.setN(central_freq + this.preComp.getSSONInfo().getnMin());
                WDMlabel.setM(m);
                WDMlabel.setIdentifier((int)reqId);
                try {
                    WDMlabel.encode();
                }
                catch (RSVPProtocolViolationException e) {
                    e.printStackTrace();
                }
                GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                genLabel.setLabel(WDMlabel.getBytes());
                ero.addEROSubobject((EROSubobject)genLabel);
                genLabel.setLabel(WDMlabel.getBytes());
            }
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            m_resp.addResponse(response);
            LinkedList<Inet4Address> sourceVertexList = new LinkedList<Inet4Address>();
            LinkedList<Inet4Address> targetVertexList = new LinkedList<Inet4Address>();
            for (i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                targetVertexList.add((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getTarget());
            }
            for (int r = this.preComp.getSSONInfo().getnMin() + central_freq - m; r < this.preComp.getSSONInfo().getnMin() + central_freq + m; ++r) {
                this.notifyWavelengthReservation(sourceVertexList, targetVertexList, r);
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(SVEC_AURE_SSON_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Inet4Address> sourceVertexList, LinkedList<Inet4Address> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs_precomp.get(wavelength);
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                networkGraph.removeEdge((Object)sourceVertexList.get(i), (Object)targetVertexList.get(i));
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public Lock getGraphLock() {
        return this.graphLock;
    }

    public void setGraphLock(Lock graphLock) {
        this.graphLock = graphLock;
    }
}

