/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputationSSON;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import es.tid.tedb.TE_Information;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVEC_AURE_SSON_algorithmPreComputation
implements ComputingAlgorithmPreComputationSSON {
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> baseSimplegraph;
    private int numLambdas;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Lock graphLock;
    private double totalBandwidth = 0.0;
    private double totalRejectedBandwidth = 0.0;
    private DomainTEDB ted;
    private SSONInformation SSONInfo;

    @Override
    public void initialize() {
        this.log.info("initializing SVEC_AURE_SSON Algorithm");
        this.graphLock = new ReentrantLock();
        Set nodes = this.baseSimplegraph.vertexSet();
        Set fiberEdges = this.baseSimplegraph.edgeSet();
        if (this.numLambdas > 0) {
            this.networkGraphs = new ArrayList(this.numLambdas);
            for (int i = 0; i < this.numLambdas; ++i) {
                this.log.info("Adding graph of lambda " + i);
                SimpleDirectedWeightedGraph graph_lambda = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
                this.networkGraphs.add(i, (SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graph_lambda);
                Iterator iter = nodes.iterator();
                while (iter.hasNext()) {
                    graph_lambda.addVertex(iter.next());
                }
                for (IntraDomainEdge fiberEdge : fiberEdges) {
                    IntraDomainEdge edge = new IntraDomainEdge();
                    edge.setDelay_ms(fiberEdge.getDelay_ms());
                    graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)edge);
                }
            }
        } else {
            this.log.error("REGISTERING AURE ALGORITHM WITHOUT KNOWN NUMBER OF LAMBDAS");
            System.exit(-1);
        }
    }

    @Override
    public void setTEDB(TEDB ted) {
        try {
            this.baseSimplegraph = ((SimpleTEDB)ted).getNetworkGraph();
            this.log.info("Using SimpleTEDB");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.SSONInfo = ((DomainTEDB)ted).getSSONinfo();
        this.ted = (DomainTEDB)ted;
        this.numLambdas = this.SSONInfo.getNumLambdas();
    }

    @Override
    public ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> getNetworkGraphs() {
        return this.networkGraphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wavelength);
            for (int i = 0; i < sourceVertexList.size() - 1; ++i) {
                networkGraph.removeEdge(sourceVertexList.get(i), targetVertexList.get(i));
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wavelength);
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                if (!((IntraDomainEdge)this.baseSimplegraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i))).getTE_info().isWavelengthFree(wavelength)) continue;
                IntraDomainEdge edge = new IntraDomainEdge();
                edge.setDelay_ms(((IntraDomainEdge)this.baseSimplegraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i))).getDelay_ms());
                networkGraph.addEdge(sourceVertexList.get(i), targetVertexList.get(i), (Object)edge);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public Lock getGraphLock() {
        return this.graphLock;
    }

    public void setGraphLock(Lock graphLock) {
        this.graphLock = graphLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthStatusChange(Object source, Object destination, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        previousBitmapLabelSet.getNumLabels();
        int num_bytes = previousBitmapLabelSet.getBytesBitMap().length;
        int wavelength_to_occupy = -1;
        int wavelength_to_free = -1;
        try {
            this.graphLock.lock();
            for (int i = 0; i < num_bytes; ++i) {
                if (previousBitmapLabelSet.getBytesBitMap()[i] == newBitmapLabelSet.getBytesBitMap()[i]) continue;
                for (int k = 0; k < 8; ++k) {
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) > (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k)) {
                        wavelength_to_occupy = k + i * 8;
                        networkGraph = this.networkGraphs.get(wavelength_to_occupy);
                        networkGraph.removeEdge(source, destination);
                        continue;
                    }
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) >= (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) || (newBitmapLabelSet.getBytesBitmapReserved()[i] & 128 >>> k) != 0) continue;
                    wavelength_to_free = k + i * 8;
                    networkGraph = this.networkGraphs.get(wavelength_to_free);
                    networkGraph.addEdge(source, destination);
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void notifyNewVertex(Object vertex) {
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addVertex(vertex);
        }
    }

    public void notifyNewEdge(Object source, Object destination) {
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            IntraDomainEdge edge = new IntraDomainEdge();
            edge.setDelay_ms(((IntraDomainEdge)this.baseSimplegraph.getEdge(source, destination)).getDelay_ms());
            graph_lambda.addEdge(source, destination, (Object)edge);
        }
    }

    public SSONInformation getSSONInfo() {
        return this.SSONInfo;
    }

    public void setSSONInfo(SSONInformation sSONInfo) {
        this.SSONInfo = sSONInfo;
    }

    public double getTotalBandwidth() {
        return this.totalBandwidth;
    }

    public void setTotalBandwidth(double d) {
        this.totalBandwidth = d;
    }

    public double getTotalRejectedBandwidth() {
        return this.totalRejectedBandwidth;
    }

    public void setTotalRejectedBandwidth(double totalRejectedBandwidth) {
        this.totalRejectedBandwidth = totalRejectedBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTEDBFullUpdate() {
        this.graphLock.lock();
        try {
            Set nodes = this.baseSimplegraph.vertexSet();
            Set fiberEdges = this.baseSimplegraph.edgeSet();
            if (this.numLambdas > 0) {
                this.networkGraphs = new ArrayList(this.numLambdas);
                for (int i = 0; i < this.numLambdas; ++i) {
                    this.log.info("Looking at graph of lambda " + i);
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
                    Iterator iter = nodes.iterator();
                    for (IntraDomainEdge fiberEdge : fiberEdges) {
                        if (graph_lambda.containsEdge(fiberEdge.getSource(), fiberEdge.getTarget()) || !fiberEdge.getTE_info().isWavelengthFree(i) || !fiberEdge.getTE_info().isWavelengthUnreserved(i)) continue;
                        IntraDomainEdge edge = new IntraDomainEdge();
                        graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)edge);
                    }
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void notifyWavelengthEndReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, int m) {
    }

    public void notifyWavelengthReservationSSON(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, int m) {
    }

    @Override
    public boolean isMultifiber() {
        return false;
    }

    @Override
    public void setMultifiber(boolean multifiber) {
    }

    @Override
    public void setNetworkMultiGraphs(ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> networkMultiGraphs) {
    }

    @Override
    public ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> getNetworkMultiGraphs() {
        return null;
    }

    @Override
    public DirectedMultigraph<Object, IntraDomainEdge> getBaseMultigraph() {
        return null;
    }

    @Override
    public void setBaseMultigraph(DirectedMultigraph<Object, IntraDomainEdge> baseMultigraph) {
    }

    @Override
    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getBaseSimplegraph() {
        return null;
    }

    @Override
    public void setBaseSimplegraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> baseSimplegraph) {
    }

    @Override
    public String printEdge(Object source, Object destination) {
        return null;
    }

    @Override
    public String printBaseTopology() {
        return null;
    }

    @Override
    public String printTopology(int lambda) {
        return null;
    }

    @Override
    public void notifyNewEdge_multiLink(Object source, Object destination, long srcIfId, long dstIfId) {
    }

    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
    }

    public void notificationEdgeIP_AuxGraph(Object src, Object dst, TE_Information informationTEDB) {
    }

    public void notificationEdgeOPTICAL_AuxGraph(Object src, Object dst, int lambda) {
    }
}

