/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.sson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.sson.BitmapChannelState;
import es.tid.pce.computingEngine.algorithms.sson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.sson.ModifiedDijkstraSP;
import es.tid.pce.computingEngine.algorithms.sson.SVEC_Dynamic_RSAPreComputation;
import es.tid.pce.computingEngine.algorithms.utilities.bandwidthToSlotConversion;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.GeneralizedBandwidthSSON;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SSONInformation;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import es.tid.util.UtilsFunctions;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVEC_Dynamic_RSA
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private SVEC_Dynamic_RSAPreComputation preComp;
    private ReservationManager reservationManager;
    private Lock graphLock;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
    private SSONInformation SSONInfo;
    private ArrayList<BitmapLabelSet> setChannels;
    private int num_slots = 0;
    private DomainTEDB ted;
    int number_rejections = 0;
    private GenericLambdaReservation reserv;

    public SVEC_Dynamic_RSA(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, int mf) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        long tiempoMSPtotal = 0L;
        long tiempoReservaTotal = 0L;
        int num_responses = 0;
        this.graphLock = new ReentrantLock();
        this.log.debug("Starting Dynamic_RSA Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        this.networkGraph = PCEPUtils.duplicateTEDDB((SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)((SimpleTEDB)this.ted).getNetworkGraph());
        for (int k = 0; k < this.pathReq.getRequestList().size(); ++k) {
            int i;
            Request req = this.pathReq.getRequestList().get(k);
            long reqId = req.getRequestParameters().getRequestID();
            this.log.info("Request id: " + reqId + ", getting endpoints");
            Response response = new Response();
            RequestParameters rp = new RequestParameters();
            rp.setRequestID(reqId);
            response.setRequestParameters(rp);
            this.SSONInfo = new SSONInformation();
            this.SSONInfo = this.ted.getSSONinfo();
            EndPoints EP = req.getEndPoints();
            BandwidthRequested Bw = (BandwidthRequested)req.getBandwidth();
            Inet4Address source_router_id_addr = null;
            Inet4Address dest_router_id_addr = null;
            boolean end = false;
            GraphPath<Object, IntraDomainEdge> gp_chosen = null;
            int num_labels = 0;
            int m = 0;
            int Bmod = 2;
            this.log.info("Request bandwidth: " + Bw.getBw());
            num_labels = this.SSONInfo.getNumLambdas();
            this.log.info("Num_lambdas " + num_labels);
            bandwidthToSlotConversion conversion = new bandwidthToSlotConversion();
            if (Bw.getBw() != 0.0f) {
                this.SSONInfo = this.ted.getSSONinfo();
                int cs = this.SSONInfo.getCs();
                this.num_slots = conversion.getNumSlots(Bw.getBw(), cs);
            }
            this.log.info("Request num_slots: " + this.num_slots);
            this.setChannels = this.preComp.getTotalSetChannels().get(this.num_slots - 1);
            if (EP.getOT() == 1) {
                EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
                source_router_id_addr = ep.getSourceIP();
                dest_router_id_addr = ep.getDestIP();
            } else if (EP.getOT() != 2 && EP.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                if (gep.getGeneralizedEndPointsType() == 0) {
                    P2PEndpoints p2pep = gep.getP2PEndpoints();
                    EndPoint sourceep = p2pep.getSourceEndPoint();
                    EndPoint destep = p2pep.getDestinationEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
                if (gep.getGeneralizedEndPointsType() == 1) {
                    P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                    EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                    EndPoint sourceep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    int cont = 0;
                    while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                        epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                        EndPoint destep = epandrest.getEndPoint();
                        source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                        dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                    }
                }
            }
            this.log.debug("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
            if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.warn("Source or destination are NOT in the TED");
                NoPath noPath = new NoPath();
                noPath.setNatureOfIssue(0);
                NoPathTLV noPathTLV = new NoPathTLV();
                if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                    this.log.debug("Unknown source");
                    noPathTLV.setUnknownSource(true);
                }
                if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                    this.log.debug("Unknown destination");
                    noPathTLV.setUnknownDestination(true);
                }
                noPath.setNoPathTLV(noPathTLV);
                response.setNoPath(noPath);
                long tiempofin = System.nanoTime();
                long tiempotot = tiempofin - tiempoini;
                this.preComp.setTotalRejectedBandwidth((double)Bw.getBw() + this.preComp.getTotalRejectedBandwidth());
                ++this.number_rejections;
                m_resp.addResponse(response);
                end = true;
            }
            if (((Object)source_router_id_addr).equals(dest_router_id_addr)) {
                this.log.info("Source and destination are the same!");
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
                eroso.setIpv4address(source_router_id_addr);
                eroso.setPrefix(32);
                ero.addEROSubobject((EROSubobject)eroso);
                path.setEro(ero);
                if (req.getMetricList().size() != 0) {
                    Metric metric = new Metric();
                    metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                    this.log.debug("Number of hops 0");
                    float metricValue = 0.0f;
                    metric.setMetricValue(metricValue);
                    path.getMetricList().add(metric);
                }
                response.addPath(path);
                long tiempofin = System.nanoTime();
                long tiempotot = tiempofin - tiempoini;
                this.log.info("Ha tardado " + tiempotot + " nanosegundos");
                Monitoring monitoring = this.pathReq.getMonitoring();
                if (monitoring == null || monitoring.isProcessingTimeBit()) {
                    // empty if block
                }
                m_resp.addResponse(response);
                end = true;
            }
            boolean nopath = true;
            int central_freq = 0;
            double max_metric = 2.147483647E9;
            this.log.info("Starting the computation");
            this.preComp.getGraphLock().lock();
            try {
                while (!end) {
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.networkGraph;
                    long tiempoini_msp = System.nanoTime();
                    ModifiedDijkstraSP dsp = new ModifiedDijkstraSP(graphLambda, source_router_id_addr, dest_router_id_addr, Double.POSITIVE_INFINITY, this.setChannels, this.num_slots);
                    long tiempofin_msp = System.nanoTime();
                    tiempoMSPtotal += tiempofin_msp - tiempoini_msp;
                    this.log.info("Fin MDSP");
                    GraphPath<Object, IntraDomainEdge> gp = dsp.getPath();
                    if (gp == null) {
                        this.log.info("No path found");
                        NoPath noPath = new NoPath();
                        noPath.setNatureOfIssue(0);
                        NoPathTLV noPathTLV = new NoPathTLV();
                        noPath.setNoPathTLV(noPathTLV);
                        response.setNoPath(noPath);
                        nopath = true;
                        ++num_responses;
                        long tiempofin = System.nanoTime();
                        long tiempotot = tiempofin - tiempoini;
                        this.preComp.setTotalRejectedBandwidth((double)Bw.getBw() + this.preComp.getTotalRejectedBandwidth());
                        ++this.number_rejections;
                        m_resp.addResponse(response);
                        end = true;
                        continue;
                    }
                    BitmapChannelState valid_channels = new BitmapChannelState(dsp.getVertexSpectrumState().get(dest_router_id_addr).getLength());
                    valid_channels.setBytesBitmap(dsp.getVertexSpectrumState().get(dest_router_id_addr).getBytesBitmap());
                    for (int i2 = 0; i2 < valid_channels.getLength(); ++i2) {
                        if ((valid_channels.getBytesBitmap()[i2 / 8] & 128 >> i2 % 8) != 128 >> i2 % 8) continue;
                        BitmapLabelSet chosen_channel = this.setChannels.get(i2);
                        UtilsFunctions.printByte(chosen_channel.getBytesBitMap(), "Bitmap Channel " + i2 + ">>", this.log);
                        central_freq = i2 + (this.num_slots + 1) / 2;
                        break;
                    }
                    if (central_freq != 0) {
                        gp_chosen = gp;
                        max_metric = gp.getWeight();
                        m = this.num_slots / 2;
                        this.log.info("Central Frequency" + central_freq);
                        this.log.info("Frequency width" + m);
                        this.log.info("Path" + gp_chosen);
                        nopath = false;
                        end = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid central frequency for this request");
                }
            }
            finally {
                this.preComp.getGraphLock().unlock();
            }
            if (nopath) continue;
            ++num_responses;
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_chosen.getEdgeList();
            for (i = 0; i < edge_list.size(); ++i) {
                UnnumberIfIDEROSubobject eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                eroso.setLoosehop(false);
                ero.addEROSubobject((EROSubobject)eroso);
                DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                WDMlabel.setN(central_freq + this.preComp.getWSONInfo().getnMin());
                WDMlabel.setIdentifier(0);
                try {
                    WDMlabel.encode();
                }
                catch (RSVPProtocolViolationException e) {
                    e.printStackTrace();
                }
                GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                ero.addEROSubobject((EROSubobject)genLabel);
                genLabel.setLabel(WDMlabel.getBytes());
            }
            BandwidthRequestedGeneralizedBandwidth gw = new BandwidthRequestedGeneralizedBandwidth();
            GeneralizedBandwidthSSON GB_SSON = new GeneralizedBandwidthSSON();
            GB_SSON.setM(m);
            this.preComp.setTotalBandwidth((double)(m * Bmod) * 6.25 + this.preComp.getTotalBandwidth());
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            path.setBandwidth((Bandwidth)gw);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            m_resp.addResponse(response);
            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
            LinkedList<Object> targetVertexList = new LinkedList<Object>();
            for (i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
            }
            sourceVertexList.add(((IntraDomainEdge)edge_list.get(i - 1)).getSource());
            targetVertexList.add(((IntraDomainEdge)edge_list.get(i - 1)).getTarget());
            for (int r = this.preComp.getWSONInfo().getnMin() + central_freq - m; r < this.preComp.getWSONInfo().getnMin() + central_freq + m; ++r) {
                long tiempoIniReserv = System.nanoTime();
                this.notifyWavelengthReservation(sourceVertexList, targetVertexList, r);
                long tiempoFinReserv = System.nanoTime();
                tiempoReservaTotal += tiempoFinReserv - tiempoIniReserv;
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        this.log.info("Ha tardado " + tiempoMSPtotal + " nanosegundos en ejecutar el MSP");
        this.log.info("Ha tardado " + tiempoReservaTotal + " nanosegundos en ejecutar la reserva");
        this.log.info("Number of paths rejected: " + this.number_rejections + ", Total unservered Bandwidth = " + this.preComp.getTotalRejectedBandwidth());
        this.log.info("Number of total requests: " + num_responses + ", Total servered Bandwidth = " + this.preComp.getTotalBandwidth());
        return m_resp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            for (int i = 0; i < sourceVertexList.size() - 1; ++i) {
                IntraDomainEdge edge = (IntraDomainEdge)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                IntraDomainEdge edge_op = (IntraDomainEdge)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i));
                edge.getTE_info().setWavelengthOccupied(wavelength);
                edge_op.getTE_info().setWavelengthOccupied(wavelength);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                IntraDomainEdge edge = (IntraDomainEdge)this.networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                edge.getTE_info().setWavelengthFree(wavelength);
                IntraDomainEdge edge_op = (IntraDomainEdge)this.networkGraph.getEdge(targetVertexList.get(i), sourceVertexList.get(i));
                edge_op.getTE_info().setWavelengthUnReserved(wavelength);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void setPreComp(SVEC_Dynamic_RSAPreComputation preComp) {
        this.preComp = preComp;
    }

    public static String toHexString(byte[] packetBytes) {
        StringBuffer sb = new StringBuffer(packetBytes.length * 2);
        for (int i = 0; i < packetBytes.length; ++i) {
            if ((packetBytes[i] & 0xFF) <= 15) {
                sb.append('0');
                sb.append(Integer.toHexString(packetBytes[i] & 0xFF));
                continue;
            }
            sb.append(Integer.toHexString(packetBytes[i] & 0xFF));
        }
        return sb.toString();
    }
}

