/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.vlan.AURE_WLAN_algorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.vlan.GenericWLANReservation;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.WLANLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AURE_WLAN_algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private AURE_WLAN_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private DomainTEDB ted;
    private GenericWLANReservation reserv;

    public AURE_WLAN_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            this.log.warn("Error: Not supported yet");
        }
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        boolean nopath = true;
        boolean end = false;
        int lambda = 0;
        int lambda_chosen = 0;
        double max_metric = 2.147483647E9;
        this.log.debug("Starting the computation");
        GraphPath gp_chosen = null;
        this.preComp.getGraphLock().lock();
        try {
            while (!end) {
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getNetworkGraphs().get(lambda);
                DijkstraShortestPath dsp = new DijkstraShortestPath(graphLambda, (Object)source_router_id_addr, (Object)dest_router_id_addr);
                GraphPath gp = dsp.getPath();
                if (gp == null) {
                    if (lambda >= this.preComp.getNumWLANs() - 1) {
                        if (nopath) {
                            this.log.info("No path found");
                            NoPath noPath = new NoPath();
                            noPath.setNatureOfIssue(0);
                            NoPathTLV noPathTLV = new NoPathTLV();
                            noPath.setNoPathTLV(noPathTLV);
                            response.setNoPath(noPath);
                            ComputingResponse computingResponse = m_resp;
                            return computingResponse;
                        }
                        end = true;
                        continue;
                    }
                    ++lambda;
                    continue;
                }
                if (gp.getWeight() < max_metric) {
                    this.log.info("LAMBDA " + lambda + " with metric " + gp.getWeight());
                    gp_chosen = gp;
                    lambda_chosen = lambda;
                    nopath = false;
                    max_metric = gp.getWeight();
                }
                if (lambda >= this.preComp.getNumWLANs() - 1) {
                    end = true;
                    continue;
                }
                ++lambda;
            }
        }
        finally {
            this.preComp.getGraphLock().unlock();
        }
        if (!nopath) {
            SwitchIDEROSubobject eroso;
            int i;
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_chosen.getEdgeList();
            for (i = 0; i < edge_list.size(); ++i) {
                eroso = new SwitchIDEROSubobject();
                eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)((String)((IntraDomainEdge)edge_list.get(i)).getSource())));
                eroso.setLoosehop(false);
                ero.addEROSubobject((EROSubobject)eroso);
                GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                ero.addEROSubobject((EROSubobject)genLabel);
                WLANLabel wlanlabel = new WLANLabel();
                wlanlabel.setIdentifier(0);
                wlanlabel.setN(lambda_chosen);
                try {
                    wlanlabel.encode();
                }
                catch (RSVPProtocolViolationException e) {
                    e.printStackTrace();
                }
                genLabel.setLabel(wlanlabel.getBytes());
            }
            eroso = new SwitchIDEROSubobject();
            eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)((String)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget())));
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
            LinkedList<Object> targetVertexList = new LinkedList<Object>();
            LinkedList<Integer> wlans = new LinkedList<Integer>();
            for (i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
                wlans.add(lambda_chosen);
            }
            if (req.getReservation() != null) {
                this.reserv = new GenericWLANReservation();
                this.reserv.setResp(m_resp);
                this.reserv.setWLANList(wlans);
                this.reserv.setReservation(req.getReservation());
                this.reserv.setSourceVertexList(sourceVertexList);
                this.reserv.setTargetVertexList(targetVertexList);
                if (rp.isBidirect()) {
                    this.reserv.setBidirectional(true);
                } else {
                    this.reserv.setBidirectional(false);
                }
                this.reserv.setReservationManager(this.reservationManager);
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(AURE_WLAN_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

