/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputation;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import es.tid.tedb.TE_Information;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AURE_WLAN_algorithmPreComputation
implements ComputingAlgorithmPreComputation {
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> baseSimplegraph;
    private int numWLANs;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Lock graphLock;
    private DomainTEDB ted;

    @Override
    public void initialize() {
        this.log.info("initializing AURE Algorithm WLAN");
        this.graphLock = new ReentrantLock();
        Set nodes = this.baseSimplegraph.vertexSet();
        Set fiberEdges = this.baseSimplegraph.edgeSet();
        if (this.numWLANs > 0) {
            this.networkGraphs = new ArrayList(this.numWLANs);
            for (int i = 0; i < this.numWLANs; ++i) {
                this.log.info("Adding graph of lambda " + i);
                SimpleDirectedWeightedGraph graph_lambda = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
                this.networkGraphs.add(i, (SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graph_lambda);
                Iterator iter = nodes.iterator();
                while (iter.hasNext()) {
                    graph_lambda.addVertex(iter.next());
                }
                for (IntraDomainEdge fiberEdge : fiberEdges) {
                    graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)fiberEdge);
                }
            }
        } else {
            this.log.error("REGISTERING AURE ALGORITHM WITHOUT KNOWN NUMBER OF WLANS");
            System.exit(-1);
        }
    }

    @Override
    public void setTEDB(TEDB ted) {
        try {
            this.baseSimplegraph = ((SimpleTEDB)ted).getNetworkGraph();
            this.log.info("Using SimpleTEDB");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.ted = (DomainTEDB)ted;
        Set allEdges = this.baseSimplegraph.edgeSet();
        this.numWLANs = -1;
        for (IntraDomainEdge edge : allEdges) {
            if (this.numWLANs == -1) {
                this.numWLANs = edge.getTE_info().getNumberWLANs();
                continue;
            }
            this.numWLANs = Math.min(edge.getTE_info().getNumberWLANs(), this.numWLANs);
        }
        if (this.numWLANs < 0) {
            this.log.warn("Something wrong with the xml and the number of wlans");
        }
        this.log.info("Number of wlans:  " + this.numWLANs);
    }

    @Override
    public ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> getNetworkGraphs() {
        return this.networkGraphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wavelength);
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wavelength);
            for (int i = 0; i < sourceVertexList.size() - 1; ++i) {
                if (!((IntraDomainEdge)this.baseSimplegraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i))).getTE_info().isWavelengthFree(wavelength)) continue;
                IntraDomainEdge edge = new IntraDomainEdge();
                edge.setDelay_ms(((IntraDomainEdge)this.baseSimplegraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i))).getDelay_ms());
                networkGraph.addEdge(sourceVertexList.get(i), targetVertexList.get(i), (Object)edge);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public Lock getGraphLock() {
        return this.graphLock;
    }

    public void setGraphLock(Lock graphLock) {
        this.graphLock = graphLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthStatusChange(Object source, Object destination, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        previousBitmapLabelSet.getNumLabels();
        int num_bytes = previousBitmapLabelSet.getBytesBitMap().length;
        int wavelength_to_occupy = -1;
        int wavelength_to_free = -1;
        try {
            this.graphLock.lock();
            for (int i = 0; i < num_bytes; ++i) {
                if (previousBitmapLabelSet.getBytesBitMap()[i] == newBitmapLabelSet.getBytesBitMap()[i]) continue;
                for (int k = 0; k < 8; ++k) {
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) > (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k)) {
                        wavelength_to_occupy = k + i * 8;
                        networkGraph = this.networkGraphs.get(wavelength_to_occupy);
                        networkGraph.removeEdge(source, destination);
                        continue;
                    }
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) >= (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) || (newBitmapLabelSet.getBytesBitmapReserved()[i] & 128 >>> k) != 0) continue;
                    wavelength_to_free = k + i * 8;
                    networkGraph = this.networkGraphs.get(wavelength_to_free);
                    networkGraph.addEdge(source, destination, this.baseSimplegraph.getEdge(source, destination));
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void notifyNewVertex(Object vertex) {
        for (int i = 0; i < this.numWLANs; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addVertex(vertex);
        }
    }

    public void notifyNewEdge(Object source, Object destination) {
        for (int i = 0; i < this.numWLANs; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addEdge(source, destination, this.baseSimplegraph.getEdge(source, destination));
        }
    }

    public int getNumWLANs() {
        return this.numWLANs;
    }

    public void setNumWLANs(int numWLANs) {
        this.numWLANs = numWLANs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTEDBFullUpdate() {
        this.graphLock.lock();
        try {
            Set nodes = this.baseSimplegraph.vertexSet();
            Set fiberEdges = this.baseSimplegraph.edgeSet();
            if (this.numWLANs > 0) {
                this.networkGraphs = new ArrayList(this.numWLANs);
                for (int i = 0; i < this.numWLANs; ++i) {
                    this.log.info("Looking at graph of lambda " + i);
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
                    Iterator iter = nodes.iterator();
                    for (IntraDomainEdge fiberEdge : fiberEdges) {
                        if (graph_lambda.containsEdge(fiberEdge.getSource(), fiberEdge.getTarget()) || !fiberEdge.getTE_info().isWavelengthFree(i) || !fiberEdge.getTE_info().isWavelengthUnreserved(i)) continue;
                        graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)fiberEdge);
                    }
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    @Override
    public String printBaseTopology() {
        Set vetexSet = this.baseSimplegraph.vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = topoString + "\t" + vertex.toString() + "\r\n";
        }
        topoString = topoString + "Intradomain Link list: \r\n";
        Set edgeSet = this.baseSimplegraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = topoString + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    @Override
    public String printTopology(int lambda) {
        Set vetexSet = this.networkGraphs.get(lambda).vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = topoString + "\t" + vertex.toString() + "\r\n";
        }
        topoString = topoString + "Intradomain Link list: \r\n";
        Set edgeSet = this.networkGraphs.get(lambda).edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = topoString + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    public void notificationEdgeIP_AuxGraph(Object src, Object dst, TE_Information informationTEDB) {
    }

    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
    }

    public void notificationEdgeOPTICAL_AuxGraph(Object src, Object dst, int lambda) {
    }

    @Override
    public void setGrooming_policie(int groomingPolicie) {
    }

    @Override
    public boolean isMultifiber() {
        return false;
    }

    @Override
    public void setMultifiber(boolean multifiber) {
    }

    @Override
    public void setNetworkMultiGraphs(ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> networkMultiGraphs) {
    }

    @Override
    public ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> getNetworkMultiGraphs() {
        return null;
    }
}

