/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.vlan.BETTER_WLAN_algorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.vlan.GenericWLANReservation;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.XifiUniCastEndPoints;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.WLANLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import es.tid.tedb.elements.RouterInfoPM;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BETTER_WLAN_algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private BETTER_WLAN_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private Integer Default_Vlan_Ports = 20;
    private DomainTEDB ted;
    private GenericWLANReservation reserv;

    public BETTER_WLAN_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        ComputingResponse m_resp;
        long tiempoini;
        block28: {
            tiempoini = System.nanoTime();
            m_resp = new ComputingResponse();
            m_resp.setEncodingType(this.pathReq.getEcodingType());
            Request req = this.pathReq.getRequestList().get(0);
            long reqId = req.getRequestParameters().getRequestID();
            this.log.info("Request id: " + reqId + ", getting endpoints");
            Response response = new Response();
            RequestParameters rp = new RequestParameters();
            rp.setBidirect(req.getRequestParameters().isBidirect());
            rp.setRequestID(reqId);
            response.setRequestParameters(rp);
            m_resp.addResponse(response);
            EndPoints EP = req.getEndPoints();
            Inet4Address source_router_addr = null;
            Inet4Address dest_router_addr = null;
            Integer source_interface = null;
            Integer destination_interface = null;
            String source_mac = null;
            String dest_mac = null;
            XifiUniCastEndPoints xifiEp = null;
            if (EP.getOT() == 1) {
                this.log.info("Fix the line below and pray for working");
                this.log.info("En PCEServer.java hay un lio con iniciar la topologia, ahora se mete informacion de configuracion y de");
                EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
                source_router_addr = ep.getSourceIP();
                dest_router_addr = ep.getDestIP();
            } else if (EP.getOT() != 2) {
                if (EP.getOT() == 5) {
                    this.log.warn("Error: Not supported yet");
                } else if (EP.getOT() == 6) {
                    this.log.info("EP.getOT()::" + EP.getOT());
                    xifiEp = (XifiUniCastEndPoints)req.getEndPoints();
                    source_router_addr = new RouterInfoPM(xifiEp.getSwitchSourceID());
                    dest_router_addr = new RouterInfoPM(xifiEp.getSwitchDestinationID());
                    this.log.info("ep.getSwitchSourceID()::" + xifiEp.getSwitchSourceID());
                    this.log.info("ep.getSwitchDestinationID()::" + xifiEp.getSwitchDestinationID());
                    this.log.info("ep.getSource_port()::" + xifiEp.getSource_port());
                    this.log.info("ep.getDestination_port()::" + xifiEp.getDestination_port());
                    source_interface = xifiEp.getSource_port();
                    destination_interface = xifiEp.getDestination_port();
                    source_mac = xifiEp.getSourceMAC();
                    dest_mac = xifiEp.getDestinationMAC();
                }
            }
            this.log.info("ted.containsVertex(source_router_addr):" + this.ted.containsVertex((Object)source_router_addr));
            this.log.info("ted.containsVertex(dest_router_addr):" + this.ted.containsVertex((Object)dest_router_addr));
            this.log.info("source_router_id_addr:" + source_router_addr + ",dest_router_id_addr:" + dest_router_addr);
            if (!this.ted.containsVertex((Object)source_router_addr) || !this.ted.containsVertex((Object)dest_router_addr)) {
                this.log.warn("Source or destination are NOT in the TED");
                NoPath noPath = new NoPath();
                noPath.setNatureOfIssue(0);
                NoPathTLV noPathTLV = new NoPathTLV();
                if (!this.ted.containsVertex((Object)source_router_addr)) {
                    this.log.debug("Unknown source");
                    noPathTLV.setUnknownSource(true);
                }
                if (!this.ted.containsVertex((Object)dest_router_addr)) {
                    this.log.debug("Unknown destination");
                    noPathTLV.setUnknownDestination(true);
                }
                noPath.setNoPathTLV(noPathTLV);
                response.setNoPath(noPath);
                return m_resp;
            }
            boolean nopath = true;
            this.log.debug("Starting the computation");
            GraphPath gp_chosen = null;
            this.preComp.getGraphLock().lock();
            try {
                int i;
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getNetworkGraphs().get(0);
                DijkstraShortestPath dsp = new DijkstraShortestPath(graphLambda, (Object)source_router_addr, (Object)dest_router_addr);
                gp_chosen = dsp.getPath();
                this.log.info("graphLambda::" + graphLambda);
                if (gp_chosen == null) {
                    this.log.info("No path found");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    ComputingResponse computingResponse = m_resp;
                    return computingResponse;
                }
                nopath = false;
                List edge_list = gp_chosen.getEdgeList();
                for (int i2 = 0; i2 < edge_list.size(); ++i2) {
                    if (((IntraDomainEdge)edge_list.get(i2)).getTE_info().isWLANFree()) continue;
                    nopath = true;
                }
                if (nopath) {
                    this.log.info("No path found");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    ComputingResponse computingResponse = m_resp;
                    return computingResponse;
                }
                if (nopath) break block28;
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                edge_list = gp_chosen.getEdgeList();
                this.log.info("edge_list.size():" + edge_list.size());
                for (i = 0; i < edge_list.size(); ++i) {
                    this.log.info("New Router Info");
                    this.log.info(((RouterInfoPM)((IntraDomainEdge)edge_list.get(0)).getSource()).getRouterID());
                    this.log.info(((RouterInfoPM)((IntraDomainEdge)edge_list.get(0)).getTarget()).getRouterID());
                    this.log.info(Long.valueOf(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id()).toString());
                    this.log.info(Long.valueOf(((IntraDomainEdge)edge_list.get(i)).getDst_if_id()).toString());
                }
                LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                LinkedList<Object> targetVertexList = new LinkedList<Object>();
                LinkedList<Integer> wlans = new LinkedList<Integer>();
                if (edge_list.size() == 0) {
                    SwitchIDEROSubobject eroso = new SwitchIDEROSubobject();
                    this.log.info("Source SwitchID:::" + xifiEp.getSwitchSourceID());
                    eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)xifiEp.getSwitchSourceID()));
                    eroso.setSource_int(source_interface.intValue());
                    eroso.setAssociated_mac(ByteHandler.MACFormatStringtoByteArray((String)source_mac));
                    eroso.setSecond_associated_mac(ByteHandler.MACFormatStringtoByteArray((String)dest_mac));
                    eroso.setDest_int(destination_interface.intValue());
                    ero.addEROSubobject((EROSubobject)eroso);
                } else {
                    this.log.info("Edge list size::" + edge_list.size());
                    this.log.info("(int)edge_list.get(0).getSrc_if_id()::" + (int)((IntraDomainEdge)edge_list.get(0)).getSrc_if_id());
                    SwitchIDEROSubobject eroso = new SwitchIDEROSubobject();
                    eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)((RouterInfoPM)((IntraDomainEdge)edge_list.get(0)).getSource()).getRouterID()));
                    eroso.setSource_int(source_interface.intValue());
                    eroso.setDest_int((int)((IntraDomainEdge)edge_list.get(0)).getSrc_if_id());
                    eroso.setAssociated_mac(ByteHandler.MACFormatStringtoByteArray((String)source_mac));
                    if (((IntraDomainEdge)edge_list.get((int)0)).TE_info.isVlanLink()) {
                        eroso.setVlan(Integer.valueOf(((IntraDomainEdge)edge_list.get((int)0)).TE_info.getVlan()));
                    }
                    ero.addEROSubobject((EROSubobject)eroso);
                    for (i = 0; i < edge_list.size() - 1; ++i) {
                        eroso = new SwitchIDEROSubobject();
                        eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)((RouterInfoPM)((IntraDomainEdge)edge_list.get(i + 1)).getSource()).getRouterID()));
                        eroso.setSource_int((int)((IntraDomainEdge)edge_list.get(i)).getDst_if_id());
                        eroso.setDest_int((int)((IntraDomainEdge)edge_list.get(i + 1)).getSrc_if_id());
                        eroso.setLoosehop(false);
                        ero.addEROSubobject((EROSubobject)eroso);
                        if (((IntraDomainEdge)edge_list.get((int)(i + 1))).TE_info.isVlanLink()) {
                            eroso.setVlan(Integer.valueOf(((IntraDomainEdge)edge_list.get((int)(i + 1))).TE_info.getVlan()));
                        }
                        this.log.info("Setting in switich: " + ((RouterInfoPM)((IntraDomainEdge)edge_list.get(i)).getSource()).getRouterID() + ",sourceInt: " + (int)((IntraDomainEdge)edge_list.get(i)).getSrc_if_id() + ",destInt: " + (int)((IntraDomainEdge)edge_list.get(i)).getDst_if_id());
                        GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                        ero.addEROSubobject((EROSubobject)genLabel);
                        WLANLabel wlanlabel = new WLANLabel();
                        wlanlabel.setIdentifier(0);
                        int wlan = ((IntraDomainEdge)edge_list.get(i)).getTE_info().getFreeWLAN();
                        wlanlabel.setN(wlan);
                        try {
                            wlanlabel.encode();
                        }
                        catch (RSVPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        genLabel.setLabel(wlanlabel.getBytes());
                        sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                        targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
                        wlans.add(wlan);
                    }
                    eroso = new SwitchIDEROSubobject();
                    eroso.setSource_int((int)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getDst_if_id());
                    eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)((RouterInfoPM)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget()).getRouterID()));
                    eroso.setDest_int(destination_interface.intValue());
                    eroso.setAssociated_mac(ByteHandler.MACFormatStringtoByteArray((String)dest_mac));
                    ero.addEROSubobject((EROSubobject)eroso);
                }
                path.setEro(ero);
                PCEPUtils.completeMetric(path, req, edge_list);
                response.addPath(path);
                if (req.getReservation() != null) {
                    this.reserv = new GenericWLANReservation();
                    this.reserv.setResp(m_resp);
                    this.reserv.setReservation(req.getReservation());
                    this.reserv.setSourceVertexList(sourceVertexList);
                    this.reserv.setTargetVertexList(targetVertexList);
                    this.reserv.setWLANList(wlans);
                    if (rp.isBidirect()) {
                        this.reserv.setBidirectional(true);
                    } else {
                        this.reserv.setBidirectional(false);
                    }
                    this.reserv.setReservationManager(this.reservationManager);
                }
            }
            finally {
                this.preComp.getGraphLock().unlock();
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(BETTER_WLAN_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

