/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.vlan.BETTER_WLAN_algorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.vlan.GenericWLANReservation;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPointDataPathID;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.WLANLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.OpenFlowUnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import es.tid.tedb.elements.RouterInfoPM;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Correct_BETTER_WLAN_algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private BETTER_WLAN_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private Integer Default_Vlan_Ports = 20;
    private DomainTEDB ted;
    private GenericWLANReservation reserv;

    public Correct_BETTER_WLAN_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        ComputingResponse m_resp;
        long tiempoini;
        block22: {
            tiempoini = System.nanoTime();
            m_resp = new ComputingResponse();
            m_resp.setEncodingType(this.pathReq.getEcodingType());
            Request req = this.pathReq.getRequestList().get(0);
            long reqId = req.getRequestParameters().getRequestID();
            this.log.info("Request id: " + reqId + ", getting endpoints");
            Response response = new Response();
            RequestParameters rp = new RequestParameters();
            rp.setBidirect(req.getRequestParameters().isBidirect());
            rp.setRequestID(reqId);
            response.setRequestParameters(rp);
            m_resp.addResponse(response);
            EndPoints EP = req.getEndPoints();
            EndPointDataPathID endPDataId = null;
            this.log.info("EP.getOT()::" + EP.getOT());
            RouterInfoPM source_router_addr = null;
            RouterInfoPM dest_router_addr = null;
            if (EP.getOT() == 14) {
                endPDataId = (EndPointDataPathID)req.getEndPoints();
                source_router_addr = new RouterInfoPM(endPDataId.getSourceSwitchID().getDataPathID());
                dest_router_addr = new RouterInfoPM(endPDataId.getDestSwitchID().getDataPathID());
            } else {
                this.log.warn("Error: Unsupported Endpoint for this Algorithm");
            }
            this.log.info("ted.containsVertex(source_router_addr):" + this.ted.containsVertex((Object)source_router_addr));
            this.log.info("ted.containsVertex(dest_router_addr):" + this.ted.containsVertex((Object)dest_router_addr));
            this.log.info("source_router_id_addr:" + source_router_addr + ",dest_router_id_addr:" + dest_router_addr);
            if (!this.ted.containsVertex((Object)source_router_addr) || !this.ted.containsVertex((Object)dest_router_addr)) {
                this.log.warn("Source or destination are NOT in the TED");
                NoPath noPath = new NoPath();
                noPath.setNatureOfIssue(0);
                NoPathTLV noPathTLV = new NoPathTLV();
                if (!this.ted.containsVertex((Object)source_router_addr)) {
                    this.log.debug("Unknown source");
                    noPathTLV.setUnknownSource(true);
                }
                if (!this.ted.containsVertex((Object)dest_router_addr)) {
                    this.log.debug("Unknown destination");
                    noPathTLV.setUnknownDestination(true);
                }
                noPath.setNoPathTLV(noPathTLV);
                response.setNoPath(noPath);
                return m_resp;
            }
            boolean nopath = true;
            this.log.debug("Starting the computation");
            GraphPath gp_chosen = null;
            this.preComp.getGraphLock().lock();
            try {
                int i;
                SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getNetworkGraphs().get(0);
                DijkstraShortestPath dsp = new DijkstraShortestPath(graphLambda, (Object)source_router_addr, (Object)dest_router_addr);
                gp_chosen = dsp.getPath();
                this.log.info("graphLambda::" + graphLambda);
                if (gp_chosen == null) {
                    this.log.info("No path found");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    ComputingResponse computingResponse = m_resp;
                    return computingResponse;
                }
                nopath = false;
                List edge_list = gp_chosen.getEdgeList();
                for (int i2 = 0; i2 < edge_list.size(); ++i2) {
                    if (((IntraDomainEdge)edge_list.get(i2)).getTE_info().isWLANFree()) continue;
                    nopath = true;
                }
                if (nopath) {
                    this.log.info("No path found");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    ComputingResponse computingResponse = m_resp;
                    return computingResponse;
                }
                if (nopath) break block22;
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                edge_list = gp_chosen.getEdgeList();
                this.log.info("edge_list.size():" + edge_list.size());
                for (i = 0; i < edge_list.size(); ++i) {
                    this.log.info("New Router Info");
                    this.log.info(((RouterInfoPM)((IntraDomainEdge)edge_list.get(0)).getSource()).getRouterID());
                    this.log.info(((RouterInfoPM)((IntraDomainEdge)edge_list.get(0)).getTarget()).getRouterID());
                    this.log.info(Long.valueOf(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id()).toString());
                    this.log.info(Long.valueOf(((IntraDomainEdge)edge_list.get(i)).getDst_if_id()).toString());
                }
                LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                LinkedList<Object> targetVertexList = new LinkedList<Object>();
                LinkedList<Integer> wlans = new LinkedList<Integer>();
                if (edge_list.size() == 0) {
                    SwitchIDEROSubobject eroso = new SwitchIDEROSubobject();
                    this.log.info("Source SourceSwitchID:::" + endPDataId.getSourceSwitchID());
                    this.log.info("Source DestSwitchID:::" + endPDataId.getDestSwitchID());
                } else {
                    OpenFlowUnnumberIfIDEROSubobject opFlw;
                    this.log.info("Edge list size::" + edge_list.size());
                    this.log.info("(int)edge_list.get(0).getSrc_if_id()::" + (int)((IntraDomainEdge)edge_list.get(0)).getSrc_if_id());
                    for (i = 0; i < edge_list.size(); ++i) {
                        opFlw = new OpenFlowUnnumberIfIDEROSubobject();
                        opFlw.setSwitchID(((RouterInfoPM)((IntraDomainEdge)edge_list.get(i)).getSource()).getRouterID());
                        opFlw.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                        ero.addEROSubobject((EROSubobject)opFlw);
                        GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                        ero.addEROSubobject((EROSubobject)genLabel);
                        WLANLabel wlanlabel = new WLANLabel();
                        wlanlabel.setIdentifier(0);
                        int wlan = ((IntraDomainEdge)edge_list.get(i)).getTE_info().getFreeWLAN();
                        wlanlabel.setN(wlan);
                        try {
                            wlanlabel.encode();
                        }
                        catch (RSVPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        genLabel.setLabel(wlanlabel.getBytes());
                        sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                        targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
                        wlans.add(wlan);
                    }
                    opFlw = new OpenFlowUnnumberIfIDEROSubobject();
                    opFlw.setSwitchID(((RouterInfoPM)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget()).getRouterID());
                    opFlw.setInterfaceID(0L);
                    ero.addEROSubobject((EROSubobject)opFlw);
                }
                path.setEro(ero);
                PCEPUtils.completeMetric(path, req, edge_list);
                response.addPath(path);
                if (req.getReservation() != null) {
                    this.reserv = new GenericWLANReservation();
                    this.reserv.setResp(m_resp);
                    this.reserv.setReservation(req.getReservation());
                    this.reserv.setSourceVertexList(sourceVertexList);
                    this.reserv.setTargetVertexList(targetVertexList);
                    this.reserv.setWLANList(wlans);
                    if (rp.isBidirect()) {
                        this.reserv.setBidirectional(true);
                    } else {
                        this.reserv.setBidirectional(false);
                    }
                    this.reserv.setReservationManager(this.reservationManager);
                }
            }
            finally {
                this.preComp.getGraphLock().unlock();
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(BETTER_WLAN_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

