/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputation;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import es.tid.tedb.TE_Information;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Correct_BETTER_WLAN_algorithmPreComputation
implements ComputingAlgorithmPreComputation {
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> baseSimplegraph;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Lock graphLock;
    private DomainTEDB ted;
    private boolean existsPath = true;

    @Override
    public void initialize() {
        this.log.info("initializing AURE Algorithm WLAN");
        this.graphLock = new ReentrantLock();
        Set nodes = this.baseSimplegraph.vertexSet();
        Set fiberEdges = this.baseSimplegraph.edgeSet();
        this.networkGraphs = new ArrayList(1);
        this.log.info("Adding graph of lambda ");
        SimpleDirectedWeightedGraph graph_lambda = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        this.networkGraphs.add((SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graph_lambda);
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            this.log.info("Adding vertex!");
            graph_lambda.addVertex(iter.next());
        }
        for (IntraDomainEdge fiberEdge : fiberEdges) {
            this.log.info("Adding edge!::" + fiberEdge);
            this.log.info("fiberEdge.getSource()::" + fiberEdge.getSource());
            this.log.info("fiberEdge.getTarget()::" + fiberEdge.getTarget());
            graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)fiberEdge);
        }
    }

    @Override
    public void setTEDB(TEDB ted) {
        try {
            this.baseSimplegraph = ((SimpleTEDB)ted).getNetworkGraph();
            this.log.info("Using SimpleTEDB");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.ted = (DomainTEDB)ted;
        Set allEdges = this.baseSimplegraph.edgeSet();
        this.existsPath = true;
        for (IntraDomainEdge edge : allEdges) {
            if (edge.getTE_info().getNumberWLANs() > 0) continue;
            this.existsPath = false;
        }
        if (!this.existsPath) {
            this.log.warn("Some links are down!!");
        }
    }

    @Override
    public ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> getNetworkGraphs() {
        return this.networkGraphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wlan) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(0);
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                IntraDomainEdge edge = (IntraDomainEdge)networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                edge.getTE_info().setWavelengthReserved(wlan);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wlan) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wlan);
            for (int i = 0; i < sourceVertexList.size() - 1; ++i) {
                IntraDomainEdge edge = (IntraDomainEdge)networkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i));
                edge.getTE_info().setWavelengthUnReserved(wlan);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public Lock getGraphLock() {
        return this.graphLock;
    }

    public void setGraphLock(Lock graphLock) {
        this.graphLock = graphLock;
    }

    public void notifyWavelengthStatusChange(Object source, Object destination, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        this.log.warn("ERROR, Unimplemented at the moment");
    }

    public void notifyNewVertex(Object vertex) {
        this.log.info("Adding graph of lambda 0");
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(0);
        graph_lambda.addVertex(vertex);
    }

    public void notifyNewEdge(Object source, Object destination) {
        for (int i = 0; i < this.networkGraphs.size(); ++i) {
            this.log.info("Adding graph of lambda ::" + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addEdge(source, destination, this.baseSimplegraph.getEdge(source, destination));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTEDBFullUpdate() {
        this.graphLock.lock();
        try {
            Set nodes = this.baseSimplegraph.vertexSet();
            Set fiberEdges = this.baseSimplegraph.edgeSet();
            this.networkGraphs = new ArrayList(1);
            this.log.info("Looking at graph of lambda 0");
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(0);
            Iterator iter = nodes.iterator();
            for (IntraDomainEdge fiberEdge : fiberEdges) {
                if (graph_lambda.containsEdge(fiberEdge.getSource(), fiberEdge.getTarget())) continue;
                graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)fiberEdge);
                IntraDomainEdge edge = (IntraDomainEdge)graph_lambda.getEdge(fiberEdge.getSource(), fiberEdge.getTarget());
                edge.getTE_info().setFreeWLANS(fiberEdge.getTE_info().getCopyUnreservedWLANs());
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    @Override
    public String printBaseTopology() {
        Set vetexSet = this.baseSimplegraph.vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = topoString + "\t" + vertex.toString() + "\r\n";
        }
        topoString = topoString + "Intradomain Link list: \r\n";
        Set edgeSet = this.baseSimplegraph.edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = topoString + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    @Override
    public String printTopology(int lambda) {
        Set vetexSet = this.networkGraphs.get(lambda).vertexSet();
        Iterator vertexIterator = vetexSet.iterator();
        String topoString = "Nodes: \r\n";
        while (vertexIterator.hasNext()) {
            Object vertex = vertexIterator.next();
            topoString = topoString + "\t" + vertex.toString() + "\r\n";
        }
        topoString = topoString + "Intradomain Link list: \r\n";
        Set edgeSet = this.networkGraphs.get(lambda).edgeSet();
        for (IntraDomainEdge edge : edgeSet) {
            topoString = topoString + "\t" + edge.toString() + "\r\n";
        }
        return topoString;
    }

    public void notificationEdgeIP_AuxGraph(Object src, Object dst, TE_Information informationTEDB) {
    }

    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
    }

    public void notificationEdgeOPTICAL_AuxGraph(Object src, Object dst, int lambda) {
    }

    @Override
    public void setGrooming_policie(int groomingPolicie) {
    }

    @Override
    public boolean isMultifiber() {
        return false;
    }

    @Override
    public void setMultifiber(boolean multifiber) {
    }

    @Override
    public void setNetworkMultiGraphs(ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> networkMultiGraphs) {
    }

    @Override
    public ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> getNetworkMultiGraphs() {
        return null;
    }
}

