/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.pcep.objects.Reservation;
import es.tid.pce.pcep.objects.ReservationConf;
import es.tid.pce.server.wson.ReservationManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWLANReservation
implements AlgorithmReservation {
    private ComputingResponse resp;
    private LinkedList<Object> sourceVertexList = new LinkedList();
    private LinkedList<Object> targetVertexList = new LinkedList();
    private LinkedList<Integer> WLANList = new LinkedList();
    private Reservation reservation;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ReservationManager reservationManager;
    private boolean bidirectional;

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    @Override
    public ComputingResponse call() throws Exception {
        if (this.reservation != null) {
            long reservationID = 0L;
            Hashtable hTable = new Hashtable();
            for (int i = 0; i < this.sourceVertexList.size(); ++i) {
                ReserveStruct reserve;
                this.log.info("Reserving lambda: " + this.WLANList.get(i));
                if (hTable.get(this.WLANList.get(i)) == null) {
                    reserve = new ReserveStruct();
                    reserve.sourceVertexList.add(this.sourceVertexList.get(i));
                    reserve.targetVertexList.add(this.targetVertexList.get(i));
                    reserve.wlan = this.WLANList.get(i);
                    continue;
                }
                reserve = (ReserveStruct)hTable.get(this.WLANList.get(i));
                reserve.sourceVertexList.add(this.sourceVertexList.get(i));
                reserve.targetVertexList.add(this.targetVertexList.get(i));
            }
            Enumeration enumKey = hTable.keys();
            while (enumKey.hasMoreElements()) {
                Integer key = (Integer)enumKey.nextElement();
                ReserveStruct val = (ReserveStruct)hTable.get(key);
                this.reservationManager.reserve(val.sourceVertexList, val.targetVertexList, val.wlan, this.reservation.getTimer(), this.bidirectional);
                this.log.info("Reservin value for WLAN:" + val.wlan);
            }
            ReservationConf resConf = new ReservationConf();
            resConf.setReservationID(reservationID);
            this.resp.getResponse(0).setResConf(resConf);
            return this.resp;
        }
        return null;
    }

    public ComputingResponse getResp() {
        return this.resp;
    }

    public void setResp(ComputingResponse resp) {
        this.resp = resp;
    }

    public LinkedList<Object> getSourceVertexList() {
        return this.sourceVertexList;
    }

    public void setSourceVertexList(LinkedList<Object> sourceVertexList) {
        this.sourceVertexList = sourceVertexList;
    }

    public LinkedList<Object> getTargetVertexList() {
        return this.targetVertexList;
    }

    public void setTargetVertexList(LinkedList<Object> targetVertexList) {
        this.targetVertexList = targetVertexList;
    }

    public void setWLANList(LinkedList<Integer> WLANList) {
        this.WLANList = WLANList;
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    public ReservationManager getReservationManager() {
        return this.reservationManager;
    }

    public void setReservationManager(ReservationManager reservationManager) {
        this.reservationManager = reservationManager;
    }

    private class ReserveStruct {
        private LinkedList<Object> sourceVertexList = new LinkedList();
        private LinkedList<Object> targetVertexList = new LinkedList();
        int wlan;

        private ReserveStruct() {
        }
    }
}

