/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.vlan;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.vlan.GenericWLANReservation;
import es.tid.pce.computingEngine.algorithms.vlan.VLAN_Multicast_algorithmPreComputation;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.P2MPEndPointsDataPathID;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobject;
import es.tid.rsvp.objects.subobjects.SwitchIDEROSubobjectEdge;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import es.tid.tedb.elements.RouterInfoPM;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.alg.KruskalMinimumSpanningTree;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VLAN_Multicast_algorithm
implements ComputingAlgorithm {
    static AtomicInteger atI = new AtomicInteger(0);
    public static String BYTE_TAG = "1111000011110001";
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private VLAN_Multicast_algorithmPreComputation preComp;
    private ReservationManager reservationManager;
    private Integer Default_Vlan_Ports = 20;
    private DomainTEDB ted;
    private GenericWLANReservation reserv;

    public VLAN_Multicast_algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        GeneralizedEndPoints endP;
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        ArrayList<RouterInfoPM> switchList = null;
        ArrayList<Integer> portList = null;
        RouterInfoPM source = null;
        String source_mac = null;
        if (EP.getOT() == 1) {
            this.log.info("Error : PCEP_OBJECT_TYPE_ENDPOINTS_IPV4");
        } else if (EP.getOT() == 2) {
            this.log.info("Error : PCEP_OBJECT_TYPE_ENDPOINTS_IPV6");
        } else if (EP.getOT() == 5) {
            this.log.info("OK : PCEP_OBJECT_TYPE_GENERALIZED_ENDPOINTS");
            endP = (GeneralizedEndPoints)req.getEndPoints();
            LinkedList EandRList = endP.getP2MPEndpoints().getEndPointAndRestrictionsList();
            switchList = new ArrayList();
            portList = new ArrayList();
            for (int i = 0; i < EandRList.size(); ++i) {
                String switchId = ((EndPointAndRestrictions)EandRList.get(i)).getEndPoint().getXifiEndPointTLV().getSwitchID();
                int port_number = ((EndPointAndRestrictions)EandRList.get(i)).getEndPoint().getXifiEndPointTLV().getPort();
                this.log.info("XifiEndPoint" + switchId + ",port_number:" + port_number);
                portList.add(port_number);
                switchList.add(new RouterInfoPM(switchId));
            }
            source = new RouterInfoPM(endP.getP2MPEndpoints().getEndPointAndRestrictions().getEndPoint().getXifiEndPointTLV().getSwitchID());
            source_mac = endP.getP2MPEndpoints().getEndPointAndRestrictions().getEndPoint().getXifiEndPointTLV().getMac();
        } else if (EP.getOT() == 15) {
            this.log.info("OK : PCEP_OBJECT_TYPE_P2MP_ENDPOINTS_DATAPATHID");
            switchList = new ArrayList<RouterInfoPM>();
            portList = new ArrayList<Integer>();
            endP = (P2MPEndPointsDataPathID)req.getEndPoints();
            for (int i = 0; i < endP.getDestDatapathIDList().size(); ++i) {
                switchList.add(new RouterInfoPM((String)endP.getDestDatapathIDList().get(i)));
                portList.add(0);
            }
            source = new RouterInfoPM(endP.getSourceDatapathID());
            source_mac = "00:00:00:00:00:00";
        } else if (EP.getOT() == 6) {
            this.log.info("Error : PCEP_OBJECT_TYPE_ENDPOINTS_MAC");
        }
        this.log.info("ted::" + this.ted.printTopology());
        for (int i = 0; i < switchList.size(); ++i) {
            if (this.ted.containsVertex(switchList.get(i))) continue;
            return this.sendNoPath(response, m_resp);
        }
        Set edges = null;
        this.preComp.getGraphLock().lock();
        try {
            SwitchIDEROSubobject eroso;
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda = this.preComp.getNetworkGraphs().get(0);
            KruskalMinimumSpanningTree kmst = new KruskalMinimumSpanningTree(graphLambda);
            edges = kmst.getEdgeSet();
            this.log.info("graphLambda::::" + graphLambda);
            this.log.info("kmst.getEdgeSet()::::" + kmst.getEdgeSet());
            SimpleDirectedWeightedGraph sdwg = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
            this.log.info("edges.size():1::" + edges.size());
            for (IntraDomainEdge ide : edges) {
                this.log.info("ide.getSource():" + ide.getSource() + ",ide.getTarget():" + ide.getTarget());
                this.log.info("graphLambda.getEdge(ide.getTarget(), ide.getSource()):" + graphLambda.getEdge(ide.getTarget(), ide.getSource()));
                sdwg.addVertex(ide.getSource());
                sdwg.addVertex(ide.getTarget());
                sdwg.addEdge(ide.getSource(), ide.getTarget(), (Object)ide);
                sdwg.addEdge(ide.getTarget(), ide.getSource(), graphLambda.getEdge(ide.getTarget(), ide.getSource()));
            }
            this.log.info("sdwg::" + sdwg);
            HashSet<IntraDomainEdge> edge_list = new HashSet<IntraDomainEdge>();
            HashSet<RouterInfoPM> node_set = new HashSet<RouterInfoPM>();
            this.log.info("source::" + source);
            this.log.info("source_mac::" + source_mac);
            boolean is_there_only_one_swith = true;
            for (int i = 0; i < switchList.size() && edges.size() > 0; ++i) {
                this.log.info("switchList.get(i)::" + switchList.get(i));
                if (!sdwg.containsVertex(switchList.get(i))) {
                    this.log.info("Probably only one switch in the query");
                    break;
                }
                if (!sdwg.containsVertex((Object)source)) break;
                DijkstraShortestPath dsp = new DijkstraShortestPath((Graph)sdwg, (Object)source, switchList.get(i));
                GraphPath result = dsp.getPath();
                if (result == null) {
                    this.log.info("Sending No Paath");
                }
                this.log.info("Iteration i: " + i);
                for (IntraDomainEdge ide_result : result.getEdgeList()) {
                    this.log.info("Source-->After:" + ide_result.getSource());
                    this.log.info("Target-->After:" + ide_result.getTarget());
                    edge_list.add(ide_result);
                    node_set.add((RouterInfoPM)ide_result.getSource());
                    node_set.add((RouterInfoPM)ide_result.getTarget());
                    is_there_only_one_swith = false;
                }
            }
            if (is_there_only_one_swith) {
                node_set.add(source);
            }
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            GeneralizedLabelEROSubobject geL = new GeneralizedLabelEROSubobject();
            byte[] array = new BigInteger(BYTE_TAG, 2).toByteArray();
            geL.setLabel(array);
            ero.addEROSubobject((EROSubobject)geL);
            for (RouterInfoPM rout : node_set) {
                this.log.info("Switch id switchList.get(i).getRouterID():" + rout.getRouterID());
                eroso = new SwitchIDEROSubobject();
                eroso.setSwitchID(ByteHandler.MACFormatStringtoByteArray((String)rout.getRouterID()));
                eroso.setDest_int(0);
                eroso.setSource_int(0);
                eroso.setVlan(Integer.valueOf(0));
                eroso.setAssociated_mac(ByteHandler.MACFormatStringtoByteArray((String)source_mac));
                ero.addEROSubobject((EROSubobject)eroso);
            }
            for (int i = 0; i < switchList.size(); ++i) {
                this.log.info("Adding link to VM!!");
                SwitchIDEROSubobjectEdge eroso2 = new SwitchIDEROSubobjectEdge();
                eroso2.setSource_SwitchID(ByteHandler.MACFormatStringtoByteArray((String)((RouterInfoPM)switchList.get(i)).getRouterID()));
                eroso2.setDest_SwitchID(ByteHandler.MACFormatStringtoByteArray((String)"00:00:00:00:00:00:00:00"));
                eroso2.setSource_int(((Integer)portList.get(i)).intValue());
                ero.addEROSubobject((EROSubobject)eroso2);
            }
            for (IntraDomainEdge ide_def : edge_list) {
                this.log.info("((RouterInfoPM)ide_def.getSource()).getRouterID()):" + ((RouterInfoPM)ide_def.getSource()).getRouterID());
                this.log.info("((RouterInfoPM)ide_def.getTarget()).getRouterID()):" + ((RouterInfoPM)ide_def.getTarget()).getRouterID());
                eroso = new SwitchIDEROSubobjectEdge();
                eroso.setSource_SwitchID(ByteHandler.MACFormatStringtoByteArray((String)((RouterInfoPM)ide_def.getSource()).getRouterID()));
                eroso.setDest_SwitchID(ByteHandler.MACFormatStringtoByteArray((String)((RouterInfoPM)ide_def.getTarget()).getRouterID()));
                eroso.setAssociated_mac(ByteHandler.MACFormatStringtoByteArray((String)source_mac));
                eroso.setSource_int((int)ide_def.getSrc_if_id());
                eroso.setDest_int((int)ide_def.getDst_if_id());
                eroso.setVlan(Integer.valueOf(ide_def.getTE_info().getVlan()));
                ero.addEROSubobject((EROSubobject)eroso);
            }
            path.setEro(ero);
            response.addPath(path);
            if (req.getReservation() != null) {
                if (rp.isBidirect()) {
                    this.reserv.setBidirectional(true);
                } else {
                    this.reserv.setBidirectional(false);
                }
                this.reserv.setReservationManager(this.reservationManager);
            }
        }
        finally {
            this.preComp.getGraphLock().unlock();
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(VLAN_Multicast_algorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }

    private ComputingResponse sendNoPath(Response response, ComputingResponse m_resp) {
        this.log.warn("Big Warning: Source or destination are NOT in the TED, sending NO PATH");
        NoPath noPath = new NoPath();
        noPath.setNatureOfIssue(0);
        NoPathTLV noPathTLV = new NoPathTLV();
        noPathTLV.setUnknownSource(true);
        noPathTLV.setUnknownDestination(true);
        noPath.setNoPathTLV(noPathTLV);
        response.setNoPath(noPath);
        return m_resp;
    }
}

