/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.wson;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.wson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.wson.KSP_RANDOM_AlgorithmPreComputation;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import es.tid.tedb.WSONInformation;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.KShortestPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSP_RANDOM_Algorithm
implements ComputingAlgorithm {
    private WSONInformation WSONInfo;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;
    private ReservationManager reservationManager;
    private KSP_RANDOM_AlgorithmPreComputation preComp;
    private ComputingRequest pathReq;

    public KSP_RANDOM_Algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        this.log.debug("Starting KSPprecomp Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.debug("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        boolean nopath = false;
        int lambda_chosen = -1;
        GraphPath gp_chosen = null;
        boolean noLambda = true;
        int k = 1;
        this.log.debug("Starting the selection of the path");
        KShortestPaths ksp = new KShortestPaths(this.preComp.getNetworkGraph(), (Object)source_router_id_addr, k);
        List routeList = ksp.getPaths((Object)dest_router_id_addr);
        if (routeList.isEmpty()) {
            nopath = true;
            this.log.info("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        int num_lambdas = this.ted.getWSONinfo().getNumLambdas();
        int j1 = 0;
        if (!nopath) {
            for (j1 = 0; j1 < routeList.size(); ++j1) {
                gp_chosen = (GraphPath)routeList.get(j1);
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                List edge_list = gp_chosen.getEdgeList();
                int max_lambdas = ((BitmapLabelSet)((IntraDomainEdge)edge_list.get(0)).getTE_info().getAvailableLabels().getLabelSet()).getNumLabels();
                int num_bytes = ((BitmapLabelSet)((IntraDomainEdge)edge_list.get(0)).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitMap().length;
                byte[] bitmap = new byte[num_bytes];
                for (int i = 0; i < num_bytes; ++i) {
                    bitmap[i] = (byte)(((BitmapLabelSet)((IntraDomainEdge)edge_list.get(0)).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitMap()[i] | ((BitmapLabelSet)((IntraDomainEdge)edge_list.get(0)).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[i]);
                }
                for (int j11 = 1; j11 < edge_list.size(); ++j11) {
                    for (int i = 0; i < num_bytes; ++i) {
                        bitmap[i] = (byte)(bitmap[i] | (((BitmapLabelSet)((IntraDomainEdge)edge_list.get(j11)).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitMap()[i] | ((BitmapLabelSet)((IntraDomainEdge)edge_list.get(j11)).getTE_info().getAvailableLabels().getLabelSet()).getBytesBitmapReserved()[i]));
                    }
                }
                int[] lista = new int[max_lambdas];
                int k1 = 0;
                for (int i = 0; i < max_lambdas; ++i) {
                    int num_byte = i / 8;
                    if ((bitmap[num_byte] & 128 >>> i % 8) != 0) continue;
                    lista[k1] = i;
                    ++k1;
                }
                int semilla_aleatoria = (int)Math.floor(Math.random() * (double)k1);
                lambda_chosen = lista[semilla_aleatoria];
                if (!lista.equals(null)) {
                    UnnumberIfIDEROSubobject eroso;
                    int i1;
                    noLambda = false;
                    for (i1 = 0; i1 < edge_list.size(); ++i1) {
                        eroso = new UnnumberIfIDEROSubobject();
                        eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i1)).getSource());
                        eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i1)).getSrc_if_id());
                        eroso.setLoosehop(false);
                        ero.addEROSubobject((EROSubobject)eroso);
                        GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                        ero.addEROSubobject((EROSubobject)genLabel);
                        DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                        WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                        WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                        WDMlabel.setN(lambda_chosen + this.preComp.getWSONInfo().getnMin());
                        WDMlabel.setIdentifier(0);
                        try {
                            WDMlabel.encode();
                        }
                        catch (RSVPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        genLabel.setLabel(WDMlabel.getBytes());
                    }
                    eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
                    eroso.setPrefix(32);
                    ero.addEROSubobject((EROSubobject)eroso);
                    path.setEro(ero);
                    PCEPUtils.completeMetric(path, req, edge_list);
                    response.addPath(path);
                    LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                    LinkedList<Object> targetVertexList = new LinkedList<Object>();
                    for (i1 = 0; i1 < edge_list.size(); ++i1) {
                        sourceVertexList.add(((IntraDomainEdge)edge_list.get(i1)).getSource());
                        targetVertexList.add(((IntraDomainEdge)edge_list.get(i1)).getTarget());
                    }
                    sourceVertexList.add(((IntraDomainEdge)edge_list.get(i1 - 1)).getSource());
                    targetVertexList.add(((IntraDomainEdge)edge_list.get(i1 - 1)).getTarget());
                    if (req.getReservation() == null) break;
                    this.reserv = new GenericLambdaReservation();
                    this.reserv.setResp(m_resp);
                    this.reserv.setLambda_chosen(lambda_chosen);
                    this.reserv.setReservation(req.getReservation());
                    this.reserv.setSourceVertexList(sourceVertexList);
                    this.reserv.setTargetVertexList(targetVertexList);
                    if (rp.isBidirect()) {
                        this.reserv.setBidirectional(true);
                    } else {
                        this.reserv.setBidirectional(false);
                    }
                    this.reserv.setReservationManager(this.reservationManager);
                    break;
                }
                noLambda = true;
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        if (noLambda) {
            this.log.debug("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        return m_resp;
    }

    public void setPreComp(KSP_RANDOM_AlgorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

