/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.wson;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.wson.GenericLambdaReservation;
import es.tid.pce.computingEngine.algorithms.wson.KSPprecompFF_AlgorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.wson.wa.FirstFit;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import es.tid.tedb.WSONInformation;
import java.net.Inet4Address;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSPprecompFF_Algorithm
implements ComputingAlgorithm {
    private WSONInformation WSONInfo;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;
    private ReservationManager reservationManager;
    private KSPprecompFF_AlgorithmPreComputation preComp;
    private ComputingRequest pathReq;

    public KSPprecompFF_Algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
    }

    @Override
    public ComputingResponse call() {
        long tiempoini = System.nanoTime();
        this.log.debug("Starting KSPprecomp Algorithm");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.debug("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        boolean nopath = true;
        int lambda_chosen = 0;
        GraphPath gp_chosen = null;
        boolean noLambda = true;
        this.log.debug("Starting the selection of the path");
        if (!source_router_id_addr.equals(dest_router_id_addr)) {
            nopath = false;
        }
        Hashtable<Object, Object> routeInterList = new Hashtable();
        routeInterList = this.preComp.routeTable.get(source_router_id_addr);
        List edge_K_list = (List)routeInterList.get(dest_router_id_addr);
        int j = 0;
        if (!nopath) {
            for (j = 0; j < edge_K_list.size(); ++j) {
                UnnumberIfIDEROSubobject eroso;
                int i;
                gp_chosen = (GraphPath)edge_K_list.get(j);
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                List edge_list = gp_chosen.getEdgeList();
                lambda_chosen = FirstFit.getLambda(edge_list);
                if (lambda_chosen == -1) {
                    noLambda = true;
                    continue;
                }
                noLambda = false;
                for (i = 0; i < edge_list.size(); ++i) {
                    eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                    eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                    eroso.setLoosehop(false);
                    ero.addEROSubobject((EROSubobject)eroso);
                    GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                    ero.addEROSubobject((EROSubobject)genLabel);
                    DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                    WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                    WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                    WDMlabel.setN(lambda_chosen + this.preComp.getWSONInfo().getnMin());
                    WDMlabel.setIdentifier(0);
                    try {
                        WDMlabel.encode();
                    }
                    catch (RSVPProtocolViolationException e) {
                        e.printStackTrace();
                    }
                    genLabel.setLabel(WDMlabel.getBytes());
                }
                eroso = new IPv4prefixEROSubobject();
                eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
                eroso.setPrefix(32);
                ero.addEROSubobject((EROSubobject)eroso);
                path.setEro(ero);
                PCEPUtils.completeMetric(path, req, edge_list);
                response.addPath(path);
                LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                LinkedList<Object> targetVertexList = new LinkedList<Object>();
                for (i = 0; i < edge_list.size(); ++i) {
                    sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                    targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
                }
                if (req.getReservation() == null) continue;
                this.reserv = new GenericLambdaReservation();
                this.reserv.setResp(m_resp);
                this.reserv.setLambda_chosen(lambda_chosen);
                this.reserv.setReservation(req.getReservation());
                this.reserv.setSourceVertexList(sourceVertexList);
                this.reserv.setTargetVertexList(targetVertexList);
                if (rp.isBidirect()) {
                    this.reserv.setBidirectional(true);
                } else {
                    this.reserv.setBidirectional(false);
                }
                this.reserv.setReservationManager(this.reservationManager);
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        if (noLambda) {
            this.log.debug("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        return m_resp;
    }

    public void setPreComp(KSPprecompFF_AlgorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

