/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.wson.svec;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.wson.svec.SVEC_SP_FF_WSON_PathComputingPreComputation;
import es.tid.pce.computingEngine.algorithms.wson.wa.FirstFit;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVEC_SP_FF_WSON_PathComputing
implements ComputingAlgorithm {
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraphOrig;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private SVEC_SP_FF_WSON_PathComputingPreComputation preComp;

    public SVEC_SP_FF_WSON_PathComputing(ComputingRequest pathReq, TEDB ted) {
        this.networkGraphOrig = ((SimpleTEDB)ted).getDuplicatedNetworkGraph();
        this.pathReq = pathReq;
    }

    @Override
    public ComputingResponse call() {
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = PCEPUtils.duplicateTEDDB(this.networkGraphOrig);
        this.log.info("Processing SVEC Path Computing Request: " + this.pathReq.getSvec().toString());
        if (this.pathReq.getSvec().getSvec().islDiverseBit() | this.pathReq.getSvec().getSvec().isnDiverseBit() | this.pathReq.getSvec().getSvec().issRLGDiverseBit()) {
            this.log.info("Diverse Path Computation");
            for (int i = 0; i < this.pathReq.getSvec().getSvec().getRequestIDlist().size(); ++i) {
                UnnumberIfIDEROSubobject eroso;
                int j;
                Request req = this.pathReq.getRequestList().get(i);
                long reqId = req.getRequestParameters().getRequestID();
                RequestParameters rp = new RequestParameters();
                rp.setRequestID(reqId);
                Response response = new Response();
                response.setRequestParameters(rp);
                EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
                Inet4Address source_router_id_addr = ep.getSourceIP();
                this.log.info("Source: " + source_router_id_addr);
                Inet4Address dest_router_id_addr = ep.getDestIP();
                this.log.info("Destination: " + dest_router_id_addr);
                if (!networkGraph.containsVertex((Object)source_router_id_addr) || !networkGraph.containsVertex((Object)dest_router_id_addr)) {
                    this.log.warn("Source or destination are NOT in the TED");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    if (!networkGraph.containsVertex((Object)source_router_id_addr)) {
                        this.log.debug("Unknown source");
                        noPathTLV.setUnknownSource(true);
                    }
                    if (!networkGraph.containsVertex((Object)dest_router_id_addr)) {
                        this.log.debug("Unknown destination");
                        noPathTLV.setUnknownDestination(true);
                    }
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    m_resp.addResponse(response);
                    continue;
                }
                this.log.info("Computing path");
                long tiempoini = System.currentTimeMillis();
                DijkstraShortestPath dsp = new DijkstraShortestPath(networkGraph, (Object)source_router_id_addr, (Object)dest_router_id_addr);
                GraphPath gp = dsp.getPath();
                long tiempofin = System.currentTimeMillis();
                long tiempotot = tiempofin - tiempoini;
                this.log.info("Ha tardado " + tiempotot + " milisegundos");
                m_resp.addResponse(response);
                if (gp == null) {
                    this.log.info("NO PATH FOUND!!!!");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    response.setNoPath(noPath);
                    continue;
                }
                this.log.info("PATH FOUND!!!!");
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                List edge_list = gp.getEdgeList();
                for (j = 0; j < edge_list.size(); ++j) {
                    eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(j)).getSource());
                    eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(j)).getSrc_if_id());
                    eroso.setLoosehop(false);
                    ero.addEROSubobject((EROSubobject)eroso);
                }
                eroso = new IPv4prefixEROSubobject();
                eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
                eroso.setPrefix(32);
                ero.addEROSubobject((EROSubobject)eroso);
                path.setEro(ero);
                response.addPath(path);
                if (this.pathReq.getSvec().getSvec().islDiverseBit()) {
                    this.log.info("Removing edges from graph!");
                    for (j = 0; j < edge_list.size(); ++j) {
                        networkGraph.removeEdge(edge_list.get(j));
                    }
                    continue;
                }
                if (this.pathReq.getSvec().getSvec().issRLGDiverseBit()) {
                    this.log.info("Removing edges (NOW SRLGs are the links) from graph!");
                    for (j = 0; j < edge_list.size(); ++j) {
                        networkGraph.removeEdge(edge_list.get(j));
                    }
                    continue;
                }
                this.log.info("Removing nodes from graph!");
                for (j = 1; j < edge_list.size(); ++j) {
                    networkGraph.removeVertex(((IntraDomainEdge)edge_list.get(j)).getSource());
                }
            }
        } else {
            this.log.info("Sincronized Path Computation");
            this.log.info("There are " + this.pathReq.getRequestList().size() + " requests");
            for (int i = 0; i < this.pathReq.getSvec().getSvec().getRequestIDlist().size(); ++i) {
                Request req = this.pathReq.getRequestList().get(i);
                long reqId = req.getRequestParameters().getRequestID();
                RequestParameters rp = new RequestParameters();
                rp.setRequestID(reqId);
                Response response = new Response();
                response.setRequestParameters(rp);
                EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
                Inet4Address source_router_id_addr = ep.getSourceIP();
                this.log.info("Source: " + source_router_id_addr);
                Inet4Address dest_router_id_addr = ep.getDestIP();
                this.log.info("Destination: " + dest_router_id_addr);
                if (!networkGraph.containsVertex((Object)source_router_id_addr) || !networkGraph.containsVertex((Object)dest_router_id_addr)) {
                    this.log.warn("Source or destination are NOT in the TED");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    NoPathTLV noPathTLV = new NoPathTLV();
                    if (!networkGraph.containsVertex((Object)source_router_id_addr)) {
                        this.log.debug("Unknown source");
                        noPathTLV.setUnknownSource(true);
                    }
                    if (!networkGraph.containsVertex((Object)dest_router_id_addr)) {
                        this.log.debug("Unknown destination");
                        noPathTLV.setUnknownDestination(true);
                    }
                    noPath.setNoPathTLV(noPathTLV);
                    response.setNoPath(noPath);
                    m_resp.addResponse(response);
                    continue;
                }
                this.log.info("Computing path");
                long tiempoini = System.currentTimeMillis();
                DijkstraShortestPath dsp = new DijkstraShortestPath(networkGraph, (Object)source_router_id_addr, (Object)dest_router_id_addr);
                GraphPath gp = dsp.getPath();
                long tiempofin = System.currentTimeMillis();
                long tiempotot = tiempofin - tiempoini;
                this.log.info("Ha tardado " + tiempotot + " milisegundos");
                m_resp.addResponse(response);
                if (gp == null) {
                    this.log.info("NO PATH FOUND!!!!");
                    NoPath noPath = new NoPath();
                    noPath.setNatureOfIssue(0);
                    response.setNoPath(noPath);
                    continue;
                }
                Path path = new Path();
                ExplicitRouteObject ero = new ExplicitRouteObject();
                List edge_list = gp.getEdgeList();
                int lambda = FirstFit.getLambda(edge_list);
                if (lambda >= 0) {
                    UnnumberIfIDEROSubobject eroso;
                    for (int j = 0; j < edge_list.size(); ++j) {
                        eroso = new UnnumberIfIDEROSubobject();
                        eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(j)).getSource());
                        eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(j)).getSrc_if_id());
                        eroso.setLoosehop(false);
                        ero.addEROSubobject((EROSubobject)eroso);
                        GeneralizedLabelEROSubobject genLabel = new GeneralizedLabelEROSubobject();
                        ero.addEROSubobject((EROSubobject)genLabel);
                        DWDMWavelengthLabel WDMlabel = new DWDMWavelengthLabel();
                        WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                        WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                        WDMlabel.setN(lambda + this.preComp.getWSONInfo().getnMin());
                        WDMlabel.setIdentifier(0);
                        try {
                            WDMlabel.encode();
                        }
                        catch (RSVPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        genLabel.setLabel(WDMlabel.getBytes());
                        ((IntraDomainEdge)edge_list.get(j)).getTE_info().setWavelengthOccupied(lambda);
                    }
                    eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
                    eroso.setPrefix(32);
                    ero.addEROSubobject((EROSubobject)eroso);
                    path.setEro(ero);
                    response.addPath(path);
                    continue;
                }
                NoPath noPath = new NoPath();
                noPath.setNatureOfIssue(0);
                response.setNoPath(noPath);
            }
        }
        return m_resp;
    }

    public void setPreComp(SVEC_SP_FF_WSON_PathComputingPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return null;
    }
}

