/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.ChildPCEInitiate;
import es.tid.pce.computingEngine.algorithms.ChildPCERequest;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildPCERequestManager {
    private Hashtable<Inet4Address, DataOutputStream> domainIdOutputStream;
    private Hashtable<Inet4Address, Inet4Address> domainIdpceId;
    public Hashtable<Long, Object> locks = new Hashtable();
    public Hashtable<Long, Object> inilocks = new Hashtable();
    private Hashtable<Long, PCEPMessage> responses = new Hashtable();
    private Hashtable<Long, StateReport> reports;
    private ThreadPoolExecutor executor;
    private LinkedBlockingQueue<Runnable> workQueue;
    private Logger log;
    private Logger logGUI;

    public ChildPCERequestManager() {
        this.domainIdOutputStream = new Hashtable();
        this.domainIdpceId = new Hashtable();
        this.reports = new Hashtable();
        int corePoolSize = 5;
        int maximumPoolSize = 10;
        long keepAliveTime = 120L;
        this.workQueue = new LinkedBlockingQueue();
        this.executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, this.workQueue);
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.logGUI = LoggerFactory.getLogger((String)"GUILogger");
    }

    public LinkedList<ComputingResponse> executeRequests(LinkedList<PCEPRequest> requestList, LinkedList<Object> domainList) {
        LinkedList<ComputingResponse> response = new LinkedList<ComputingResponse>();
        LinkedList<FutureTask<ComputingResponse>> ftList = new LinkedList<FutureTask<ComputingResponse>>();
        for (int i = 0; i < requestList.size(); ++i) {
            ChildPCERequest cpr = new ChildPCERequest(this, requestList.get(i), domainList.get(i));
            FutureTask<ComputingResponse> ft = new FutureTask<ComputingResponse>(cpr);
            ftList.add(ft);
            this.executor.execute(ft);
        }
        long time = 120000L;
        this.log.debug("The time is " + time + " miliseconds");
        long timeIni = System.currentTimeMillis();
        for (int i = 0; i < requestList.size(); ++i) {
            long time2;
            ComputingResponse resp;
            try {
                this.log.debug("Waiting " + time + " miliseconds for domain " + domainList.get(i));
                resp = (ComputingResponse)((FutureTask)ftList.get(i)).get(time, TimeUnit.MILLISECONDS);
                time2 = System.currentTimeMillis();
                long timePassed = time2 - timeIni;
                time = timePassed >= 120000L ? 0L : (time -= timePassed);
                response.add(resp);
                continue;
            }
            catch (TimeoutException e) {
                resp = null;
                time2 = System.currentTimeMillis();
                time = time - time2 - timeIni;
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return response;
    }

    public LinkedList<ComputingResponse> executeInitiates(LinkedList<PCEPInitiate> initiateList, LinkedList<Object> domainList) {
        LinkedList<ComputingResponse> response = new LinkedList<ComputingResponse>();
        LinkedList<FutureTask<ComputingResponse>> ftList = new LinkedList<FutureTask<ComputingResponse>>();
        for (int i = 0; i < initiateList.size(); ++i) {
            ChildPCEInitiate cpr = new ChildPCEInitiate(this, initiateList.get(i), domainList.get(i));
            FutureTask<ComputingResponse> ft = new FutureTask<ComputingResponse>(cpr);
            ftList.add(ft);
            this.executor.execute(ft);
        }
        long time = 120000L;
        long timeIni = System.currentTimeMillis();
        for (int i = 0; i < initiateList.size(); ++i) {
            long time2;
            ComputingResponse resp;
            try {
                this.log.info("Waiting " + time + " miliseconds for initiating in domain " + domainList.get(i));
                resp = (ComputingResponse)((FutureTask)ftList.get(i)).get(time, TimeUnit.MILLISECONDS);
                time2 = System.currentTimeMillis();
                long timePassed = time2 - timeIni;
                time = timePassed >= 120000L ? 0L : (time -= timePassed);
                response.add(resp);
                continue;
            }
            catch (TimeoutException e) {
                resp = null;
                time2 = System.currentTimeMillis();
                time = time - time2 - timeIni;
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return response;
    }

    public void notifyResponse(PCEPResponse pcres) {
        long idRequest = pcres.getResponse(0).getRequestParameters().getRequestID();
        this.log.debug("Entrando en Notify Response de idRequest " + idRequest);
        Object object_lock = this.locks.get(new Long(idRequest));
        this.responses.put(new Long(idRequest), (PCEPMessage)pcres);
        if (object_lock != null) {
            object_lock.notifyAll();
        }
        this.locks.remove(object_lock);
    }

    public void notifyReport(StateReport sr) {
        long idRequest = sr.getSRP().getSRP_ID_number();
        this.log.debug("Entrando en Notify Report de id " + idRequest);
        Object object_lock = this.inilocks.get(new Long(idRequest));
        this.reports.put(new Long(idRequest), sr);
        if (object_lock != null) {
            object_lock.notifyAll();
        }
        this.inilocks.remove(object_lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCEPResponse newRequest(PCEPRequest pcreq, Object domain) {
        this.log.info("New Request to Child PCE");
        Object object_lock = new Object();
        long idRequest = pcreq.getRequest(0).getRequestParameters().getRequestID();
        this.log.debug("Creo lock con idRequest " + idRequest);
        this.locks.put(new Long(idRequest), object_lock);
        try {
            if (pcreq.getPccReqId() != null && pcreq.getMonitoring() != null) {
                this.logGUI.info(this.domainIdpceId.get(domain).getHostAddress() + "&file=" + pcreq.getPccReqId().getPCCIpAddress().getHostAddress() + ":" + pcreq.getMonitoring().getMonitoringIdNumber());
            }
            this.sendRequest(pcreq, domain);
        }
        catch (IOException e1) {
            this.locks.remove(object_lock);
            return null;
        }
        Object e1 = object_lock;
        synchronized (e1) {
            try {
                this.log.debug("Request sent, waiting for response");
                object_lock.wait(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.log.debug("Request or timeout");
        PCEPResponse resp = (PCEPResponse)this.responses.get(new Long(idRequest));
        if (resp == null) {
            this.log.warn("NO RESPONSE!!!!!");
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateReport newIni(PCEPInitiate pcini, Object domain) {
        Object object_lock = new Object();
        long idSRP = ((PCEPIntiatedLSP)pcini.getPcepIntiatedLSPList().get(0)).getRsp().getSRP_ID_number();
        this.log.info("Sending PCEPInitiate to domain " + domain + " srp_id " + idSRP + " : " + pcini.toString());
        this.inilocks.put(new Long(idSRP), object_lock);
        try {
            this.sendInitiate(pcini, domain);
        }
        catch (IOException e1) {
            this.log.warn("Problem with response from domain " + domain + " to initiate with srp_id " + idSRP);
            this.inilocks.remove(object_lock);
            return null;
        }
        Object e1 = object_lock;
        synchronized (e1) {
            try {
                this.log.debug("Request sent, waiting for response");
                object_lock.wait(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        StateReport resp = this.reports.get(new Long(idSRP));
        if (resp == null) {
            this.log.warn("No response from domain " + domain + " to initiate with srp_id " + idSRP);
        } else {
            this.log.info("Domain " + domain + " replied to Initiate with srp_id " + idSRP + " : " + resp.toString());
        }
        return resp;
    }

    public synchronized void sendRequest(PCEPRequest req, Object domain) throws IOException {
        try {
            req.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            e1.printStackTrace();
        }
        DataOutputStream out = this.domainIdOutputStream.get(domain);
        if (out == null) {
            this.log.warn("There is no PCE for domain " + domain);
            throw new IOException();
        }
        try {
            this.log.info("Sending Request message to domain " + domain);
            out.write(req.getBytes());
            out.flush();
        }
        catch (IOException e) {
            this.log.warn("Error sending REQ: " + e.getMessage());
            throw e;
        }
    }

    public synchronized void sendInitiate(PCEPInitiate ini, Object domain) throws IOException {
        try {
            ini.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            e1.printStackTrace();
        }
        DataOutputStream out = this.domainIdOutputStream.get(domain);
        if (out == null) {
            this.log.warn("There is no PCE for domain " + domain);
            throw new IOException();
        }
        try {
            this.log.info("Sending Initiate message to domain " + domain);
            out.write(ini.getBytes());
            out.flush();
        }
        catch (IOException e) {
            this.log.warn("Error sending REQ: " + e.getMessage());
            throw e;
        }
    }

    void registerDomainSession(Inet4Address domain, Inet4Address pceId, DataOutputStream out) {
        if (domain != null) {
            this.log.info("domain " + domain + "pceId " + pceId);
            if (this.domainIdOutputStream.containsKey(domain)) {
                this.domainIdOutputStream.remove(domain);
            }
            this.domainIdOutputStream.put(domain, out);
            if (this.domainIdpceId.containsKey(domain)) {
                this.domainIdpceId.remove(domain);
            }
            this.domainIdpceId.put(domain, pceId);
        } else {
            this.log.warn("domain is null, PCE not registered as child");
        }
    }

    void removeDomain(Inet4Address domain) {
        if (domain != null) {
            this.domainIdOutputStream.remove(domain);
            this.domainIdpceId.remove(domain);
        }
    }

    public Hashtable<Inet4Address, DataOutputStream> getDomainIdOutputStream() {
        return this.domainIdOutputStream;
    }

    public Hashtable<Inet4Address, Inet4Address> getDomainIdpceId() {
        return this.domainIdpceId;
    }
}

