/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE.MDLSPDB;

import com.google.gson.Gson;
import es.tid.pce.parentPCE.MDLSPDB.MultiDomainLSPDB;
import es.tid.pce.parentPCE.MDLSPDB.SimpleLSP;
import es.tid.pce.parentPCE.MDLSPDB.SimpleLSPhop;
import es.tid.pce.parentPCE.MD_LSP;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.ETCEROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLV;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class SaveLSPinRedis
implements Runnable {
    private Hashtable<Integer, MD_LSP> multiDomain_LSP_list;
    private Hashtable<Integer, MD_LSP> multiDomain_LSP_list_old;
    private Hashtable<Integer, MD_LSP> multiDomain_LSP_list_to_add;
    private Hashtable<Integer, MD_LSP> multiDomain_LSP_list_to_del;
    private Logger log = LoggerFactory.getLogger((String)"BGP4Parser");
    Jedis jedis;

    public void configure(MultiDomainLSPDB multiDomainLSPDB, String host, int port) {
        this.jedis = new Jedis(host, port);
        this.jedis.connect();
        this.multiDomain_LSP_list = multiDomainLSPDB.getMultiDomain_LSP_list();
    }

    @Override
    public void run() {
        this.log.info("Going to save LSP in DB");
        this.multiDomain_LSP_list_to_add = new Hashtable();
        this.multiDomain_LSP_list_to_del = new Hashtable();
        if (this.multiDomain_LSP_list != null) {
            String key;
            Integer id;
            Enumeration<Integer> ids;
            if (this.multiDomain_LSP_list_old == null) {
                this.multiDomain_LSP_list_old = new Hashtable();
                ids = this.multiDomain_LSP_list.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    this.multiDomain_LSP_list_old.put(id, this.multiDomain_LSP_list.get(id));
                    this.multiDomain_LSP_list_to_add.put(id, this.multiDomain_LSP_list.get(id));
                }
            } else {
                ids = this.multiDomain_LSP_list.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    if (this.multiDomain_LSP_list_old.containsKey(id)) continue;
                    this.multiDomain_LSP_list_to_add.put(id, this.multiDomain_LSP_list.get(id));
                    this.multiDomain_LSP_list_old.put(id, this.multiDomain_LSP_list.get(id));
                }
                ids = this.multiDomain_LSP_list_old.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    if (this.multiDomain_LSP_list.containsKey(id)) continue;
                    this.multiDomain_LSP_list_to_del.put(id, this.multiDomain_LSP_list.get(id));
                }
                ids = this.multiDomain_LSP_list_to_del.keys();
                while (ids.hasMoreElements()) {
                    id = ids.nextElement();
                    this.multiDomain_LSP_list_old.remove(id);
                }
            }
            ids = this.multiDomain_LSP_list_to_add.keys();
            while (ids.hasMoreElements()) {
                id = ids.nextElement();
                key = "LSP:" + id;
                String value = this.lspToJSON(this.multiDomain_LSP_list_to_add.get(id));
                this.jedis.set(key, value);
                this.jedis.sadd("lsps", new String[]{key});
            }
            ids = this.multiDomain_LSP_list_to_del.keys();
            while (ids.hasMoreElements()) {
                id = ids.nextElement();
                key = "LSP:" + id;
                this.jedis.del(new String[]{key});
                this.jedis.srem("lsps", new String[]{key});
            }
        }
    }

    public String lspToJSON(MD_LSP lsp) {
        Gson gson = new Gson();
        SimpleLSP slsp = new SimpleLSP();
        ExplicitRouteObject ero = lsp.getFullERO();
        Iterator erosolist = ero.getEROSubobjectList().iterator();
        int num = 0;
        while (erosolist.hasNext()) {
            EROSubobject eroso = (EROSubobject)erosolist.next();
            if (!(eroso instanceof UnnumberIfIDEROSubobject)) continue;
            ++num;
        }
        slsp.data = new SimpleLSPhop[num];
        erosolist = ero.getEROSubobjectList().iterator();
        int i = -1;
        while (erosolist.hasNext()) {
            EROSubobject eroso = (EROSubobject)erosolist.next();
            if (eroso instanceof UnnumberIfIDEROSubobject) {
                slsp.data[++i] = new SimpleLSPhop();
                slsp.data[i].routerID = ((UnnumberIfIDEROSubobject)eroso).routerID.getHostAddress();
                slsp.data[i].ifID = "" + ((UnnumberIfIDEROSubobject)eroso).interfaceID;
                continue;
            }
            if (eroso instanceof GeneralizedLabelEROSubobject) {
                if (slsp.data[i] == null) continue;
                slsp.data[i].n = "" + ((GeneralizedLabelEROSubobject)eroso).getDwdmWavelengthLabel().getN();
                slsp.data[i].m = "" + ((GeneralizedLabelEROSubobject)eroso).getDwdmWavelengthLabel().getM();
                continue;
            }
            if (!(eroso instanceof ETCEROSubobject) || slsp.data[i] == null) continue;
            slsp.data[i].transponder = "TX " + ((SubTransponderTLV)((ETCEROSubobject)eroso).getSubTransponderList().get(0)).getST_TLV_ModFormat().toString();
        }
        String json = gson.toJson((Object)slsp);
        return json;
    }

    public Hashtable<Integer, MD_LSP> getMultiDomain_LSP_list() {
        return this.multiDomain_LSP_list;
    }

    public void setMultiDomain_LSP_list(Hashtable<Integer, MD_LSP> multiDomain_LSP_list) {
        this.multiDomain_LSP_list = multiDomain_LSP_list;
    }
}

