/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import es.tid.pce.computingEngine.IniProcessorThread;
import es.tid.pce.computingEngine.InitiationRequest;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.MDLSPDB.MultiDomainLSPDB;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.tedb.ReachabilityManager;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDomainInitiateDispatcher {
    private LinkedBlockingQueue<InitiationRequest> lspIniRequestQueue;
    private Thread iniProcessorThread;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public MultiDomainInitiateDispatcher(ReachabilityManager reachabilityManager, ChildPCERequestManager childPCERequestManager, MultiDomainLSPDB multiDomainLSPDB) {
        this.lspIniRequestQueue = new LinkedBlockingQueue();
        this.iniProcessorThread = new IniProcessorThread(this.lspIniRequestQueue, reachabilityManager, childPCERequestManager, multiDomainLSPDB);
        this.iniProcessorThread.start();
    }

    public void dispathInitiate(PCEPInitiate iniMessage, DataOutputStream out, Inet4Address remotePeerIP) {
        this.log.info("Dispatching Initiate message from " + remotePeerIP);
        Iterator it = iniMessage.getPcepIntiatedLSPList().iterator();
        while (it.hasNext()) {
            InitiationRequest ir = new InitiationRequest();
            ir.setOut(out);
            ir.setRemotePeerIP(remotePeerIP);
            ir.setLspIniRequest((PCEPIntiatedLSP)it.next());
            this.lspIniRequestQueue.add(ir);
        }
    }
}

