/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import es.tid.bgp.bgp4.messages.BGP4Update;
import es.tid.bgp.bgp4Peer.updateTEDB.UpdateProccesorThread;
import es.tid.pce.parentPCE.MultiDomainTopologyUpdaterThread;
import es.tid.pce.parentPCE.MultiDomainUpdate;
import es.tid.pce.pcep.objects.Notification;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.MDTEDB;
import java.net.Inet4Address;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDomainTopologyUpdater {
    private Logger log;
    private MultiDomainTopologyUpdaterThread mdtuThread;
    private LinkedBlockingQueue<MultiDomainUpdate> multiDomainUpdateQueue;
    private MDTEDB multiDomainTEDB;
    private ITMDTEDB ITmultiDomainTEDB;
    private boolean bgpActivated = false;
    private LinkedBlockingQueue<BGP4Update> updateList;
    private UpdateProccesorThread updateProccesorThread;

    public MultiDomainTopologyUpdater(MDTEDB multiDomainTEDB, boolean bgpActivated) {
        this.log = LoggerFactory.getLogger((String)"MultiDomainTologyUpdater");
        this.multiDomainUpdateQueue = new LinkedBlockingQueue();
        this.multiDomainTEDB = multiDomainTEDB;
        this.bgpActivated = bgpActivated;
    }

    public MultiDomainTopologyUpdater(ITMDTEDB ITmultiDomainTEDB) {
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.multiDomainUpdateQueue = new LinkedBlockingQueue();
        this.updateList = new LinkedBlockingQueue();
        this.ITmultiDomainTEDB = ITmultiDomainTEDB;
    }

    public void initialize() {
        this.log.info("Multidomain Topology Updater initiated");
        this.mdtuThread = new MultiDomainTopologyUpdaterThread(this.multiDomainUpdateQueue, this.multiDomainTEDB);
        this.mdtuThread.start();
    }

    public void ITinitialize() {
        this.log.info("IT Multidomain Topology Updater initiated");
        this.mdtuThread = new MultiDomainTopologyUpdaterThread(this.multiDomainUpdateQueue, this.ITmultiDomainTEDB);
        this.mdtuThread.start();
    }

    public void processNotification(Notification notif, Inet4Address pceId, Inet4Address domainID) {
        MultiDomainUpdate multiDomainUpdate = new MultiDomainUpdate();
        multiDomainUpdate.setDomainID(domainID);
        multiDomainUpdate.setPCEID(pceId);
        multiDomainUpdate.setNotif(notif);
        this.multiDomainUpdateQueue.add(multiDomainUpdate);
    }

    public void dispathRequests(BGP4Update updateMessage) {
        this.log.info("Adding update message to the queue");
        this.updateList.add(updateMessage);
    }

    public void stopMultiDomainTopologyUpdater() {
        if (this.mdtuThread != null) {
            this.mdtuThread.interrupt();
        }
    }

    public String printLSAList() {
        return this.mdtuThread.printLSAList();
    }

    public String printLSAShortList() {
        return this.mdtuThread.printLSAShortList();
    }

    public int sizeLSAList() {
        return this.mdtuThread.sizeLSAList();
    }

    public UpdateProccesorThread getUpdateProccesorThread() {
        return this.updateProccesorThread;
    }
}

