/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import es.tid.ospf.ospfv2.lsa.InterASTEv2LSA;
import es.tid.ospf.ospfv2.lsa.tlv.LinkTLV;
import es.tid.pce.parentPCE.MultiDomainUpdate;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.tlvs.ITAdvertisementTLV;
import es.tid.pce.pcep.objects.tlvs.OSPFTE_LSA_TLV;
import es.tid.pce.pcep.objects.tlvs.ServerTLV;
import es.tid.pce.pcep.objects.tlvs.StorageTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.BlockSizeSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.CostSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.EPaddressSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.IdleConsumptionSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.InterStateLatenciesSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.LocationSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.MTUSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.MaxSpeedSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.MaximumConsumptionSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.NetworkAdapterSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.NetworkSpecSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.PowerInfoSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.PowerStateSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.PowerSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.ResourceIDSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.ServerStorageSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.SleepConsumptionSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.StorageInfoSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.StorageSizeSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.TNAIPv4SubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.TNAIPv6SubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.TNANSAPSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.VolumeInfoSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.VolumeSizeSubTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.VolumeSubTLV;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.MDTEDB;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDomainTopologyUpdaterThread
extends Thread {
    private Logger log = LoggerFactory.getLogger((String)"MultiDomainTologyUpdater");
    private LinkedBlockingQueue<MultiDomainUpdate> multiDomainUpdateQueue;
    private MDTEDB multiDomainTEDB;
    private ITMDTEDB ITmultiDomainTEDB;
    private LinkedList<InterASTEv2LSA> interASTEv2LSAList;

    public MultiDomainTopologyUpdaterThread(LinkedBlockingQueue<MultiDomainUpdate> multiDomainUpdateQueue, MDTEDB multiDomainTEDB) {
        this.multiDomainUpdateQueue = multiDomainUpdateQueue;
        this.multiDomainTEDB = multiDomainTEDB;
        this.interASTEv2LSAList = new LinkedList();
    }

    public MultiDomainTopologyUpdaterThread(LinkedBlockingQueue<MultiDomainUpdate> multiDomainUpdateQueue, ITMDTEDB ITmultiDomainTEDB) {
        this.multiDomainUpdateQueue = multiDomainUpdateQueue;
        this.ITmultiDomainTEDB = ITmultiDomainTEDB;
    }

    @Override
    public void run() {
        this.log.info("Starting Multidomain Topology Upadater Thread");
        while (true) {
            try {
                block5: while (true) {
                    MultiDomainUpdate multiDomainUpdate = this.multiDomainUpdateQueue.take();
                    Notification notif = multiDomainUpdate.getNotif();
                    this.log.debug("Processing Notification to update topology");
                    ITAdvertisementTLV ITadv = notif.getITadvtlv();
                    if (ITadv != null) {
                        LinkedList VolumesubtlvList;
                        StorageInfoSubTLV StorageInfosubtlv;
                        ServerStorageSubTLV ServerStoragesubtlv;
                        PowerSubTLV Powersubtlv;
                        NetworkSpecSubTLV NetworkSpecsubtlv;
                        LinkedList CostsubtlvList;
                        LocationSubTLV Locationsubtlv;
                        ServerTLV Server;
                        this.log.info("IT advertisement received!!");
                        Inet4Address IT_site = ITadv.getVirtual_IT_Site_ID();
                        this.log.info("Virtual IT site ID:" + IT_site);
                        int AdvType = ITadv.getAdv_Type();
                        this.log.info("Advertisement type:" + AdvType);
                        int AdvTrigger = ITadv.getAdv_Trigger();
                        this.log.info("Advertisement trigger:" + AdvTrigger);
                        StorageTLV Storage = notif.getStoragetlv();
                        if (Storage != null) {
                            LinkedList VolumesubtlvList2;
                            StorageInfoSubTLV StorageInfosubtlv2;
                            StorageSizeSubTLV StorageSizesubtlv;
                            PowerSubTLV Powersubtlv2;
                            NetworkSpecSubTLV NetworkSpecsubtlv2;
                            LinkedList CostsubtlvList2;
                            LocationSubTLV Locationsubtlv2;
                            Inet4Address ResourceID = null;
                            int TotalStorageSize = 0;
                            int AvailableStorageSize = 0;
                            this.log.info("Storage:");
                            ResourceIDSubTLV ResourceIDsubtlv = Storage.getResourceIDSubTLV();
                            if (ResourceIDsubtlv != null) {
                                ResourceID = ResourceIDsubtlv.getResourceID();
                                this.log.info("Resource ID:" + ResourceID);
                            }
                            if ((Locationsubtlv2 = Storage.getLocationSubTLV()) != null) {
                                int LaRes = Locationsubtlv2.getLaRes();
                                this.log.info("Latitude Resolution:" + LaRes);
                                byte[] Latitude = Locationsubtlv2.getLatitude();
                                this.log.info("Latitude:" + Latitude);
                                int LoRes = Locationsubtlv2.getLoRes();
                                this.log.info("Longitude Resolution:" + LoRes);
                                byte[] Longitude = Locationsubtlv2.getLongitude();
                                this.log.info("Longitude:" + Longitude);
                            }
                            if ((CostsubtlvList2 = Storage.getCostList()) != null) {
                                for (int i = 0; i < CostsubtlvList2.size(); ++i) {
                                    CostSubTLV Costsubtlv = (CostSubTLV)CostsubtlvList2.get(i);
                                    this.log.info("Coste " + i + ": Unit:" + Costsubtlv.getUsageUnit() + " Unitari price:" + Costsubtlv.getUnitaryPrice());
                                }
                            }
                            if ((NetworkSpecsubtlv2 = Storage.getNetworkSpecSubTLV()) != null) {
                                NetworkAdapterSubTLV Networkadaptersubtlv;
                                MaxSpeedSubTLV Maxspeedsubtlv;
                                MTUSubTLV MTUsubtlv;
                                TNANSAPSubTLV TNANSAPsubtlv;
                                TNAIPv6SubTLV TNAipv6subtlv;
                                TNAIPv4SubTLV TNAipv4subtlv;
                                EPaddressSubTLV EPaddresssubtlv = NetworkSpecsubtlv2.getEPaddress();
                                if (EPaddresssubtlv != null) {
                                    String EPaddress = EPaddresssubtlv.getEPaddress();
                                }
                                if ((TNAipv4subtlv = NetworkSpecsubtlv2.getTNAIPv4()) != null) {
                                    Inet4Address IPv4address = TNAipv4subtlv.getIPv4address();
                                }
                                if ((TNAipv6subtlv = NetworkSpecsubtlv2.getTNAIPv6()) != null) {
                                    Inet6Address IPv6address = TNAipv6subtlv.getIPv6address();
                                }
                                if ((TNANSAPsubtlv = NetworkSpecsubtlv2.getTNANSAP()) != null) {
                                    byte[] NSAPaddress = TNANSAPsubtlv.getNSAPaddress();
                                }
                                if ((MTUsubtlv = NetworkSpecsubtlv2.getMTU()) != null) {
                                    byte[] MTU = MTUsubtlv.getMTU();
                                }
                                if ((Maxspeedsubtlv = NetworkSpecsubtlv2.getMaxSpeed()) != null) {
                                    byte[] MaxSpeed = Maxspeedsubtlv.getMaxSpeed();
                                }
                                if ((Networkadaptersubtlv = NetworkSpecsubtlv2.getNetworkAdapter()) != null) {
                                    int NetworkAdapter = Networkadaptersubtlv.getAdapter_Type();
                                    int FullDupplex = Networkadaptersubtlv.getFullDupplex();
                                }
                            }
                            if ((Powersubtlv2 = Storage.getPowerSubTLV()) != null) {
                                PowerStateSubTLV PowerStatesubtlv;
                                InterStateLatenciesSubTLV InterStateLatenciessubtlv;
                                SleepConsumptionSubTLV SleepConsumptionsubtlv;
                                IdleConsumptionSubTLV IdleConsumptionsubtlv;
                                MaximumConsumptionSubTLV MaxConsumptionsubtlv;
                                PowerInfoSubTLV PowerInfosubtlv = Powersubtlv2.getPowerInfo();
                                if (PowerInfosubtlv != null) {
                                    int PowerSource = PowerInfosubtlv.getPowerSource();
                                    int PowerClass = PowerInfosubtlv.getPowerClass();
                                    int Regeneration = PowerInfosubtlv.getRegeneration();
                                }
                                if ((MaxConsumptionsubtlv = Powersubtlv2.getMaximumConsumptionSubTLV()) != null) {
                                    byte[] MaxConsumption = MaxConsumptionsubtlv.getMaximumConsumption();
                                }
                                if ((IdleConsumptionsubtlv = Powersubtlv2.getIdleConsumption()) != null) {
                                    byte[] IdleConsumption = IdleConsumptionsubtlv.getIdleConsumption();
                                }
                                if ((SleepConsumptionsubtlv = Powersubtlv2.getSleepConsumption()) != null) {
                                    byte[] SleepConsumption = SleepConsumptionsubtlv.getSleepConsumption();
                                }
                                if ((InterStateLatenciessubtlv = Powersubtlv2.getInterStateLatencies()) != null) {
                                    byte[] WakeUpLatency = InterStateLatenciessubtlv.getWakeUpLatency();
                                    byte[] PowerUpLatency = InterStateLatenciessubtlv.getPowerUpLatency();
                                }
                                if ((PowerStatesubtlv = Powersubtlv2.getPowerState()) != null) {
                                    byte PowerState = PowerStatesubtlv.getPowerState();
                                }
                            }
                            if ((StorageSizesubtlv = Storage.getStorageSizeSubTLV()) != null) {
                                TotalStorageSize = StorageSizesubtlv.getTotalSize();
                                this.log.info("Total Size:" + TotalStorageSize);
                                AvailableStorageSize = StorageSizesubtlv.getAvailableSize();
                                this.log.info("Available Size:" + AvailableStorageSize);
                            }
                            if ((StorageInfosubtlv2 = Storage.getStorageInfoSubTLV()) != null) {
                                int AccessStatus = StorageInfosubtlv2.getAccessStatus();
                                int Volatil = StorageInfosubtlv2.getVolatil();
                            }
                            if ((VolumesubtlvList2 = Storage.getVolumeList()) != null) {
                                for (int i = 0; i < VolumesubtlvList2.size(); ++i) {
                                    VolumeInfoSubTLV VolumeInfosubtlv;
                                    BlockSizeSubTLV BlockSizesubtlv;
                                    VolumeSubTLV Volumesubtlv = (VolumeSubTLV)VolumesubtlvList2.get(i);
                                    VolumeSizeSubTLV VolumeSizesubtlv = Volumesubtlv.getVolumeSize();
                                    if (VolumeSizesubtlv != null) {
                                        int TotalVolumeSize = VolumeSizesubtlv.getTotalSize();
                                        int AvailableVolumeSize = VolumeSizesubtlv.getAvailableSize();
                                    }
                                    if ((BlockSizesubtlv = Volumesubtlv.getBlockSizeSubTLV()) != null) {
                                        byte[] BlockSize = BlockSizesubtlv.getBlockSize();
                                    }
                                    if ((VolumeInfosubtlv = Volumesubtlv.getVolumeInfo()) == null) continue;
                                    int AccessStatus = VolumeInfosubtlv.getAccessStatus();
                                    int Volatil = VolumeInfosubtlv.getVolatil();
                                }
                            }
                            Inet4Address domainID = multiDomainUpdate.getDomainID();
                            this.ITmultiDomainTEDB.addStorage((Object)domainID, (Object)IT_site, AdvType, (Object)ResourceID, CostsubtlvList2, TotalStorageSize, AvailableStorageSize);
                        }
                        if ((Server = notif.getServertlv()) == null) continue;
                        this.log.info("Server:");
                        ResourceIDSubTLV ResourceIDsubtlv = Server.getResourceIDSubTLV();
                        if (ResourceIDsubtlv != null) {
                            Inet4Address ResourceID = ResourceIDsubtlv.getResourceID();
                            this.log.info("Resource ID:" + ResourceID);
                        }
                        if ((Locationsubtlv = Server.getLocationSubTLV()) != null) {
                            int LaRes = Locationsubtlv.getLaRes();
                            this.log.info("Latitude Resolution:" + LaRes);
                            byte[] Latitude = Locationsubtlv.getLatitude();
                            this.log.info("Latitude:" + Latitude);
                            int LoRes = Locationsubtlv.getLoRes();
                            this.log.info("Longitude Resolution:" + LoRes);
                            byte[] Longitude = Locationsubtlv.getLongitude();
                            this.log.info("Longitude:" + Longitude);
                        }
                        if ((CostsubtlvList = Server.getCostList()) != null) {
                            for (int i = 0; i < CostsubtlvList.size(); ++i) {
                                CostSubTLV Costsubtlv = (CostSubTLV)CostsubtlvList.get(i);
                                this.log.info("Coste " + i + ": Unit:" + Costsubtlv.getUsageUnit() + " Unitari price:" + Costsubtlv.getUnitaryPrice());
                            }
                        }
                        if ((NetworkSpecsubtlv = Server.getNetworkSpecSubTLV()) != null) {
                            NetworkAdapterSubTLV Networkadaptersubtlv;
                            MaxSpeedSubTLV Maxspeedsubtlv;
                            MTUSubTLV MTUsubtlv;
                            TNANSAPSubTLV TNANSAPsubtlv;
                            TNAIPv6SubTLV TNAipv6subtlv;
                            TNAIPv4SubTLV TNAipv4subtlv;
                            EPaddressSubTLV EPaddresssubtlv = NetworkSpecsubtlv.getEPaddress();
                            if (EPaddresssubtlv != null) {
                                String EPaddress = EPaddresssubtlv.getEPaddress();
                            }
                            if ((TNAipv4subtlv = NetworkSpecsubtlv.getTNAIPv4()) != null) {
                                Inet4Address IPv4address = TNAipv4subtlv.getIPv4address();
                            }
                            if ((TNAipv6subtlv = NetworkSpecsubtlv.getTNAIPv6()) != null) {
                                Inet6Address IPv6address = TNAipv6subtlv.getIPv6address();
                            }
                            if ((TNANSAPsubtlv = NetworkSpecsubtlv.getTNANSAP()) != null) {
                                byte[] NSAPaddress = TNANSAPsubtlv.getNSAPaddress();
                            }
                            if ((MTUsubtlv = NetworkSpecsubtlv.getMTU()) != null) {
                                byte[] MTU = MTUsubtlv.getMTU();
                            }
                            if ((Maxspeedsubtlv = NetworkSpecsubtlv.getMaxSpeed()) != null) {
                                byte[] MaxSpeed = Maxspeedsubtlv.getMaxSpeed();
                            }
                            if ((Networkadaptersubtlv = NetworkSpecsubtlv.getNetworkAdapter()) != null) {
                                int NetworkAdapter = Networkadaptersubtlv.getAdapter_Type();
                                int FullDupplex = Networkadaptersubtlv.getFullDupplex();
                            }
                        }
                        if ((Powersubtlv = Server.getPowerSubTLV()) != null) {
                            PowerStateSubTLV PowerStatesubtlv;
                            InterStateLatenciesSubTLV InterStateLatenciessubtlv;
                            SleepConsumptionSubTLV SleepConsumptionsubtlv;
                            IdleConsumptionSubTLV IdleConsumptionsubtlv;
                            MaximumConsumptionSubTLV MaxConsumptionsubtlv;
                            PowerInfoSubTLV PowerInfosubtlv = Powersubtlv.getPowerInfo();
                            if (PowerInfosubtlv != null) {
                                int PowerSource = PowerInfosubtlv.getPowerSource();
                                int PowerClass = PowerInfosubtlv.getPowerClass();
                                int Regeneration = PowerInfosubtlv.getRegeneration();
                            }
                            if ((MaxConsumptionsubtlv = Powersubtlv.getMaximumConsumptionSubTLV()) != null) {
                                byte[] MaxConsumption = MaxConsumptionsubtlv.getMaximumConsumption();
                            }
                            if ((IdleConsumptionsubtlv = Powersubtlv.getIdleConsumption()) != null) {
                                byte[] IdleConsumption = IdleConsumptionsubtlv.getIdleConsumption();
                            }
                            if ((SleepConsumptionsubtlv = Powersubtlv.getSleepConsumption()) != null) {
                                byte[] SleepConsumption = SleepConsumptionsubtlv.getSleepConsumption();
                            }
                            if ((InterStateLatenciessubtlv = Powersubtlv.getInterStateLatencies()) != null) {
                                byte[] WakeUpLatency = InterStateLatenciessubtlv.getWakeUpLatency();
                                byte[] PowerUpLatency = InterStateLatenciessubtlv.getPowerUpLatency();
                            }
                            if ((PowerStatesubtlv = Powersubtlv.getPowerState()) != null) {
                                byte PowerState = PowerStatesubtlv.getPowerState();
                            }
                        }
                        if ((ServerStoragesubtlv = Server.getServerStorageSubTLV()) == null) continue;
                        StorageSizeSubTLV StorageSizesubtlv = ServerStoragesubtlv.getStorageSize();
                        if (StorageSizesubtlv != null) {
                            int TotalSize = StorageSizesubtlv.getTotalSize();
                            this.log.info("Total Size:" + TotalSize);
                            int AvailableSize = StorageSizesubtlv.getAvailableSize();
                            this.log.info("Available Size:" + AvailableSize);
                        }
                        if ((StorageInfosubtlv = ServerStoragesubtlv.getStorageInfoSubTLV()) != null) {
                            int AccessStatus = StorageInfosubtlv.getAccessStatus();
                            int Volatil = StorageInfosubtlv.getVolatil();
                        }
                        if ((VolumesubtlvList = ServerStoragesubtlv.getVolumeList()) == null) continue;
                        int i = 0;
                        while (true) {
                            VolumeInfoSubTLV VolumeInfosubtlv;
                            BlockSizeSubTLV BlockSizesubtlv;
                            if (i >= VolumesubtlvList.size()) continue block5;
                            VolumeSubTLV Volumesubtlv = (VolumeSubTLV)VolumesubtlvList.get(i);
                            VolumeSizeSubTLV VolumeSizesubtlv = Volumesubtlv.getVolumeSize();
                            if (VolumeSizesubtlv != null) {
                                int TotalSize = VolumeSizesubtlv.getTotalSize();
                                int AvailableSize = VolumeSizesubtlv.getAvailableSize();
                            }
                            if ((BlockSizesubtlv = Volumesubtlv.getBlockSizeSubTLV()) != null) {
                                byte[] BlockSize = BlockSizesubtlv.getBlockSize();
                            }
                            if ((VolumeInfosubtlv = Volumesubtlv.getVolumeInfo()) != null) {
                                int AccessStatus = VolumeInfosubtlv.getAccessStatus();
                                int Volatil = VolumeInfosubtlv.getVolatil();
                            }
                            ++i;
                        }
                    }
                    LinkedList LSATLVList = notif.getLSATLVList();
                    if (LSATLVList != null) {
                        this.log.debug("Received OPSF_TE_LSA_TLV " + LSATLVList.size() + " LSAs");
                        int i = 0;
                        while (true) {
                            if (i >= LSATLVList.size()) continue block5;
                            OSPFTE_LSA_TLV tlv = (OSPFTE_LSA_TLV)LSATLVList.get(i);
                            InterASTEv2LSA interASTEv2LSA = tlv.getInterASTEv2LSA();
                            if (interASTEv2LSA != null) {
                                this.log.debug("InterASTEv2LSA received: " + interASTEv2LSA.printHeader());
                                if (this.interASTEv2LSAList.contains(interASTEv2LSA)) {
                                    this.log.debug("LSA already present");
                                } else {
                                    this.log.debug("NEW LSA, adding to the list and processing");
                                    this.interASTEv2LSAList.add(interASTEv2LSA);
                                    LinkTLV linkTLV = interASTEv2LSA.getLinkTLV();
                                    if (linkTLV != null) {
                                        this.log.debug("Processing LinkTLV");
                                        try {
                                            Inet4Address remoteAS = tlv.getInterASTEv2LSA().getLinkTLV().getRemoteASNumber().getRemoteASNumber();
                                            this.log.debug("Remote AS: " + remoteAS);
                                            Inet4Address remoteASBR = tlv.getInterASTEv2LSA().getLinkTLV().getiPv4RemoteASBRID().getIPv4RemoteASBRID();
                                            this.log.debug("Remote ASBR: " + remoteASBR);
                                            Inet4Address localAS = multiDomainUpdate.getDomainID();
                                            this.log.debug("Local AS: " + localAS);
                                            Inet4Address localASBR = tlv.getInterASTEv2LSA().getAdvertisingRouter();
                                            this.log.debug("Local ASBR: " + localASBR);
                                            long localRouterASBRIf = tlv.getInterASTEv2LSA().getLinkTLV().getLinkLocalRemoteIdentifiers().getLinkLocalIdentifier();
                                            long remoteRouterASBRIf = tlv.getInterASTEv2LSA().getLinkTLV().getLinkLocalRemoteIdentifiers().getLinkRemoteIdentifier();
                                            if (this.ITmultiDomainTEDB == null) {
                                                this.multiDomainTEDB.addInterdomainLink((Object)localAS, (Object)localASBR, localRouterASBRIf, (Object)remoteAS, (Object)remoteASBR, remoteRouterASBRIf, null);
                                            } else {
                                                this.ITmultiDomainTEDB.addInterdomainLink((Object)localAS, (Object)localASBR, localRouterASBRIf, (Object)remoteAS, (Object)remoteASBR, remoteRouterASBRIf, null);
                                            }
                                        }
                                        catch (Exception e) {
                                            this.log.error("Problem with Link TLV " + e.getStackTrace());
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    this.log.warn("LSATLVList esta a null");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(-1);
                continue;
            }
            break;
        }
    }

    public String printLSAList() {
        StringBuffer sb = new StringBuffer(20 + this.interASTEv2LSAList.size() * 100);
        sb.append(this.interASTEv2LSAList.size());
        sb.append(" LSAs\r\n");
        for (int i = 0; i < this.interASTEv2LSAList.size(); ++i) {
            sb.append(i);
            sb.append("--> ");
            sb.append(this.interASTEv2LSAList.get(i).toString());
            sb.append("\r\n");
            sb.append("------------------------\r\n");
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public String printLSAShortList() {
        StringBuffer sb = new StringBuffer(20 + this.interASTEv2LSAList.size() * 100);
        sb.append(this.interASTEv2LSAList.size());
        sb.append(" LSAs\r\n");
        for (int i = 0; i < this.interASTEv2LSAList.size(); ++i) {
            sb.append(i);
            sb.append("--> ");
            sb.append(this.interASTEv2LSAList.get(i).printShort());
            sb.append("\r\n");
            sb.append("------------------------\r\n");
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public int sizeLSAList() {
        return this.interASTEv2LSAList.size();
    }
}

