/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import es.tid.bgp.bgp4Peer.peer.BGPPeer;
import es.tid.pce.computingEngine.ReportDispatcher;
import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManager;
import es.tid.pce.computingEngine.algorithms.LocalChildRequestManager;
import es.tid.pce.computingEngine.algorithms.ParentPCEComputingAlgorithmManager;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.MDLSPDB.MultiDomainLSPDB;
import es.tid.pce.parentPCE.MultiDomainInitiateDispatcher;
import es.tid.pce.parentPCE.MultiDomainTopologyUpdater;
import es.tid.pce.parentPCE.ParentPCEServerParameters;
import es.tid.pce.parentPCE.ParentPCESession;
import es.tid.pce.parentPCE.management.ParentPCEManagementSever;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import es.tid.tedb.FileTEDBUpdater;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.MultiDomainTEDB;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.SimpleITTEDB;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Orchestrator {
    public static void main(String[] args) {
        MDTEDB ted;
        ParentPCEServerParameters params = args.length >= 1 ? new ParentPCEServerParameters(args[0]) : new ParentPCEServerParameters();
        params.initialize();
        Logger log = LoggerFactory.getLogger((String)"PCEServer");
        Logger log2 = LoggerFactory.getLogger((String)"PCEPParser");
        Logger log3 = LoggerFactory.getLogger((String)"OSPFParser");
        PCEPSessionsInformation pcepSessionManager = new PCEPSessionsInformation();
        pcepSessionManager.setLocalPcepCapability(params.getLocalPcepCapability());
        try {
            Logger logGUI = LoggerFactory.getLogger((String)"GUILogger");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(-1);
        }
        log.info("Inizializing Orchestrator");
        Object simple_ted = null;
        Hashtable intraTEDBs = null;
        LocalChildRequestManager localChildRequestManager = null;
        ReachabilityManager rm = new ReachabilityManager();
        if (!params.isITCapable()) {
            if (params.isMultiDomain() && !params.isKnowsWholeTopology()) {
                log.info("The PCE is multidomain");
                ted = new MDTEDB();
                ted.setReachability(rm.getReachability());
                if (params.isReadMDTEDFromFile()) {
                    ted.initializeFromFile(params.getMDnetworkDescriptionFile());
                    ted.initializeFullTEDFromFile(params.getNetworkDescriptionFile());
                }
            } else if (params.isKnowsWholeTopology()) {
                if (params.isTest()) {
                    ted = new MDTEDB();
                    FileTEDBUpdater.initializeReachabilityFromFile((String)params.getNetworkDescriptionFile(), (ReachabilityManager)rm);
                    ted.setNetworkDomainGraph(FileTEDBUpdater.readMDNetwork((String)params.getNetworkDescriptionFile()));
                    intraTEDBs = FileTEDBUpdater.readMultipleDomainSimpleNetworks((String)params.getNetworkDescriptionFile(), null, (boolean)true, (int)0, (int)100, (boolean)false);
                } else {
                    log.info("The PCE knows the whole topology. Interdomain and intradomain");
                    ted = new MDTEDB();
                    FileTEDBUpdater.initializeReachabilityFromFile((String)params.getReachFile(), (ReachabilityManager)rm);
                    intraTEDBs = FileTEDBUpdater.readMultipleDomainSimpleNetworks((String)params.getReachFile(), null, (boolean)true, (int)0, (int)100, (boolean)false);
                    ted.setNetworkDomainGraph(FileTEDBUpdater.readMDNetwork((String)params.getTotalFile()));
                    ted.setReachability(rm.getReachability());
                    if (params.isReadMDTEDFromFile()) {
                        ted.initializeFromFile(params.getMDnetworkDescriptionFile());
                        ted.initializeFullTEDFromFile(params.getNetworkDescriptionFile());
                    }
                    localChildRequestManager = new LocalChildRequestManager();
                    log.info("Adding Intradomain topologies to multidomain tedb");
                    log.info("Intradomain topologies added to multidomain tedb");
                }
            } else {
                log.info("The PCE is single domain");
                ted = new SimpleTEDB();
                ted.initializeFromFile(params.getNetworkDescriptionFile());
            }
            MultiDomainTopologyUpdater mdt = null;
            if (params.isActingAsBGP4Peer()) {
                log.info("Acting as BGP peer");
                BGPPeer bgpPeer = new BGPPeer();
                if (params.isMultiDomain()) {
                    if (params.isKnowsWholeTopology()) {
                        bgpPeer.configure(params.getBGP4File(), (MultiDomainTEDB)ted, intraTEDBs);
                    } else {
                        bgpPeer.configure(params.getBGP4File());
                    }
                }
                bgpPeer.createUpdateDispatcher();
                bgpPeer.startClient();
                bgpPeer.startServer();
                if (bgpPeer.isSaveTopology()) {
                    bgpPeer.startSaveTopology();
                }
                bgpPeer.startManagementServer();
                bgpPeer.startSendTopology();
            } else {
                mdt = new MultiDomainTopologyUpdater(ted, params.isActingAsBGP4Peer());
                mdt.initialize();
            }
            if (params.isMultiDomain() && params.isReadMDTEDFromFile()) {
                FileTEDBUpdater.initializeReachabilityFromFile((String)params.getMDnetworkDescriptionFile(), (ReachabilityManager)rm);
            }
            ChildPCERequestManager childPCERequestManager = new ChildPCERequestManager();
            log.info("Inizializing " + params.getChildPCERequestsProcessors() + " Path Request Processor Threads");
            RequestDispatcher requestDispatcher = params.isKnowsWholeTopology() ? new RequestDispatcher(params.getChildPCERequestsProcessors(), (TEDB)ted, null, false, intraTEDBs) : new RequestDispatcher(params.getChildPCERequestsProcessors(), (TEDB)ted, null, false);
            MultiDomainLSPDB multiDomainLSPDB = new MultiDomainLSPDB();
            log.info("Inizializing " + params.getChildPCERequestsProcessors() + " Ini Dispatcher");
            MultiDomainInitiateDispatcher mdiniDispatcher = new MultiDomainInitiateDispatcher(rm, childPCERequestManager, multiDomainLSPDB);
            log.info(String.valueOf(params.algorithmRuleList.size()));
            for (int i = 0; i < params.algorithmRuleList.size(); ++i) {
                log.info(params.algorithmRuleList.get((int)i).algoName);
                log.info(params.algorithmRuleList.get((int)i).ar.toString());
                try {
                    ComputingAlgorithmManager cam;
                    Class<?> aClass = Class.forName("es.tid.pce.computingEngine.algorithms." + params.algorithmRuleList.get((int)i).algoName + "Manager");
                    log.info("Registering algorithm " + params.algorithmRuleList.get((int)i).algoName + " for of = " + params.algorithmRuleList.get((int)i).ar.of + " and svec = " + params.algorithmRuleList.get((int)i).ar.svec);
                    if (!params.algorithmRuleList.get((int)i).isParentPCEAlgorithm) {
                        log.info("No Parent PCE Algo");
                        cam = (ComputingAlgorithmManager)aClass.newInstance();
                        requestDispatcher.registerAlgorithm(params.algorithmRuleList.get((int)i).ar, cam);
                        continue;
                    }
                    log.info("Parent PCE Algo");
                    cam = (ParentPCEComputingAlgorithmManager)aClass.newInstance();
                    cam.setChildPCERequestManager(childPCERequestManager);
                    if (params.isKnowsWholeTopology()) {
                        log.info("Introducimos el localChildRequestManager en la cam");
                        cam.setLocalChildRequestManager(localChildRequestManager);
                    }
                    cam.setReachabilityManager(rm);
                    requestDispatcher.registerAlgorithm(params.algorithmRuleList.get((int)i).ar, cam);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ReportDispatcher stateReportDispatcher = null;
            ReportDB_Handler rptdb = new ReportDB_Handler();
            stateReportDispatcher = new ReportDispatcher(rptdb, 2);
            if (params.getLocalPcepCapability().isStateful()) {
                // empty if block
            }
            log.info("Initializing Management Server");
            ParentPCEManagementSever pms = new ParentPCEManagementSever(childPCERequestManager, requestDispatcher, ted, simple_ted, rm, pcepSessionManager, mdt, params.getParentPCEManagementPort(), multiDomainLSPDB);
            pms.start();
            ServerSocket serverSocket = null;
            boolean listening = true;
            try {
                log.info("Listening on port: " + params.getParentPCEServerPort());
                serverSocket = new ServerSocket(params.getParentPCEServerPort());
            }
            catch (IOException e) {
                System.err.println("Could not listen on port: " + params.getParentPCEServerPort());
                System.exit(-1);
            }
            try {
                while (listening) {
                    new ParentPCESession(serverSocket.accept(), params, requestDispatcher, mdiniDispatcher, (TEDB)ted, mdt, childPCERequestManager, rm, pcepSessionManager).start();
                }
                serverSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            log.info("The PCE is IT capable");
            if (params.isMultiDomain()) {
                log.info("The PCE is multidomain");
                ted = new ITMDTEDB();
                ((ITMDTEDB)ted).initializeFullTEDFromFile(params.getITNetworkDescriptionFile());
                if (params.isReadMDTEDFromFile()) {
                    ((ITMDTEDB)ted).initializeFromFile(params.getITMDnetworkDescriptionFile());
                }
            } else {
                log.info("The PCE is single domain");
                ted = new SimpleITTEDB();
                ted.initializeFromFile(params.getITNetworkDescriptionFile());
            }
            MultiDomainTopologyUpdater mdt = new MultiDomainTopologyUpdater((ITMDTEDB)ted);
            mdt.ITinitialize();
            if (params.isMultiDomain() && params.isReadMDTEDFromFile()) {
                FileTEDBUpdater.initializeReachabilityFromFile((String)params.getITMDnetworkDescriptionFile(), (ReachabilityManager)rm);
            }
            ChildPCERequestManager childPCERequestManager = new ChildPCERequestManager();
            log.info("Inizializing " + params.getChildPCERequestsProcessors() + " Path Request Processor Threads");
            RequestDispatcher requestDispatcher = new RequestDispatcher(params.getChildPCERequestsProcessors(), (TEDB)ted, null, false, intraTEDBs);
            log.info("Inizializing " + params.getChildPCERequestsProcessors() + " Ini Dispatcher");
            MultiDomainLSPDB multiDomainLSPDB = new MultiDomainLSPDB();
            MultiDomainInitiateDispatcher mdiniDispatcher = new MultiDomainInitiateDispatcher(rm, childPCERequestManager, multiDomainLSPDB);
            for (int i = 0; i < params.algorithmRuleList.size(); ++i) {
                try {
                    ComputingAlgorithmManager cam;
                    Class<?> aClass = Class.forName("es.tid.pce.computingEngine.algorithms." + params.algorithmRuleList.get((int)i).algoName + "Manager");
                    log.info("Registering algorithm " + params.algorithmRuleList.get((int)i).algoName + " for of = " + params.algorithmRuleList.get((int)i).ar.of + " and svec = " + params.algorithmRuleList.get((int)i).ar.svec);
                    if (!params.algorithmRuleList.get((int)i).isParentPCEAlgorithm) {
                        cam = (ComputingAlgorithmManager)aClass.newInstance();
                        requestDispatcher.registerAlgorithm(params.algorithmRuleList.get((int)i).ar, cam);
                        continue;
                    }
                    cam = (ParentPCEComputingAlgorithmManager)aClass.newInstance();
                    cam.setChildPCERequestManager(childPCERequestManager);
                    cam.setReachabilityManager(rm);
                    requestDispatcher.registerAlgorithm(params.algorithmRuleList.get((int)i).ar, cam);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            log.info("Initializing Management Server");
            ParentPCEManagementSever pms = new ParentPCEManagementSever(childPCERequestManager, requestDispatcher, (ITMDTEDB)ted, rm, pcepSessionManager, mdt, params.getParentPCEManagementPort());
            pms.start();
            ServerSocket serverSocket = null;
            boolean listening = true;
            try {
                log.info("Listening on port: " + params.getParentPCEServerPort());
                serverSocket = new ServerSocket(params.getParentPCEServerPort());
            }
            catch (IOException e) {
                System.err.println("Could not listen on port: " + params.getParentPCEServerPort());
                System.exit(-1);
            }
            try {
                pcepSessionManager.setStateful(true);
                while (listening) {
                    new ParentPCESession(serverSocket.accept(), params, requestDispatcher, mdiniDispatcher, (TEDB)((ITMDTEDB)ted), mdt, childPCERequestManager, rm, pcepSessionManager).start();
                }
                serverSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

