/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.MultiDomainInitiateDispatcher;
import es.tid.pce.parentPCE.MultiDomainTopologyUpdater;
import es.tid.pce.parentPCE.ParentPCEServerParameters;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPClose;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.tlvs.ReachabilityTLV;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.TEDB;
import java.io.IOException;
import java.net.Socket;
import java.util.Calendar;
import java.util.Timer;
import org.slf4j.LoggerFactory;

public class ParentPCESession
extends GenericPCEPSession {
    private MultiDomainTopologyUpdater mdt;
    private ParentPCEServerParameters params;
    private RequestDispatcher requestDispatcher;
    private ChildPCERequestManager childPCERequestManager;
    private ReachabilityManager rm;
    private static int reqIDCounter = 0;
    private MultiDomainInitiateDispatcher mdiniDispatcher;

    public ParentPCESession(Socket s, ParentPCEServerParameters params, RequestDispatcher requestDispatcher, MultiDomainInitiateDispatcher mdiniDispatcher, TEDB ted, MultiDomainTopologyUpdater mdt, ChildPCERequestManager childPCERequestManager, ReachabilityManager rm, PCEPSessionsInformation pcepSessionManager) {
        super(pcepSessionManager);
        this.setFSMstate(0);
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.log.info("New Parent PCESession: " + s);
        this.socket = s;
        this.requestDispatcher = requestDispatcher;
        this.mdt = mdt;
        this.rm = rm;
        this.params = params;
        this.timer = new Timer();
        this.keepAliveLocal = params.getKeepAliveTimer();
        this.deadTimerLocal = params.getDeadTimer();
        this.childPCERequestManager = childPCERequestManager;
        this.mdiniDispatcher = mdiniDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block43: {
            this.initializePCEPSession(this.params.isZeroDeadTimerPCCAccepted(), this.params.getMinKeepAliveTimerPCCAccepted(), this.params.getMaxDeadTimerPCCAccepted(), true, false, null, null, 0);
            domain = "hola";
            this.childPCERequestManager.registerDomainSession(this.remoteDomainId, this.remotePCEId, this.out);
            this.log.info("PCE Session succesfully established with " + this.remotePeerIP + " and deadTimerLocal " + this.deadTimerLocal);
            this.deadTimerT = new DeadTimerThread(this, this.deadTimerLocal);
            this.startDeadTimer();
            this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveLocal);
            this.startKeepAlive();
            while (this.FSMstate == 4) {
                try {
                    this.msg = this.readMsg(this.in);
                }
                catch (IOException e) {
                    this.log.warn("Finishing PCEP Session abruptly");
                    this.killSession();
                    return;
                }
                if (this.msg == null) continue;
                pceMsg = true;
                switch (PCEPMessage.getMessageType((byte[])this.msg)) {
                    case 1: {
                        this.log.debug("OPEN message received");
                        this.log.warn("OPEN message ignored");
                        break;
                    }
                    case 2: {
                        this.log.debug("PCEP KEEPALIVE message received from " + this.remotePeerIP);
                        break;
                    }
                    case 7: {
                        this.log.debug("CLOSE message received from " + this.remotePeerIP);
                        try {
                            m_close = new PCEPClose(this.msg);
                            this.log.warn("Closing due to reason " + m_close.getReason());
                            this.killSession();
                            return;
                        }
                        catch (PCEPProtocolViolationException e1) {
                            this.log.warn("Problem decoding message, closing session" + e1.getMessage());
                            this.killSession();
                            return;
                        }
                    }
                    case 10: {
                        if (this.localPcepCapability.isStateful()) {
                            this.log.info("Received report from " + this.remotePeerIP);
                            try {
                                pcrpt = new PCEPReport(this.msg);
                                for (StateReport sr : pcrpt.getStateReportList()) {
                                    srp = sr.getSRP();
                                    if (srp == null || (lock = this.childPCERequestManager.inilocks.get(sr.getSRP().getSRP_ID_number())) == null) continue;
                                    var8_19 = lock;
                                    synchronized (var8_19) {
                                        this.childPCERequestManager.notifyReport(sr);
                                    }
                                }
                                break;
                            }
                            catch (PCEPProtocolViolationException e) {
                                e.printStackTrace();
                                break;
                            }
                        }
                        this.log.warn("PCE is NOT stateful, ignored report from " + this.remotePeerIP);
                        break;
                    }
                    case 6: {
                        this.log.debug("ERROR message received");
                        break;
                    }
                    case 5: {
                        try {
                            m_not = new PCEPNotification(this.msg);
                            block31: for (i = 0; i < m_not.getNotifyList().size(); ++i) {
                                notifType = ((Notification)((Notify)m_not.getNotifyList().get(i)).getNotificationList().get(0)).getNotificationType();
                                if (notifType != 1) {
                                    if (notifType == 100) {
                                        this.log.info("Reachability Notification received");
                                        reachabilityTLVList = ((Notification)((Notify)m_not.getNotifyList().get(i)).getNotificationList().get(0)).getReachabilityTLVList();
                                        if (reachabilityTLVList != null) {
                                            this.log.debug("Reachability TLV List not null and size " + reachabilityTLVList.size());
                                            ii = 0;
                                            break block43;
                                        }
                                        this.log.info("Reachability TLV NULL");
                                    } else if (notifType == 101) {
                                        this.log.debug("Topology Notification received");
                                    } else if (notifType == 4) {
                                        this.mdt.processNotification((Notification)((Notify)m_not.getNotifyList().get(i)).getNotificationList().get(0), this.remotePCEId, this.remoteDomainId);
                                    }
                                }
                            }
                            break;
                        }
                        catch (PCEPProtocolViolationException e1) {
                            this.log.warn("Problem decoding notify message, ignoring message" + e1.getMessage());
                            e1.printStackTrace();
                            break;
                        }
                    }
                    case 4: {
                        this.log.info("Received PC RESPONSE message");
                        try {
                            pcres = new PCEPResponse(this.msg);
                            this.log.info("IdResponse: " + pcres.getResponse(0).getRequestParameters().getRequestID());
                            notifType = this.childPCERequestManager.locks.get(pcres.getResponse(0).getRequestParameters().getRequestID());
                            synchronized (notifType) {
                                this.childPCERequestManager.notifyResponse(pcres);
                            }
                        }
                        catch (PCEPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 3: {
                        this.log.info("PCREQ message received");
                        try {
                            p_req = new PCEPRequest(this.msg);
                            this.log.info(p_req.toString());
                        }
                        catch (PCEPProtocolViolationException e) {
                            e.printStackTrace();
                            break;
                        }
                        this.requestDispatcher.dispathRequests(p_req, this.out, this.remotePCEId);
                        break;
                    }
                    case 12: {
                        this.log.info("PCINI message received from " + this.remotePeerIP);
                        try {
                            p_ini = new PCEPInitiate(this.msg);
                            this.log.info(p_ini.toString());
                        }
                        catch (PCEPProtocolViolationException e) {
                            e.printStackTrace();
                            break;
                        }
                        this.mdiniDispatcher.dispathInitiate(p_ini, this.out, this.remotePeerIP);
                        break;
                    }
                    default: {
                        this.log.warn("ERROR: unexpected message from " + this.remotePeerIP);
                        pceMsg = false;
                    }
                }
                if (!pceMsg) continue;
                this.log.debug("Reseting Dead Timer as PCEP Message has arrived in " + this.remotePeerIP);
                this.resetDeadTimer();
            }
            return;
        }
        while (true) {
            if (ii >= reachabilityTLVList.size()) ** continue;
            EROSubobjectList = ((ReachabilityTLV)reachabilityTLVList.get(ii)).getEROSubobjectList();
            this.log.debug("EROSubobjectList size " + EROSubobjectList.size());
            for (jj = 0; jj < EROSubobjectList.size(); ++jj) {
            }
            ++ii;
        }
    }

    @Override
    public void endSession() {
        this.log.error("Removing domain " + this.remoteDomainId + " due to endSession from " + this.remotePeerIP);
        this.childPCERequestManager.removeDomain(this.remoteDomainId);
    }

    public static synchronized int getNewReqIDCounter() {
        int newReqId;
        if (reqIDCounter == 0) {
            Calendar rightNow = Calendar.getInstance();
            reqIDCounter = newReqId = rightNow.get(13);
        } else {
            reqIDCounter = newReqId = reqIDCounter + 1;
        }
        return newReqId;
    }
}

