/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentPCESessionsControler
extends SecurityManager {
    private boolean acceptAll = true;
    private HashSet<String> acceptList;
    private HashSet<String> blackList;
    private HashSet<String> activeSessionList;
    private int activeSessions = 0;
    private int maxSessions = 1;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public ParentPCESessionsControler() {
        this.acceptList = new HashSet();
        this.blackList = new HashSet();
        this.activeSessionList = new HashSet();
    }

    @Override
    public void checkAccept(String host, int port) throws SecurityException, NullPointerException {
        this.log.info("checkAccept host " + host + " port " + port);
        if (port == 4189) {
            if (this.acceptAll) {
                if (this.blackList.contains(host)) {
                    super.checkAccept(host, port);
                }
            } else if (!this.acceptList.contains(host)) {
                super.checkAccept(host, port);
            }
            if (this.activeSessions >= this.maxSessions) {
                super.checkAccept(host, port);
            } else {
                if (this.activeSessionList.contains(host)) {
                    super.checkAccept(host, port);
                }
                this.log.info("Session admitted!!");
                this.activeSessionList.add(host);
                ++this.activeSessions;
            }
        }
    }

    public void removeSession(String host) {
        this.activeSessionList.remove(host);
        --this.activeSessions;
    }
}

