/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE.management;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.computingEngine.RequestProcessorThread;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManager;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.MDLSPDB.MultiDomainLSPDB;
import es.tid.pce.parentPCE.MultiDomainTopologyUpdater;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.SimpleTEDB;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentPCEManagementSession
extends Thread {
    private boolean started = false;
    private Socket socket;
    private Logger log;
    private ChildPCERequestManager cprm;
    private RequestDispatcher requestDispatcher;
    private PrintStream out;
    private MDTEDB mdtedb;
    private SimpleTEDB simpleTedb;
    private ITMDTEDB ITmdtedb;
    private ReachabilityManager rm;
    private boolean isITcapable = false;
    private PCEPSessionsInformation pcepSessionManager;
    private MultiDomainTopologyUpdater mdtu;
    private MultiDomainLSPDB multiDomainLSPDB;

    public ParentPCEManagementSession(Socket s, ChildPCERequestManager cprm, RequestDispatcher requestDispatcher, MDTEDB mdtedb, SimpleTEDB simpleTedb, ReachabilityManager rm, PCEPSessionsInformation pcepSessionManager, MultiDomainTopologyUpdater mdtu, MultiDomainLSPDB multiDomainLSPDB) {
        this.socket = s;
        this.cprm = cprm;
        this.requestDispatcher = requestDispatcher;
        this.mdtedb = mdtedb;
        this.rm = rm;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.isITcapable = false;
        this.pcepSessionManager = pcepSessionManager;
        this.mdtu = mdtu;
        this.simpleTedb = simpleTedb;
        this.multiDomainLSPDB = multiDomainLSPDB;
    }

    public ParentPCEManagementSession(Socket s, ChildPCERequestManager cprm, RequestDispatcher requestDispatcher, ITMDTEDB ITmdtedb, ReachabilityManager rm, PCEPSessionsInformation pcepSessionManager, MultiDomainTopologyUpdater mdtu) {
        this.socket = s;
        this.cprm = cprm;
        this.requestDispatcher = requestDispatcher;
        this.ITmdtedb = ITmdtedb;
        this.rm = rm;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.isITcapable = true;
        this.pcepSessionManager = pcepSessionManager;
        this.mdtu = mdtu;
    }

    @Override
    public void run() {
        this.log.info("Starting Management session");
        boolean running = true;
        try {
            this.out = new PrintStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while (running) {
                String command;
                block34: {
                    if (!this.started) {
                        this.out.print("\n");
                        this.out.print("   ---              ,\r\n");
                        this.out.print("  | P |              ,\r\n");
                        this.out.print("  | C |              |'.             ,\r\n");
                        this.out.print("  | E |              |  '-._        / )\r\n");
                        this.out.print("  |   |            .'  .._  ',     /_'-,\r\n");
                        this.out.print("  | P |           '   /  _'.'_\\   /._)')\r\n");
                        this.out.print("  | A |          :   /  '_' '_'  /  _.'\r\n");
                        this.out.print("  | R |          |E |   |Q| |Q| /   /\r\n");
                        this.out.print("  | E |         .'  _\\  '-' '-'    /\r\n");
                        this.out.print("  | N |       .'--.(S     ,__` )  /\r\n");
                        this.out.print("  | T |             '-.     _.'  /\r\n");
                        this.out.print("  |   |           __.--'----(   /\r\n");
                        this.out.print("  | C |       _.-'     :   __\\ /\r\n");
                        this.out.print("  | O |      (      __.' :'  :Y\r\n");
                        this.out.print("  | N |       '.   '._,  :   :|\r\n");
                        this.out.print("  | T |          '.     ) :.__:|\r\n");
                        this.out.print("  | R |            \\    \\______/\r\n");
                        this.out.print("  | O |             '._L/_H____]\r\n");
                        this.out.print("  | L |              /_        /\r\n");
                        this.out.print("  | L |             /  '-.__.-')\r\n");
                        this.out.print("  | E |            :      /   /\r\n");
                        this.out.print("  | R |            :     /   /\r\n");
                        this.out.print("   ---           ,/_____/----;\r\n");
                        this.out.print("                '._____)----'\r\n");
                        this.out.print("                /     /   /\r\n");
                        this.out.print("               /     /   /\r\n");
                        this.out.print("             .'     /    \\\r\n");
                        this.out.print("            (______(-.____)\r\n");
                        this.out.print("***********************************************\n");
                        this.started = true;
                    }
                    this.out.print("\nAvailable commands:\r\n\n");
                    this.out.print("\t1)show child pces\r\n");
                    this.out.print("\t2)show algorithms list\r\n");
                    this.out.print("\t3)show topology\r\n");
                    this.out.print("\t4)show reachability\r\n");
                    this.out.print("\t5)show mdlspdb\r\n");
                    this.out.print("\t6)queue size\r\n");
                    this.out.print("\t7)show sessions\r\n");
                    this.out.print("\t8)show capabilities\r\n");
                    this.out.print("\t9)show peers\r\n");
                    this.out.print("\t10)show peers detail\r\n");
                    this.out.print("\t11)set traces on\r\n");
                    this.out.print("\t12)set traces off\r\n");
                    this.out.print("\n\tENTER) quit\r\n");
                    this.out.print("PCE:>");
                    command = null;
                    try {
                        command = br.readLine();
                        if (command != null) break block34;
                        try {
                            this.out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            br.close();
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException ioe) {
                        this.out.print("IO error trying to read your command");
                        this.log.warn("IO error trying to read your command");
                        return;
                    }
                }
                if (command.equals("quit") || command.equals("")) {
                    this.log.info("Ending Management Session");
                    this.out.println("bye!");
                    try {
                        this.out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (command.equals("show child pces") || command.equals("1")) {
                    Enumeration<Inet4Address> pceIds = this.cprm.getDomainIdpceId().elements();
                    Enumeration<Inet4Address> domains = this.cprm.getDomainIdpceId().keys();
                    while (pceIds.hasMoreElements()) {
                        this.out.print("PCE Id: " + pceIds.nextElement() + " Domain Id: " + domains.nextElement() + "\r\n");
                    }
                    continue;
                }
                if (command.equals("show algorithms list") || command.equals("show algo list") || command.equals("2")) {
                    RequestProcessorThread[] threads = this.requestDispatcher.getThreads();
                    String info = "";
                    if (threads.length > 0) {
                        Hashtable<Integer, ComputingAlgorithmManager> htcaSingle = threads[0].getSingleAlgorithmList();
                        Enumeration<Integer> keys = htcaSingle.keys();
                        while (keys.hasMoreElements()) {
                            Integer inte = keys.nextElement();
                            info = info + "OF =" + inte + "; ";
                        }
                        Hashtable<Integer, ComputingAlgorithmManager> htcaSvec = threads[0].getSvecAlgorithmList();
                        Enumeration<Integer> keys2 = htcaSvec.keys();
                        while (keys2.hasMoreElements()) {
                            Integer inte = keys2.nextElement();
                            info = info + "OF =" + inte + "and SVEC; ";
                        }
                    }
                    this.out.print(info + "\r\n");
                    continue;
                }
                if (command.equals("show topology") && !this.isITcapable || command.equals("3") && !this.isITcapable) {
                    this.out.print(this.mdtedb.printMDTopology());
                    if (this.simpleTedb == null) continue;
                    this.out.print("\nSIMPLE TEDB1:\n");
                    this.out.print(this.simpleTedb.printTopology());
                    continue;
                }
                if (command.equals("show topology") && this.isITcapable || command.equals("3") && !this.isITcapable) {
                    this.out.print(this.ITmdtedb.printTopology());
                    if (this.simpleTedb == null) continue;
                    this.out.print("\nSIMPLE TEDB2:\n");
                    this.out.print(this.simpleTedb.printTopology());
                    continue;
                }
                if (command.equals("show reachability") || command.equals("4")) {
                    this.out.print(this.rm.printReachability());
                    continue;
                }
                if (command.equals("show mdlspdb") || command.equals("5")) {
                    if (this.multiDomainLSPDB == null) continue;
                    this.out.print(this.multiDomainLSPDB.toString());
                    continue;
                }
                if (command.equals("queue size") || command.equals("6")) {
                    this.out.print("num pets " + this.requestDispatcher.queueSize());
                    continue;
                }
                if (command.equals("show sessions") || command.equals("7")) {
                    this.out.print(this.pcepSessionManager.toString());
                    this.out.print("\r\n");
                    continue;
                }
                if (command.equals("show capabilities") || command.equals("8")) {
                    this.out.print(this.pcepSessionManager.getLocalPcepCapability().toString());
                    this.out.print("\r\n");
                    continue;
                }
                if (command.equals("show peers") || command.equals("9")) {
                    this.out.print(this.pcepSessionManager.printPeersInfo());
                    this.out.print("\r\n");
                    continue;
                }
                if (command.equals("show peers detail") || command.equals("10")) {
                    this.out.print(this.pcepSessionManager.printFullPeersInfo());
                    this.out.print("\r\n");
                    continue;
                }
                if (command.equals("set traces on") || command.equals("11")) {
                    this.out.print("traces on!\r\n");
                    continue;
                }
                if (command.equals("set traces off") || command.equals("12")) {
                    this.out.print("traces off!\r\n");
                    continue;
                }
                this.out.print("invalid command\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

