/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.parentPCE.management;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.MDLSPDB.MultiDomainLSPDB;
import es.tid.pce.parentPCE.MultiDomainTopologyUpdater;
import es.tid.pce.parentPCE.management.ParentPCEManagementSession;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.SimpleTEDB;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentPCEManagementSever
extends Thread {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ChildPCERequestManager cprm;
    private RequestDispatcher requestDispatcher;
    private MDTEDB mdtedb;
    private MultiDomainLSPDB multiDomainLSPDB;
    private SimpleTEDB simpleTedb;
    private ITMDTEDB ITmdtedb;
    private ReachabilityManager rm;
    private boolean isITcapable = false;
    private PCEPSessionsInformation pcepSessionManager;
    private MultiDomainTopologyUpdater mdtu;
    private int parentPCEManagementPort;

    public ParentPCEManagementSever(ChildPCERequestManager cprm, RequestDispatcher requestDispatcher, MDTEDB mdtedb, SimpleTEDB simpleTEDB, ReachabilityManager rm, PCEPSessionsInformation pcepSessionManager, MultiDomainTopologyUpdater mdtu, int parentPCEManagementPort, MultiDomainLSPDB multiDomainLSPDB) {
        this.cprm = cprm;
        this.requestDispatcher = requestDispatcher;
        this.mdtedb = mdtedb;
        this.simpleTedb = simpleTEDB;
        this.rm = rm;
        this.isITcapable = false;
        this.pcepSessionManager = pcepSessionManager;
        this.mdtu = mdtu;
        this.parentPCEManagementPort = parentPCEManagementPort;
        this.multiDomainLSPDB = multiDomainLSPDB;
    }

    public ParentPCEManagementSever(ChildPCERequestManager cprm, RequestDispatcher requestDispatcher, ITMDTEDB ITmdtedb, ReachabilityManager rm, PCEPSessionsInformation pcepSessionManager, MultiDomainTopologyUpdater mdtu, int parentPCEManagementPort) {
        this.cprm = cprm;
        this.requestDispatcher = requestDispatcher;
        this.ITmdtedb = ITmdtedb;
        this.rm = rm;
        this.isITcapable = true;
        this.pcepSessionManager = pcepSessionManager;
        this.mdtu = mdtu;
        this.parentPCEManagementPort = parentPCEManagementPort;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        boolean listening = true;
        try {
            this.log.info("Listening on port " + this.parentPCEManagementPort);
            serverSocket = new ServerSocket(this.parentPCEManagementPort);
        }
        catch (Exception e) {
            this.log.error("Could not listen management on port" + this.parentPCEManagementPort);
            e.printStackTrace();
            return;
        }
        try {
            while (listening) {
                if (this.isITcapable) {
                    new ParentPCEManagementSession(serverSocket.accept(), this.cprm, this.requestDispatcher, this.ITmdtedb, this.rm, this.pcepSessionManager, this.mdtu).start();
                    continue;
                }
                new ParentPCEManagementSession(serverSocket.accept(), this.cprm, this.requestDispatcher, this.mdtedb, this.simpleTedb, this.rm, this.pcepSessionManager, this.mdtu, this.multiDomainLSPDB).start();
            }
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

