/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcepsession;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.messages.PCEPKeepalive;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveThread
extends Thread {
    private int keepAlive = 0;
    private boolean running;
    private Logger log;
    private DataOutputStream out = null;

    public KeepAliveThread(DataOutputStream out, int k) {
        this.keepAlive = k;
        this.out = out;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                if (this.keepAlive > 0) {
                    KeepAliveThread.sleep(this.keepAlive * 1000);
                    this.sendKeepAlive();
                    continue;
                }
                this.log.warn("Ending KEEPALIVE mechanism");
                return;
            }
            catch (InterruptedException e) {
                if (!this.running) {
                    this.log.warn("Ending KeepAliveThread");
                    return;
                }
                this.log.debug("Reseting Keepalive timer");
            }
        }
    }

    public void stopRunning() {
        this.running = false;
    }

    private void sendKeepAlive() {
        PCEPKeepalive p_ka = new PCEPKeepalive();
        try {
            p_ka.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            e1.printStackTrace();
        }
        try {
            this.log.debug("Sending Keepalive message");
            this.out.write(p_ka.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            this.log.warn("Sending KEEPALIVE: " + e.getMessage());
        }
    }
}

