/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcepsession;

import es.tid.pce.management.PcepCapability;
import es.tid.pce.management.PcepPeer;
import es.tid.pce.pcepsession.GenericPCEPSession;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Enumeration;
import java.util.Hashtable;

public class PCEPSessionsInformation {
    private PcepCapability localPcepCapability;
    public Hashtable<Long, GenericPCEPSession> sessionList = new Hashtable();
    private Hashtable<Inet4Address, PcepPeer> peerList;
    private boolean isSRCapable = false;
    private int MSD = 0;
    private boolean statefulDFlag = false;
    private boolean statefulTFlag = false;
    private boolean statefulSFlag = false;
    private boolean isActive = false;
    int rollSession;
    DataOutputStream out;

    public PCEPSessionsInformation() {
        this.localPcepCapability = new PcepCapability();
        this.peerList = new Hashtable();
    }

    public void addSession(long sessionId, GenericPCEPSession session) {
        this.sessionList.put(new Long(sessionId), session);
    }

    public void deleteSession(long sessionId) {
        this.sessionList.remove(new Long(sessionId));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(20 + this.sessionList.size() * 100);
        sb.append(this.sessionList.size());
        sb.append(" active sessions\n");
        Enumeration<GenericPCEPSession> enumSessionList = this.sessionList.elements();
        while (enumSessionList.hasMoreElements()) {
            sb.append(enumSessionList.nextElement().shortInfo());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public String printSession(long sessionId) {
        GenericPCEPSession ses = this.sessionList.get(new Long(sessionId));
        if (ses != null) {
            return ses.toString();
        }
        return "session " + sessionId + " does not exist";
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public void setOut(DataOutputStream out) {
        this.out = out;
    }

    public int getRollSession() {
        return this.rollSession;
    }

    public void setRollSession(int rollSession) {
        this.rollSession = rollSession;
    }

    public boolean isStateful() {
        return this.localPcepCapability.isStateful();
    }

    public boolean isSRCapable() {
        return this.isSRCapable;
    }

    public int getMSD() {
        return this.MSD;
    }

    public void setStateful(boolean isStateful) {
        this.localPcepCapability.setStateful(isStateful);
    }

    public void setSRCapable(boolean isSRCapable) {
        this.isSRCapable = isSRCapable;
    }

    public void setSRCapable(int MSD) {
        this.isSRCapable = MSD >= 0;
        this.MSD = MSD;
    }

    public void setMSD(int MSD) {
        this.MSD = MSD;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isStatefulDFlag() {
        return this.statefulDFlag;
    }

    public void setStatefulDFlag(boolean statefulDFlag) {
        this.statefulDFlag = statefulDFlag;
    }

    public boolean isStatefulTFlag() {
        return this.statefulTFlag;
    }

    public void setStatefulTFlag(boolean statefulTFlag) {
        this.statefulTFlag = statefulTFlag;
    }

    public boolean isStatefulSFlag() {
        return this.statefulSFlag;
    }

    public void setStatefulSFlag(boolean statefulSFlag) {
        this.statefulSFlag = statefulSFlag;
    }

    public PcepCapability getLocalPcepCapability() {
        return this.localPcepCapability;
    }

    public void setLocalPcepCapability(PcepCapability localPcepCapability) {
        this.localPcepCapability = localPcepCapability;
    }

    public void notifyPeer(Inet4Address addr) {
        if (!this.peerList.containsKey(addr)) {
            PcepPeer peer = new PcepPeer();
            peer.setAddr(addr);
            this.peerList.put(addr, peer);
        }
    }

    public void notifyPeerSessionOK(Inet4Address addr) {
        this.peerList.get(addr).notifyNewSessSetupOK();
    }

    public void notifyPeerSessionFail(Inet4Address addr) {
        this.peerList.get(addr).notifyNewSessSetupFail();
    }

    public void notifyPeerSessionActive(Inet4Address addr) {
        this.peerList.get(addr).setSessionExists(true);
    }

    public void notifyPeerSessionInactive(Inet4Address addr) {
        this.peerList.get(addr).setSessionExists(false);
    }

    public String printPeersInfo() {
        StringBuffer sb = new StringBuffer(200);
        Enumeration<PcepPeer> peers = this.peerList.elements();
        sb.append("Peers: ");
        while (peers.hasMoreElements()) {
            sb.append(peers.nextElement().toString());
        }
        return sb.toString();
    }

    public String printFullPeersInfo() {
        StringBuffer sb = new StringBuffer(200);
        Enumeration<PcepPeer> peers = this.peerList.elements();
        sb.append("Peers: ");
        while (peers.hasMoreElements()) {
            sb.append(peers.nextElement().fullInfo());
        }
        return sb.toString();
    }
}

