/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.ParentPCERequestManager;
import es.tid.pce.server.RequestQueue;
import es.tid.pce.server.Sender;
import es.tid.pce.server.SingleDomainInitiateDispatcher;
import es.tid.tedb.TEDB;
import es.tid.util.UtilsFunctions;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.LoggerFactory;

public class ChildPCESession
extends GenericPCEPSession {
    private RequestQueue parentPCERequestQueue;
    private int sessionID;
    PCEServerParameters params;
    private static long sessionIDCounter = 0L;
    private RequestDispatcher requestDispatcher;
    boolean running = true;
    private TEDB ted;
    private Inet4Address domainId;
    private Inet4Address pceId;
    private Sender sendingThread;
    private LinkedBlockingQueue<PCEPMessage> parentPCESendingQueue;
    private ParentPCERequestManager childPCERequestManager;
    private int state;
    private RequestDispatcher PCCRequestDispatcherChild;
    private SingleDomainInitiateDispatcher iniDispatcher;

    public ChildPCESession(RequestDispatcher PCCRequestDispatcherChild, PCEServerParameters params, RequestQueue parentPCERequestQueue, TEDB ted, Timer timer, LinkedBlockingQueue<PCEPMessage> parentPCESendingQueue, ParentPCERequestManager childPCERequestManager, Inet4Address domainId, PCEPSessionsInformation pcepSessionInformation, SingleDomainInitiateDispatcher iniDispatcher) {
        super(pcepSessionInformation);
        this.PCCRequestDispatcherChild = PCCRequestDispatcherChild;
        this.state = 0;
        this.parentPCERequestQueue = parentPCERequestQueue;
        this.log = LoggerFactory.getLogger((String)params.getPCEServerLogFile());
        this.requestDispatcher = this.requestDispatcher;
        this.ted = ted;
        this.params = params;
        this.timer = timer;
        this.parentPCESendingQueue = parentPCESendingQueue;
        this.childPCERequestManager = childPCERequestManager;
        this.keepAliveLocal = 30;
        this.deadTimerLocal = 120;
        this.iniDispatcher = iniDispatcher;
        try {
            this.domainId = domainId;
            this.pceId = (Inet4Address)Inet4Address.getLocalHost();
            this.log.info("pceId" + this.pceId);
            this.log.info("domainId" + domainId);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public ChildPCESession(PCEServerParameters params, RequestQueue parentPCERequestQueue, TEDB ted, Timer timer, LinkedBlockingQueue<PCEPMessage> parentPCESendingQueue, ParentPCERequestManager childPCERequestManager, Inet4Address domainId, PCEPSessionsInformation pcepSessionInformation, SingleDomainInitiateDispatcher iniDispatcher) {
        super(pcepSessionInformation);
        this.state = 0;
        this.parentPCERequestQueue = parentPCERequestQueue;
        this.log = LoggerFactory.getLogger((String)params.getPCEServerLogFile());
        this.ted = ted;
        this.params = params;
        this.timer = timer;
        this.parentPCESendingQueue = parentPCESendingQueue;
        this.childPCERequestManager = childPCERequestManager;
        this.keepAliveLocal = 30;
        this.deadTimerLocal = 120;
        this.iniDispatcher = iniDispatcher;
        try {
            this.domainId = domainId;
            this.pceId = (Inet4Address)Inet4Address.getLocalHost();
            this.log.info("pceId" + this.pceId);
            this.log.info("domainId" + domainId);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        this.log.info("Opening new PCEP Session with parent PCE " + this.params.getParentPCEAddress() + " on port " + this.params.getParentPCEPort());
        this.log.info("Local IP address --> " + this.params.getLocalPceAddress().toString() + " Port --> " + this.params.getPCEServerPort());
        try {
            Inet4Address addr = (Inet4Address)InetAddress.getByName(this.params.getLocalPceAddress());
            this.socket = new Socket(this.params.getParentPCEAddress(), this.params.getParentPCEPort(), (InetAddress)addr, 0);
            this.log.info("Socket opened");
        }
        catch (IOException e) {
            this.log.error("Couldn't get I/O for connection to Parent PCE" + this.params.getParentPCEAddress());
            this.killSession();
            return;
        }
        this.initializePCEPSession(false, 15, 200, false, true, this.domainId, this.pceId, 0);
        this.log.info("PCE Session succesfully established!!");
        this.deadTimerT = new DeadTimerThread(this, this.deadTimerLocal);
        this.startDeadTimer();
        this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveLocal);
        this.startKeepAlive();
        this.sendingThread = new Sender(this.parentPCESendingQueue, this.out);
        this.sendingThread.start();
        while (this.running) {
            try {
                this.msg = this.readMsg(this.in);
            }
            catch (IOException e) {
                this.cancelDeadTimer();
                this.cancelKeepAlive();
                this.timer.cancel();
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                this.log.warn("Finishing PCEP Session abruptly");
                return;
            }
            if (this.msg == null) continue;
            boolean pceMsg = true;
            switch (PCEPMessage.getMessageType((byte[])this.msg)) {
                case 1: {
                    this.log.debug("OPEN message received");
                    this.log.warn("OPEN message ignored");
                    break;
                }
                case 2: {
                    this.log.debug("KEEPALIVE message received");
                    break;
                }
                case 7: {
                    this.log.debug("CLOSE message received");
                    this.log.warn("Finishing PCEParentSession due to CLOSE");
                    this.killSession();
                    return;
                }
                case 6: {
                    this.log.debug("ERROR message received");
                    break;
                }
                case 5: {
                    this.log.debug("Received NOTIFY message");
                    break;
                }
                case 4: {
                    this.log.debug("Received PC RESPONSE message");
                    try {
                        PCEPResponse pcres = new PCEPResponse(this.msg);
                        Long idr = new Long(pcres.getResponse(0).getRequestParameters().getRequestID());
                        this.log.info("Llega un response del IdRequest " + idr);
                        Object object = this.childPCERequestManager.locks.get(idr);
                        synchronized (object) {
                            this.childPCERequestManager.notifyResponse(pcres);
                        }
                    }
                    catch (PCEPProtocolViolationException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    PCEPRequest p_req;
                    this.log.info("PCREQ message from Parent PCE received");
                    try {
                        p_req = new PCEPRequest(this.msg);
                    }
                    catch (PCEPProtocolViolationException e) {
                        e.printStackTrace();
                        break;
                    }
                    this.PCCRequestDispatcherChild.dispathRequests(p_req, this.out);
                    break;
                }
                case 12: {
                    this.log.info("INITIATE RECEIVED");
                    PCEPInitiate pcepInitiate = null;
                    try {
                        this.log.info(" XXXX try");
                        pcepInitiate = new PCEPInitiate(this.msg);
                        this.log.info("pcepInitiate: " + pcepInitiate);
                        this.log.info("Initiate from " + this.remotePeerIP + ": " + pcepInitiate);
                    }
                    catch (PCEPProtocolViolationException e) {
                        this.log.info(UtilsFunctions.exceptionToString((Exception)((Object)e)));
                    }
                    if (this.iniDispatcher == null) break;
                    this.iniDispatcher.dispathInitiate(pcepInitiate, this.out, this.remotePeerIP);
                    break;
                }
                default: {
                    this.log.warn("ERROR: unexpected message, Unknown message received!");
                    pceMsg = false;
                }
            }
            if (!pceMsg) continue;
            this.log.info("Reseting Dead Timer as PCEP Message has arrived");
            this.resetDeadTimer();
        }
        return;
    }

    @Override
    public void endSession() {
    }
}

