/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.ChildPCESession;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.ParentPCERequestManager;
import es.tid.pce.server.RequestQueue;
import es.tid.pce.server.SingleDomainInitiateDispatcher;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildPCESessionManager
extends TimerTask {
    private PCEServerParameters params;
    private ChildPCESession childPCEParentPCESession;
    private RequestDispatcher requestDispatcher;
    private RequestQueue parentPCERequestQueue;
    private TEDB ted;
    private LinkedBlockingQueue<PCEPMessage> sendingQueue;
    private ParentPCERequestManager childPCERequestManager;
    private Inet4Address domainId;
    private Logger log;
    private RequestDispatcher PCCRequestDispatcherChild;
    PCEPSessionsInformation pcepSessionInformation;
    private SingleDomainInitiateDispatcher iniDispatcher;

    public ChildPCESessionManager(RequestDispatcher PCCRequestDispatcherChild, PCEServerParameters params, TEDB ted, Inet4Address domainId, PCEPSessionsInformation pcepSessionInformation, SingleDomainInitiateDispatcher iniDispatcher) {
        this.params = params;
        this.ted = ted;
        this.PCCRequestDispatcherChild = PCCRequestDispatcherChild;
        this.pcepSessionInformation = pcepSessionInformation;
        this.parentPCERequestQueue = new RequestQueue(params.getParentPCERequestProcessors());
        this.sendingQueue = new LinkedBlockingQueue();
        this.childPCERequestManager = new ParentPCERequestManager(this.sendingQueue);
        this.domainId = domainId;
        this.iniDispatcher = iniDispatcher;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    public ChildPCESessionManager(PCEServerParameters params, TEDB ted, Inet4Address domainId, PCEPSessionsInformation pcepSessionInformation, SingleDomainInitiateDispatcher iniDispatcher) {
        this.params = params;
        this.ted = ted;
        this.pcepSessionInformation = pcepSessionInformation;
        this.parentPCERequestQueue = new RequestQueue(params.getParentPCERequestProcessors());
        this.sendingQueue = new LinkedBlockingQueue();
        this.childPCERequestManager = new ParentPCERequestManager(this.sendingQueue);
        this.domainId = domainId;
        this.iniDispatcher = iniDispatcher;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    public ChildPCESession getChildPCEParentPCESession() {
        return this.childPCEParentPCESession;
    }

    public void setChildPCEParentPCESession(ChildPCESession childPCEParentPCESession) {
        this.childPCEParentPCESession = childPCEParentPCESession;
    }

    @Override
    public void run() {
        if (this.childPCEParentPCESession != null) {
            this.log.warn("There is a session with Parent PCE!");
            if (this.childPCEParentPCESession.isAlive()) {
                if (this.childPCEParentPCESession.isInterrupted()) {
                    this.log.error("THREAD VIVO... SESION MUERTA");
                }
                return;
            }
            this.log.warn("Session with parent PCE dead, trying to establish new session");
            Timer timer = new Timer();
            this.childPCEParentPCESession = new ChildPCESession(this.PCCRequestDispatcherChild, this.params, this.parentPCERequestQueue, this.ted, timer, this.sendingQueue, this.childPCERequestManager, this.domainId, this.pcepSessionInformation, this.iniDispatcher);
            this.childPCEParentPCESession.start();
            return;
        }
        this.log.warn("No Session with parent PCE, trying to establish new session");
        this.sendingQueue.clear();
        Timer timer = new Timer();
        this.childPCEParentPCESession = new ChildPCESession(this.PCCRequestDispatcherChild, this.params, this.parentPCERequestQueue, this.ted, timer, this.sendingQueue, this.childPCERequestManager, this.domainId, this.pcepSessionInformation, this.iniDispatcher);
        this.childPCEParentPCESession.start();
    }

    public boolean PPCESessionStatus() {
        return this.childPCEParentPCESession.isAlive();
    }

    public int PPCESessionState() {
        return this.childPCEParentPCESession.getFSMstate();
    }

    public void killPPCESession() {
        this.childPCEParentPCESession.killSession();
    }

    public void closePPceSession() {
        if (this.childPCEParentPCESession.isAlive()) {
            this.childPCEParentPCESession.close(1);
        }
    }

    public RequestQueue getParentPCERequestQueue() {
        return this.parentPCERequestQueue;
    }

    public LinkedBlockingQueue<PCEPMessage> getSendingQueue() {
        return this.sendingQueue;
    }

    public ParentPCERequestManager getChildPCERequestManager() {
        return this.childPCERequestManager;
    }
}

