/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.ReportDispatcher;
import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManager;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManagerSSON;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputationSSON;
import es.tid.pce.computingEngine.algorithms.multiLayer.OperationsCounter;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.ChildPCESessionManager;
import es.tid.pce.server.DomainPCESession;
import es.tid.pce.server.ITSendTopologyTask;
import es.tid.pce.server.IniPCCManager;
import es.tid.pce.server.NotificationDispatcher;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.SendReachabilityTask;
import es.tid.pce.server.SendTopologyTask;
import es.tid.pce.server.SingleDomainInitiateDispatcher;
import es.tid.pce.server.TopologyManager;
import es.tid.pce.server.communicationpce.BackupSessionManagerTask;
import es.tid.pce.server.communicationpce.CollaborationPCESessionManager;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import es.tid.pce.server.management.PCEManagementSever;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.MultiLayerTEDB;
import es.tid.tedb.SSONListener;
import es.tid.tedb.SimpleITTEDB;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import es.tid.tedb.TEDListener;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainPCEServer
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger((String)"PCEServer");
    public static Logger log5;
    private static OperationsCounter OPcounter;
    private static ReportDB_Handler rptdb;
    private static boolean listening;
    PCEServerParameters params;
    ServerSocket serverSocket;
    PCEManagementSever pms;

    public void configure(String configFile) {
        this.params = configFile != null ? new PCEServerParameters(configFile) : new PCEServerParameters();
        this.params.initialize();
        try {
            Logger log2 = LoggerFactory.getLogger((String)"PCEPParser");
            Logger log3 = LoggerFactory.getLogger((String)"OSPFParser");
            Logger log4 = LoggerFactory.getLogger((String)"TEDBParser");
            log5 = LoggerFactory.getLogger((String)"OpMultiLayer");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        log.info("Configuration file: " + configFile);
        log.info("Inizializing TID PCE Server!!");
    }

    @Override
    public void run() {
        RequestDispatcher PCCRequestDispatcher;
        SimpleITTEDB ted;
        PCEPSessionsInformation pcepSessionsInformation = new PCEPSessionsInformation();
        pcepSessionsInformation.setStateful(this.params.isStateful());
        pcepSessionsInformation.setStatefulDFlag(this.params.isStatefulDFlag());
        pcepSessionsInformation.setStatefulSFlag(this.params.isStatefulSFlag());
        pcepSessionsInformation.setStatefulTFlag(this.params.isStatefulTFlag());
        pcepSessionsInformation.setActive(this.params.isActive());
        pcepSessionsInformation.setSRCapable(this.params.isSRCapable());
        pcepSessionsInformation.setMSD(this.params.getMSD());
        SingleDomainInitiateDispatcher iniDispatcher = null;
        SingleDomainLSPDB singleDomainLSPDB = null;
        IniPCCManager iniManager = null;
        if (this.params.isSRCapable()) {
            log.info("PCEServer: PCE is SR capable with MSD=" + pcepSessionsInformation.getMSD());
        }
        if (this.params.ITcapable) {
            log.info("IT capable Domain PCE");
            ted = new SimpleITTEDB();
        } else {
            log.info("GENERIC PCE");
            if (this.params.isMultilayer()) {
                ted = new MultiLayerTEDB();
                log.info("is multilayer");
            } else {
                ted = new SimpleTEDB();
            }
        }
        if (this.params.isStateful()) {
            log.info("Stateful PCE with T=" + this.params.isStatefulTFlag() + " D=" + this.params.isStatefulDFlag() + " S=" + this.params.isStatefulSFlag());
            singleDomainLSPDB = new SingleDomainLSPDB();
            if (this.params.getDbType().equals("_")) {
                singleDomainLSPDB.setExportDb(false);
            }
            iniManager = new IniPCCManager();
            iniDispatcher = new SingleDomainInitiateDispatcher(singleDomainLSPDB, iniManager);
        }
        TopologyManager topologyManager = new TopologyManager(this.params, (DomainTEDB)ted, log);
        topologyManager.initTopology();
        OPcounter = new OperationsCounter();
        ChildPCESessionManager pcm = null;
        RequestDispatcher PCCRequestDispatcherChild = null;
        if (this.params.getParentPCEAddress() != null) {
            log.info("Initializing Manager of the ChildPCE - Parent PCE Session");
            PCCRequestDispatcherChild = new RequestDispatcher(1, (TEDB)ted, null, this.params.isAnalyzeRequestTime());
            pcm = new ChildPCESessionManager(PCCRequestDispatcherChild, this.params, (TEDB)ted, ted.getReachabilityEntry().getDomainId(), pcepSessionsInformation, iniDispatcher);
        } else {
            log.info("There is no parent PCE");
        }
        log.info("Initializing Request Dispatcher");
        ReservationManager reservationManager = null;
        if (this.params.isReservation()) {
            log.info("Launching Reservation Manager");
            reservationManager = new ReservationManager((DomainTEDB)ted);
        }
        CollaborationPCESessionManager collaborationPCESessionManager = null;
        if (this.params.getParentPCEAddress() != null) {
            if (this.params.isCollaborativePCEs()) {
                collaborationPCESessionManager = new CollaborationPCESessionManager();
                PCCRequestDispatcher = new RequestDispatcher(this.params.getPCCRequestsProcessors(), (TEDB)ted, pcm.getChildPCERequestManager(), this.params.isAnalyzeRequestTime(), collaborationPCESessionManager);
            } else {
                PCCRequestDispatcher = new RequestDispatcher(this.params.getPCCRequestsProcessors(), (TEDB)ted, pcm.getChildPCERequestManager(), this.params.isAnalyzeRequestTime());
            }
        } else if (this.params.isMultilayer()) {
            PCCRequestDispatcher = new RequestDispatcher(this.params.getPCCRequestsProcessors(), (TEDB)ted, null, this.params.isAnalyzeRequestTime(), this.params.isUseMaxReqTime(), reservationManager, OPcounter, this.params.isMultilayer());
        } else if (this.params.isCollaborativePCEs()) {
            collaborationPCESessionManager = new CollaborationPCESessionManager();
            PCCRequestDispatcher = new RequestDispatcher(this.params.getPCCRequestsProcessors(), (TEDB)ted, null, this.params.isAnalyzeRequestTime(), this.params.isUseMaxReqTime(), reservationManager, collaborationPCESessionManager);
        } else {
            PCCRequestDispatcher = new RequestDispatcher(this.params.getPCCRequestsProcessors(), (TEDB)ted, null, this.params.isAnalyzeRequestTime(), this.params.isUseMaxReqTime(), reservationManager);
        }
        if (!this.params.ITcapable) {
            // empty if block
        }
        NotificationDispatcher nd = new NotificationDispatcher(reservationManager);
        if (this.params.algorithmRuleList.size() == 0) {
            log.warn("No hay algoritmos registrados!");
        }
        Timer timer = new Timer();
        if (this.params.getParentPCEAddress() != null) {
            log.info("Inizializing Session with Parent PCE");
            timer.schedule((TimerTask)pcm, 0L, 1000000L);
        }
        this.pms = new PCEManagementSever(PCCRequestDispatcher, (DomainTEDB)ted, this.params, reservationManager, collaborationPCESessionManager);
        this.pms.start();
        SendTopologyTask stg = null;
        ITSendTopologyTask ITstg = null;
        if (this.params.getParentPCEAddress() != null) {
            Timer timer2;
            if (this.params.ITcapable) {
                ITstg = new ITSendTopologyTask((DomainTEDB)ted, pcm);
                timer2 = new Timer();
                if (this.params.getParentPCEAddress() != null) {
                    log.info("Changing topology");
                    timer2.schedule((TimerTask)ITstg, 0L, 100000L);
                }
            } else if (!this.params.isActingAsBGP4Peer()) {
                stg = new SendTopologyTask((DomainTEDB)ted, pcm);
                timer2 = new Timer();
                if (this.params.getParentPCEAddress() != null) {
                    log.info("Changing topology");
                    timer2.schedule((TimerTask)stg, 0L, 100000L);
                }
            }
        }
        SendReachabilityTask srt = new SendReachabilityTask((DomainTEDB)ted, pcm);
        Timer timer3 = new Timer();
        if (this.params.getParentPCEAddress() != null) {
            timer3.schedule((TimerTask)srt, 0L, this.params.getTimeSendReachabilityTime());
        }
        if (this.params.isCollaborativePCEs()) {
            if (!this.params.isPrimary()) {
                BackupSessionManagerTask backupSessionTask = null;
                backupSessionTask = new BackupSessionManagerTask(this.params, (TEDB)ted, collaborationPCESessionManager, nd, pcepSessionsInformation);
                Timer timerBackupSession = new Timer();
                log.info("Inizializing Session with Primary PCE");
                timerBackupSession.schedule((TimerTask)backupSessionTask, 0L, 100000L);
            }
        } else {
            log.info("There are no collaborative PCEs");
        }
        listening = true;
        try {
            log.info("Listening on port: " + this.params.getPCEServerPort());
            log.info("Listening on address: " + this.params.getLocalPceAddress());
            this.serverSocket = new ServerSocket(this.params.getPCEServerPort(), 0, (Inet4Address)InetAddress.getByName(this.params.getLocalPceAddress()));
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + this.params.getPCEServerPort());
            System.exit(-1);
        }
        try {
            for (int i = 0; i < this.params.algorithmRuleList.size(); ++i) {
                try {
                    Class<?> aClass2;
                    Class<?> aClass = Class.forName("es.tid.pce.computingEngine.algorithms." + this.params.algorithmRuleList.get((int)i).algoName + "Manager");
                    log.info("Registering algorithm " + this.params.algorithmRuleList.get((int)i).algoName + " for of = " + this.params.algorithmRuleList.get((int)i).ar.of + " and svec = " + this.params.algorithmRuleList.get((int)i).ar.svec);
                    if (this.params.algorithmRuleList.get((int)i).isParentPCEAlgorithm) continue;
                    if (!this.params.algorithmRuleList.get((int)i).isSSSONAlgorithm) {
                        ComputingAlgorithmManager cam = (ComputingAlgorithmManager)aClass.newInstance();
                        PCCRequestDispatcher.registerAlgorithm(this.params.algorithmRuleList.get((int)i).ar, cam);
                        if (this.params.getParentPCEAddress() != null) {
                            PCCRequestDispatcherChild.registerAlgorithm(this.params.algorithmRuleList.get((int)i).ar, cam);
                        }
                        try {
                            aClass2 = Class.forName("es.tid.pce.computingEngine.algorithms." + this.params.algorithmRuleList.get((int)i).algoName + "PreComputation");
                            ComputingAlgorithmPreComputation cam2 = (ComputingAlgorithmPreComputation)aClass2.newInstance();
                            cam2.setTEDB((TEDB)ted);
                            cam2.initialize();
                            cam.setPreComputation(cam2);
                            ted.register((TEDListener)cam2);
                            cam.setReservationManager(reservationManager);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            log.warn("No precomputation in es.tid.pce.computingEngine.algorithms." + this.params.algorithmRuleList.get((int)i).algoName + "PreComputation");
                        }
                        continue;
                    }
                    ComputingAlgorithmManagerSSON cam_sson = (ComputingAlgorithmManagerSSON)aClass.newInstance();
                    PCCRequestDispatcher.registerAlgorithmSSON(this.params.algorithmRuleList.get((int)i).ar, cam_sson);
                    if (this.params.getParentPCEAddress() != null) {
                        PCCRequestDispatcherChild.registerAlgorithmSSON(this.params.algorithmRuleList.get((int)i).ar, cam_sson);
                    }
                    try {
                        aClass2 = Class.forName("es.tid.pce.computingEngine.algorithms." + this.params.algorithmRuleList.get((int)i).algoName + "PreComputation");
                        ComputingAlgorithmPreComputationSSON cam3 = (ComputingAlgorithmPreComputationSSON)aClass2.newInstance();
                        cam3.setTEDB((TEDB)ted);
                        cam3.initialize();
                        cam_sson.setPreComputation(cam3);
                        ted.registerSSON((SSONListener)cam3);
                        cam_sson.setReservationManager(reservationManager);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        log.warn("No precomputation in es.tid.pce.computingEngine.algorithms." + this.params.algorithmRuleList.get((int)i).algoName + "PreComputation");
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (this.params.getLambdaEnd() != Integer.MAX_VALUE && !this.params.ITcapable && !this.params.isMultilayer()) {
                ((SimpleTEDB)ted).notifyAlgorithms(this.params.getLambdaIni(), this.params.getLambdaEnd());
            }
            ReportDispatcher PCCReportDispatcher = null;
            if (pcepSessionsInformation.isStateful()) {
                log.info("redis: " + this.params.getDbType() + " " + this.params.getDbName());
                if (this.params.getDbType().equals("redis") && this.params.getDbName().length() > 0) {
                    log.info("redis: redis db with id: " + this.params.getDbName());
                    rptdb = new ReportDB_Handler(this.params.getDbName(), "localhost");
                    rptdb.fillFromDB();
                } else {
                    rptdb = new ReportDB_Handler();
                }
                this.params.setLspDB(rptdb);
                log.info("Creando dispatchers para el LSP DB");
                PCCReportDispatcher = new ReportDispatcher(rptdb, 2);
            }
            while (listening) {
                if (this.params.isCollaborativePCEs()) {
                    new DomainPCESession(this.serverSocket.accept(), this.params, PCCRequestDispatcher, (TEDB)ted, nd, reservationManager, collaborationPCESessionManager, pcepSessionsInformation, PCCReportDispatcher).start();
                    continue;
                }
                new DomainPCESession(this.serverSocket.accept(), this.params, PCCRequestDispatcher, (TEDB)ted, nd, reservationManager, pcepSessionsInformation, PCCReportDispatcher, iniDispatcher).start();
            }
            this.serverSocket.close();
        }
        catch (SocketException e) {
            if (!listening) {
                log.info("Socket closed due to controlled close");
            } else {
                log.error("Problem with the socket, exiting");
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopServer() {
        this.pms.stopServer();
        listening = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

