/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.objects.tlvs.StorageTLV;
import es.tid.pce.pcep.objects.tlvs.subtlvs.CostSubTLV;
import es.tid.pce.server.ChildPCESessionManager;
import es.tid.tedb.InterDomainEdge;
import es.tid.tedb.SimpleITTEDB;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSendTopologyGestion
extends TimerTask {
    private SimpleITTEDB ITtedb;
    private Logger log;
    private ChildPCESessionManager pcm;

    ITSendTopologyGestion(SimpleITTEDB ITtedb, ChildPCESessionManager pcm) {
        this.ITtedb = ITtedb;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    @Override
    public void run() {
        this.log.info("Showing interDomain links");
        LinkedList interDomainLinks = this.ITtedb.getInterDomainLinks();
        int size = interDomainLinks.size();
        if (size == 0) {
            this.log.warn("Size 0. There is not interdomain links");
        }
        for (int i = 0; i < size; ++i) {
            this.log.info("Source: " + ((InterDomainEdge)interDomainLinks.get(i)).getSrc_router_id() + "\tInterface id: " + ((InterDomainEdge)interDomainLinks.get(i)).getSrc_if_id() + "\nDestiny: " + ((InterDomainEdge)interDomainLinks.get(i)).getDst_router_id() + "\tInterface id: " + ((InterDomainEdge)interDomainLinks.get(i)).getDst_if_id());
        }
        this.log.info("Showing IT resources");
        Hashtable storageanddomain = this.ITtedb.getStorageCharacteristics();
        Enumeration storages = storageanddomain.keys();
        if (storages.hasMoreElements()) {
            StorageTLV storage = (StorageTLV)storages.nextElement();
            this.log.info("Storage " + storage.getResourceIDSubTLV().getResourceID().toString() + " has TotalSize:" + storage.storageSize.getTotalSize() + " and AvailableSize" + storage.storageSize.getAvailableSize() + " and UsageUnit:" + ((CostSubTLV)storage.getCostList().getFirst()).getUsageUnit().toString() + " and UnitaryCost:" + ((CostSubTLV)storage.getCostList().getFirst()).getUnitaryPrice().toString());
        }
    }
}

