/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniPCCManager {
    private Hashtable<Inet4Address, DataOutputStream> pccOutputStream;
    public Hashtable<Long, Object> inilocks = new Hashtable();
    private Hashtable<Long, StateReport> reports;
    private Logger log;

    public IniPCCManager() {
        this.pccOutputStream = new Hashtable();
        this.reports = new Hashtable();
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateReport newIni(PCEPInitiate pcini, Object node) {
        Object object_lock = new Object();
        long idSRP = ((PCEPIntiatedLSP)pcini.getPcepIntiatedLSPList().get(0)).getRsp().getSRP_ID_number();
        this.log.info("Sending PCEPInitiate to node " + node + "srp_id " + idSRP + " : " + pcini.toString());
        this.inilocks.put(new Long(idSRP), object_lock);
        try {
            this.sendInitiate(pcini, node);
        }
        catch (IOException e1) {
            this.log.warn("Problem with response from node " + node + " to initiate with srp_id " + idSRP);
            this.inilocks.remove(object_lock);
            return null;
        }
        Object e1 = object_lock;
        synchronized (e1) {
            try {
                this.log.debug("Request sent, waiting for response");
                object_lock.wait(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        StateReport resp = this.reports.get(new Long(idSRP));
        if (resp == null) {
            this.log.warn("No response from node " + node + " to initiate with srp_id " + idSRP);
        } else {
            this.log.info("Node " + node + " replied to Initiate with srp_id " + idSRP + " : " + resp.toString());
        }
        return resp;
    }

    public synchronized void sendInitiate(PCEPInitiate ini, Object node) throws IOException {
        try {
            ini.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            e1.printStackTrace();
        }
        DataOutputStream out = this.pccOutputStream.get(node);
        if (out == null) {
            this.log.warn("There is no PCE for node " + node);
            throw new IOException();
        }
        try {
            this.log.info("Sending Initiate message to node " + node);
            out.write(ini.getBytes());
            out.flush();
        }
        catch (IOException e) {
            this.log.warn("Error sending Init: " + e.getMessage());
            throw e;
        }
    }

    public void notifyReport(StateReport sr) {
        long idRequest = sr.getSRP().getSRP_ID_number();
        this.log.info("Entrando en Notify Report de id " + idRequest);
        Object object_lock = this.inilocks.get(new Long(idRequest));
        this.reports.put(new Long(idRequest), sr);
        if (object_lock != null) {
            object_lock.notifyAll();
        }
        this.inilocks.remove(object_lock);
    }

    public Hashtable<Inet4Address, DataOutputStream> getPccOutputStream() {
        return this.pccOutputStream;
    }

    public void setPccOutputStream(Hashtable<Inet4Address, DataOutputStream> pccOutputStream) {
        this.pccOutputStream = pccOutputStream;
    }
}

