/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.SimpleTEDB;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationProcessorThread
extends Thread {
    private boolean running = true;
    private LinkedBlockingQueue<Notify> notificationList;
    private ReservationManager reservationManager;
    private Logger log;

    public NotificationProcessorThread(LinkedBlockingQueue<Notify> notificationList, ReservationManager reservationManager) {
        this.notificationList = notificationList;
        this.reservationManager = reservationManager;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Notify notify = this.notificationList.take();
                LinkedList notificationList = notify.getNotificationList();
                block7: for (int i = 0; i < notificationList.size(); ++i) {
                    Notification notif = (Notification)notificationList.get(i);
                    switch (notif.getNotificationType()) {
                        case 120: {
                            if (this.reservationManager != null) {
                                if (notif.getNotificationValue() == 1) {
                                    if (notif.getReservationIDTLV() != null) {
                                        long idReservation = notif.getReservationIDTLV().getReservationID();
                                        this.log.info("Processing CANCEL RESERVATION NOTIFICATION");
                                        this.reservationManager.cancelReservation(idReservation);
                                        continue block7;
                                    }
                                    this.log.info("RESERVATION ID TLV NO VIENE");
                                    continue block7;
                                }
                                if (notif.getNotificationValue() != 2) continue block7;
                                this.reservationManager.cancelAllReservations();
                                continue block7;
                            }
                            this.log.info("RESERVATION MANAGER ES NULL");
                            continue block7;
                        }
                        case 121: {
                            this.log.info("PCEP NOTIFICATION TYPE: PRERESERVE");
                            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
                            LinkedList<Object> targetVertexList = new LinkedList<Object>();
                            DWDMWavelengthLabel dwdmWavelengthLabel = new DWDMWavelengthLabel();
                            int lambdaToModify = 0;
                            this.initializeVariables(((Notification)notificationList.get(i)).getNotificationTLV().geteRO().getEROSubobjectList(), sourceVertexList, targetVertexList, dwdmWavelengthLabel);
                            lambdaToModify = dwdmWavelengthLabel.getN() - ((SimpleTEDB)this.reservationManager.getTed()).getWSONinfo().getnMin();
                            long time = ((Notification)notificationList.get(i)).getNotificationTLV().getTime();
                            boolean bidirectional = ((Notification)notificationList.get(i)).getNotificationTLV().isBidirectional();
                            this.reservationManager.reserve(sourceVertexList, targetVertexList, lambdaToModify, time, bidirectional);
                            continue block7;
                        }
                        default: {
                            this.log.info("ERROR: unexpected message");
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean initializeVariables(LinkedList<EROSubobject> erolist, LinkedList<Object> src, LinkedList<Object> dst, DWDMWavelengthLabel dwdmWavelengthLabel) {
        int number_lambdas = 0;
        boolean labelFound = false;
        for (int i = 0; i < erolist.size() - 1; ++i) {
            if (erolist.get(i).getType() == 3) {
                if (!labelFound) {
                    labelFound = true;
                    dwdmWavelengthLabel = ((GeneralizedLabelEROSubobject)erolist.get(i)).getDwdmWavelengthLabel();
                }
                ++number_lambdas;
            }
            if (erolist.get(i).getType() == 1) {
                src.add(i - number_lambdas, ((IPv4prefixEROSubobject)erolist.get(i)).getIpv4address());
            } else if (erolist.get(i).getType() == 4) {
                src.add(i - number_lambdas, ((UnnumberIfIDEROSubobject)erolist.get(i)).getRouterID());
            }
            if (erolist.get(i + 1).getType() == 1) {
                dst.add(i - number_lambdas, ((IPv4prefixEROSubobject)erolist.get(i + 1)).getIpv4address());
                continue;
            }
            if (erolist.get(i + 1).getType() == 4) {
                dst.add(i - number_lambdas, ((UnnumberIfIDEROSubobject)erolist.get(i + 1)).getRouterID());
                continue;
            }
            if (erolist.get(i + 1).getType() != 3) continue;
            if (erolist.get(i + 2).getType() == 1) {
                dst.add(i - number_lambdas, ((IPv4prefixEROSubobject)erolist.get(i + 2)).getIpv4address());
            } else if (erolist.get(i + 2).getType() == 4) {
                dst.add(i - number_lambdas, ((UnnumberIfIDEROSubobject)erolist.get(i + 2)).getRouterID());
            }
            return true;
        }
        return false;
    }
}

