/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentPCERequestManager {
    private LinkedBlockingQueue<PCEPMessage> sendingQueue;
    public Hashtable<Long, Object> locks = new Hashtable();
    private Hashtable<Long, PCEPResponse> responses = new Hashtable();
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public ParentPCERequestManager(LinkedBlockingQueue<PCEPMessage> sendingQueue) {
        this.sendingQueue = sendingQueue;
    }

    public void notifyResponse(PCEPResponse pcres) {
        long idRequest = pcres.getResponse(0).getRequestParameters().getRequestID();
        this.log.debug("Notifying Response with idRequest " + idRequest);
        Object object_lock = this.locks.get(new Long(idRequest));
        this.responses.put(new Long(idRequest), pcres);
        if (object_lock != null) {
            object_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCEPResponse newRequest(PCEPRequest pcreq) {
        this.log.info("New Request");
        Object object_lock = new Object();
        long idRequest = pcreq.getRequest(0).getRequestParameters().getRequestID();
        this.log.info("Id request es " + idRequest);
        this.locks.put(new Long(idRequest), object_lock);
        this.sendingQueue.add((PCEPMessage)pcreq);
        Object object = object_lock;
        synchronized (object) {
            try {
                this.log.debug("Request sent, waiting for response");
                object_lock.wait(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.log.debug("Request or timeout");
        PCEPResponse resp = this.responses.get(new Long(idRequest));
        if (resp == null) {
            this.log.warn("NO RESPONSE!!!!!");
        }
        return resp;
    }
}

