/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.ospf.ospfv2.lsa.LSA;
import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import es.tid.pce.server.RedisDatabaseHandler;
import es.tid.tedb.DatabaseControlSimplifiedLSA;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;

public class RedisTEDUpdaterThread
extends Thread {
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue;

    public RedisTEDUpdaterThread(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue) {
        this.redisOspfv2PacketQueue = redisOspfv2PacketQueue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    OSPFv2LinkStateUpdatePacket ospfv2Packet = this.redisOspfv2PacketQueue.take();
                    LinkedList lsaList = ospfv2Packet.getLSAlist();
                    int i = 0;
                    while (true) {
                        if (i >= lsaList.size()) continue block3;
                        if (((LSA)lsaList.get(i)).getLStype() == 10) {
                            OSPFTEv2LSA lsa = (OSPFTEv2LSA)lsaList.get(i);
                            DatabaseControlSimplifiedLSA dcsl = new DatabaseControlSimplifiedLSA();
                            dcsl.fillSimplifiedLsa(lsa);
                            String jsonLSA = dcsl.logJsonSimplifiedLSA();
                            RedisDatabaseHandler rdh = new RedisDatabaseHandler();
                            rdh.write("LSA:" + dcsl.getAdvertisingRouter().getHostAddress() + ":" + dcsl.getLinkId().getHostAddress(), jsonLSA);
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

