/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.ParentPCERequestManager;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SimpleITTEDB;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor
implements Runnable {
    private PCEPRequest req;
    private DataOutputStream out;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private TEDB ted;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
    private ParentPCERequestManager childPCERequestManager;

    public RequestProcessor(PCEPRequest req, DataOutputStream out, TEDB ted, ParentPCERequestManager childPCERequestManager) {
        this.req = req;
        this.out = out;
        this.ted = ted;
        this.childPCERequestManager = childPCERequestManager;
    }

    @Override
    public void run() {
        this.log.info("Processing request");
        this.log.info("Choosing default algorithm");
        this.log.info("Obtaining Network Graph copy");
        EndPoints EP = null;
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (!this.ted.isITtedb()) {
            this.networkGraph = ((SimpleTEDB)this.ted).getDuplicatedNetworkGraph();
            EP = this.req.getRequest(0).getEndPoints();
            source_router_id_addr = ((EndPointsIPv4)EP).getSourceIP();
            dest_router_id_addr = ((EndPointsIPv4)EP).getDestIP();
        } else {
            this.networkGraph = ((SimpleITTEDB)this.ted).getDuplicatedNetworkGraph();
            EP = this.req.getRequest(0).getEndPoints();
            if (EP.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)EP;
                if (gep.getGeneralizedEndPointsType() == 0) {
                    P2PEndpoints p2pep = gep.getP2PEndpoints();
                    EndPoint sourceep = p2pep.getSourceEndPoint();
                    EndPoint destep = p2pep.getDestinationEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
                if (gep.getGeneralizedEndPointsType() == 1) {
                    P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                    EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                    EndPoint sourceep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    int cont = 0;
                    while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                        epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                        EndPoint destep = epandrest.getEndPoint();
                        source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                        dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                    }
                }
            }
        }
        this.log.info("Source: " + source_router_id_addr);
        this.log.info("Destination: " + dest_router_id_addr);
        this.log.info("Check if we have source and destination in our TED");
        if (!this.networkGraph.containsVertex((Object)source_router_id_addr) || !this.networkGraph.containsVertex((Object)dest_router_id_addr)) {
            if (this.childPCERequestManager != null) {
                this.log.info("Source or destination are NOT in the TED, asking the parent PCE");
                PCEPResponse resp = this.childPCERequestManager.newRequest(this.req);
                try {
                    try {
                        resp.encode();
                    }
                    catch (PCEPProtocolViolationException e1) {
                        this.log.error("Response from Parent PCE not valid!!!!!");
                        return;
                    }
                    this.log.info("Request from Parent PCE processeed, about to send response");
                    this.out.write(resp.getBytes());
                    this.out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            this.log.warn("Source or destination are NOT in the TED");
            ComputingResponse m_resp = new ComputingResponse();
            Response response = new Response();
            RequestParameters rp = new RequestParameters();
            rp.setRequestID(this.req.getRequest(0).getRequestParameters().getRequestID());
            response.setRequestParameters(rp);
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.networkGraph.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.networkGraph.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            m_resp.addResponse(response);
            try {
                m_resp.encode();
            }
            catch (PCEPProtocolViolationException e1) {
                this.log.error("Response not valid!!!!!");
                return;
            }
            this.log.info("RequestProcessor: request processed");
            try {
                this.log.info("Request processeed, about to send response");
                this.out.write(m_resp.getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.log.info("Response sent!!");
            return;
        }
        long tiempoini = System.currentTimeMillis();
        ComputingResponse m_resp = new ComputingResponse();
        Response response = new Response();
        if (source_router_id_addr.equals(dest_router_id_addr)) {
            this.log.info("Source and destination are the same!");
            Path path = new Path();
            RequestParameters rp = new RequestParameters();
            rp.setRequestID(this.req.getRequest(0).getRequestParameters().getRequestID());
            response.setRequestParameters(rp);
            ExplicitRouteObject ero = new ExplicitRouteObject();
            IPv4prefixEROSubobject eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address(source_router_id_addr);
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            response.addPath(path);
            long tiempofin = System.nanoTime();
            long tiempotot = tiempofin - tiempoini;
            m_resp.addResponse(response);
        } else {
            UnnumberIfIDEROSubobject eroso;
            this.log.info("Computing path");
            DijkstraShortestPath dsp = new DijkstraShortestPath(this.networkGraph, (Object)source_router_id_addr, (Object)dest_router_id_addr);
            GraphPath gp = dsp.getPath();
            long tiempofin = System.currentTimeMillis();
            long tiempotot = tiempofin - tiempoini;
            this.log.info("Ha tardado " + tiempotot + " milisegundos");
            this.log.info("Creating response");
            RequestParameters rp = new RequestParameters();
            rp.setRequestID(this.req.getRequest(0).getRequestParameters().getRequestID());
            response.setRequestParameters(rp);
            m_resp.addResponse(response);
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp.getEdgeList();
            for (int i = 0; i < edge_list.size(); ++i) {
                eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
                eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
                eroso.setLoosehop(false);
                ero.addEROSubobject((EROSubobject)eroso);
            }
            eroso = new IPv4prefixEROSubobject();
            eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
            eroso.setPrefix(32);
            ero.addEROSubobject((EROSubobject)eroso);
            path.setEro(ero);
            response.addPath(path);
        }
        try {
            m_resp.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            this.log.error("Response not valid!!!!!");
            return;
        }
        this.log.info("RequestProcessor: request processed");
        try {
            this.log.info("Request processeed, about to send response");
            this.out.write(m_resp.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("Response sent!!");
    }
}

