/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.tlvs.ReachabilityTLV;
import es.tid.pce.server.ChildPCESessionManager;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.ReachabilityEntry;
import java.util.LinkedList;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendReachabilityTask
extends TimerTask {
    private DomainTEDB tedb;
    private Logger log;
    private ChildPCESessionManager pcm;

    SendReachabilityTask(DomainTEDB tedb, ChildPCESessionManager pcm) {
        this.tedb = tedb;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.pcm = pcm;
    }

    @Override
    public void run() {
        ReachabilityEntry reachabilityEntry = this.tedb.getReachabilityEntry();
        PCEPNotification notificationMessage = new PCEPNotification();
        Notify notify = new Notify();
        LinkedList<Notification> notificationList = new LinkedList<Notification>();
        Notification notification = new Notification();
        notification.setNotificationType(100);
        IPv4prefixEROSubobject ipv4prefixEROSubobject = new IPv4prefixEROSubobject();
        ipv4prefixEROSubobject.setIpv4address(reachabilityEntry.getAggregatedIPRange());
        ipv4prefixEROSubobject.setPrefix(reachabilityEntry.getPrefix());
        ReachabilityTLV reachabilityTLV = new ReachabilityTLV();
        reachabilityTLV.addEROSubobject((EROSubobject)ipv4prefixEROSubobject);
        notification.addReachabilityTLV(reachabilityTLV);
        notificationList.add(notification);
        notify.setNotificationList(notificationList);
        notificationMessage.addNotify(notify);
        this.pcm.getSendingQueue().add((PCEPMessage)notificationMessage);
    }
}

