/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.ospf.ospfv2.lsa.InterASTEv2LSA;
import es.tid.ospf.ospfv2.lsa.tlv.LinkTLV;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.IPv4RemoteASBRID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.LinkLocalRemoteIdentifiers;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.RemoteASNumber;
import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.tlvs.OSPFTE_LSA_TLV;
import es.tid.pce.server.ChildPCESessionManager;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.InterDomainEdge;
import java.net.Inet4Address;
import java.util.LinkedList;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTopologyTask
extends TimerTask {
    private DomainTEDB tedb;
    private Logger log;
    private ChildPCESessionManager pcm;

    SendTopologyTask(DomainTEDB tedb, ChildPCESessionManager pcm) {
        this.tedb = tedb;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.pcm = pcm;
    }

    @Override
    public void run() {
        int i;
        this.log.info("Showing interDomain links");
        LinkedList interDomainLinks = this.tedb.getInterDomainLinks();
        int size = interDomainLinks.size();
        if (size == 0) {
            this.log.warn("Size 0. There is not interdomain links");
        }
        for (i = 0; i < size; ++i) {
            this.log.info("Source: " + ((InterDomainEdge)interDomainLinks.get(i)).getSrc_router_id() + "\tInterface id: " + ((InterDomainEdge)interDomainLinks.get(i)).getSrc_if_id() + "\nDestiny: " + ((InterDomainEdge)interDomainLinks.get(i)).getDst_router_id() + "\tInterface id: " + ((InterDomainEdge)interDomainLinks.get(i)).getDst_if_id());
        }
        for (i = 0; i < size; ++i) {
            PCEPNotification notificationMessage = new PCEPNotification();
            Notify notify = new Notify();
            LinkedList<Notification> notificationList = new LinkedList<Notification>();
            Notification notification = new Notification();
            notification.setNotificationType(101);
            LinkTLV linkTLV = new LinkTLV();
            LinkLocalRemoteIdentifiers linkLocalRemoteId = new LinkLocalRemoteIdentifiers();
            linkLocalRemoteId.setLinkLocalIdentifier(((InterDomainEdge)interDomainLinks.get(i)).getSrc_if_id());
            linkLocalRemoteId.setLinkRemoteIdentifier(((InterDomainEdge)interDomainLinks.get(i)).getDst_if_id());
            linkTLV.setLinkLocalRemoteIdentifiers(linkLocalRemoteId);
            RemoteASNumber remoteASNumber = new RemoteASNumber();
            this.log.info("Remote AS nNumner " + ((InterDomainEdge)interDomainLinks.get(i)).getDomain_dst_router());
            remoteASNumber.setRemoteASNumber((Inet4Address)((InterDomainEdge)interDomainLinks.get(i)).getDomain_dst_router());
            linkTLV.setRemoteASNumber(remoteASNumber);
            IPv4RemoteASBRID iPv4RemoteASBRID = new IPv4RemoteASBRID();
            iPv4RemoteASBRID.setIPv4RemoteASBRID((Inet4Address)((InterDomainEdge)interDomainLinks.get(i)).getDst_router_id());
            linkTLV.setIPv4RemoteASBRID(iPv4RemoteASBRID);
            InterASTEv2LSA interASTEv2LSA = new InterASTEv2LSA();
            interASTEv2LSA.setAdvertisingRouter((Inet4Address)((InterDomainEdge)interDomainLinks.get(i)).getSrc_router_id());
            interASTEv2LSA.setLinkTLV(linkTLV);
            OSPFTE_LSA_TLV ospfte_lsa_tlv = new OSPFTE_LSA_TLV();
            ospfte_lsa_tlv.setInterASTEv2LSA(interASTEv2LSA);
            notification.addOSPFTE_LSA_TLV(ospfte_lsa_tlv);
            notificationList.add(notification);
            notify.setNotificationList(notificationList);
            notificationMessage.addNotify(notify);
            this.pcm.getSendingQueue().add((PCEPMessage)notificationMessage);
        }
    }
}

