/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.bgp.bgp4Peer.peer.BGPPeer;
import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.RedisTEDUpdaterThread;
import es.tid.pce.server.TopologyUpdaterThread;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.controllers.TEDUpdaterController;
import es.tid.tedb.ospfv2.OSPFSessionServer;
import es.tid.tedb.ospfv2.OSPFTCPSessionServer;
import es.tid.util.UtilsFunctions;
import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TopologyManager {
    PCEServerParameters params;
    DomainTEDB ted;
    Logger log;

    public TopologyManager(PCEServerParameters params, DomainTEDB ted, Logger log) {
        this.params = params;
        this.ted = ted;
        this.log = log;
    }

    public void initTopology() {
        if (this.params.isWLAN()) {
            this.initFromWLANController();
            this.params.initFromFile = false;
        }
        if (this.params.initFromFile) {
            this.initFromFile();
        }
        if (this.params.isOSPFSession()) {
            this.log.info("Initializing from OSPF");
            this.initFromOSPF();
        }
        if (this.params.isActingAsBGP4Peer()) {
            this.log.info("Acting as BGP Peer!");
            BGPPeer bgpPeer = new BGPPeer();
            bgpPeer.configure(this.params.getBGP4File());
            bgpPeer.setReadDomainTEDB(this.ted);
            bgpPeer.createUpdateDispatcher();
            bgpPeer.startClient();
            bgpPeer.startServer();
            bgpPeer.startManagementServer();
            bgpPeer.startSendTopology();
        }
    }

    private void initFromFile() {
        if (this.params.ITcapable) {
            this.log.info("Initializing IT capable TEDB");
            this.ted.initializeFromFile(this.params.getITNetworkDescriptionFile());
        } else if (this.params.isMultilayer()) {
            this.log.info("Initializing Multilayer TEDB");
            this.ted.initializeFromFile(this.params.getNetworkDescriptionFile());
        } else {
            if (this.params.isMultidomain()) {
                this.log.info("Initializing TEDB joining all domains in a single one");
            } else {
                this.log.info("Initializing Single Layer TEDB");
            }
            if (this.params.getLambdaEnd() != Integer.MAX_VALUE) {
                this.log.info("Entro en Max Value");
                ((SimpleTEDB)this.ted).initializeFromFile(this.params.getNetworkDescriptionFile(), this.params.getLayer(), this.params.isMultidomain(), this.params.getLambdaIni(), this.params.getLambdaEnd(), this.params.isSSOn(), false);
            } else if (this.params.isActingAsBGP4Peer() && this.params.isOSPFSession()) {
                ((SimpleTEDB)this.ted).initializeFromFile(this.params.getNetworkDescriptionFile(), this.params.getLayer(), this.params.isMultidomain(), this.params.getLambdaIni(), this.params.getLambdaEnd(), true, false);
                this.log.info("Entro en OSPF y BGP");
            } else {
                this.log.info("Entro en el else:::" + this.params.isSSOn() + ",params.isWLAN()" + this.params.isWLAN());
                this.log.info("params.getNetworkDescriptionFile()::" + this.params.getNetworkDescriptionFile());
                ((SimpleTEDB)this.ted).initializeFromFile(this.params.getNetworkDescriptionFile(), this.params.getLayer(), this.params.isMultidomain(), 0, Integer.MAX_VALUE, this.params.isSSOn(), false, this.params.isWLAN());
            }
        }
    }

    private void initFromOSPF() {
        Thread OSPFsessionserver;
        LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue = new LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket>();
        TopologyUpdaterThread tut = null;
        tut = this.params.isMultilayer() ? new TopologyUpdaterThread(ospfv2PacketQueue, this.ted, this.params.getLambdaIni(), this.params.getLambdaEnd(), this.params.isCompletedAuxGraph(), this.params.isMultilayer()) : new TopologyUpdaterThread(ospfv2PacketQueue, this.ted, this.params.getLambdaIni(), this.params.getLambdaEnd());
        tut.start();
        boolean redisDatabase = true;
        LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue = new LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket>();
        if (redisDatabase) {
            RedisTEDUpdaterThread rtut = new RedisTEDUpdaterThread(redisOspfv2PacketQueue);
            rtut.start();
        }
        this.log.info("params.isOSPFTCPSession():::" + this.params.isOSPFTCPSession());
        this.log.info("params.isOSPFSession():::" + this.params.isOSPFSession());
        if (this.params.isOSPFTCPSession()) {
            OSPFsessionserver = new OSPFTCPSessionServer(ospfv2PacketQueue, redisOspfv2PacketQueue);
            ((OSPFTCPSessionServer)OSPFsessionserver).setOSPFTCPPort(this.params.getOSPFTCPPort());
            OSPFsessionserver.start();
        } else if (this.params.isOSPFSession()) {
            System.out.println("Es OSPF Session");
            OSPFsessionserver = null;
            try {
                if (redisDatabase) {
                    OSPFsessionserver = new OSPFSessionServer(ospfv2PacketQueue, redisOspfv2PacketQueue, (Inet4Address)InetAddress.getByName(this.params.getOSPFListenerIP()));
                    ((OSPFSessionServer)OSPFsessionserver).setMulticast(this.params.isOSPFSession());
                    OSPFsessionserver.start();
                } else {
                    OSPFsessionserver = new OSPFSessionServer(ospfv2PacketQueue, (Inet4Address)InetAddress.getByName(this.params.getOSPFListenerIP()));
                    ((OSPFSessionServer)OSPFsessionserver).setMulticast(this.params.isOSPFSession());
                    OSPFsessionserver.start();
                }
            }
            catch (UnknownHostException e) {
                this.log.info(UtilsFunctions.exceptionToString(e));
            }
        }
    }

    private void initFromWLANController() {
        this.log.info("Initializing TED from WLAN Controller. New");
        ArrayList<String> ips = new ArrayList<String>();
        ArrayList<String> ports = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        TopologyManager.parseControllerFile(this.params.getControllerListFile(), ips, ports, types);
        SimpleDirectedWeightedGraph networkGraph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        ((SimpleTEDB)this.ted).setNetworkGraph(networkGraph);
        TopologyManager.updateTopology(ips, ports, types, this.ted, this.params.getInterDomainFile(), this.log);
    }

    public static void updateTopology(ArrayList<String> ips, ArrayList<String> ports, ArrayList<String> types, DomainTEDB ted, String interDomainFile, Logger log) {
        for (int i = 0; i < ips.size(); ++i) {
            try {
                Class<?> act = Class.forName("tid.pce.tedb.controllers.TEDUpdater" + types.get(i));
                Class[] cArg = new Class[]{String.class, String.class, String.class, String.class, DomainTEDB.class, Logger.class};
                Object[] args = new Object[]{ips.get(i), ports.get(i), "", "/v1.0/topology/switches", ted, log};
                TEDUpdaterController topUpdater = (TEDUpdaterController)act.getDeclaredConstructor(cArg).newInstance(args);
                topUpdater.setInterDomainFile(interDomainFile);
                topUpdater.run();
            }
            catch (Exception e1) {
                log.info(UtilsFunctions.exceptionToString(e1));
                return;
            }
            log.info(i + ":i + TED" + ted.printTopology());
        }
        TEDUpdaterController.parseRemainingLinksFromXML((DomainTEDB)ted, (String)interDomainFile);
    }

    public static void parseControllerFile(String controllerFile, ArrayList<String> ips, ArrayList<String> ports, ArrayList<String> types) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            File confFile = new File(controllerFile);
            Document doc = builder.parse(confFile);
            NodeList list_nodes_Edges = doc.getElementsByTagName("controller");
            for (int i = 0; i < list_nodes_Edges.getLength(); ++i) {
                Element nodes_servers = (Element)list_nodes_Edges.item(i);
                String ip = UtilsFunctions.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("ip").item(0));
                String port = UtilsFunctions.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("port").item(0));
                String type = UtilsFunctions.getCharacterDataFromElement((Element)nodes_servers.getElementsByTagName("type").item(0));
                ips.add(ip);
                ports.add(port);
                types.add(type);
                System.out.print("Adding controller with IP: " + ip + " and port: " + port + "and type: " + type);
            }
        }
        catch (Exception e) {
            System.out.print(UtilsFunctions.exceptionToString(e));
        }
    }
}

