/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server;

import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.ospf.ospfv2.lsa.LSA;
import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.MaximumReservableBandwidth;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.LabelSetField;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.MultiLayerTEDB;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TE_Information;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyUpdaterThread
extends Thread {
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue;
    private Logger log;
    private DomainTEDB TEDB;
    private int lambdaIni = 0;
    private int lambdaEnd = Integer.MAX_VALUE;
    private boolean isCompletedAuxGraph = false;
    private boolean multilayer = false;
    private int layer = 0;

    public TopologyUpdaterThread(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue, DomainTEDB TEDB2, int lambdaIni, int lambdaEnd) {
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.ospfv2PacketQueue = ospfv2PacketQueue;
        this.TEDB = TEDB2;
        this.lambdaIni = lambdaIni;
        this.lambdaEnd = lambdaEnd;
    }

    public TopologyUpdaterThread(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue, DomainTEDB TEDB2, int lambdaIni, int lambdaEnd, boolean isCompletedAuxGraph, boolean multilayer) {
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.ospfv2PacketQueue = ospfv2PacketQueue;
        this.TEDB = TEDB2;
        this.lambdaIni = lambdaIni;
        this.lambdaEnd = lambdaEnd;
        this.isCompletedAuxGraph = isCompletedAuxGraph;
        this.multilayer = multilayer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.log.info("Starting Topology Upadater Thread");
        while (true) {
            try {
                block4: while (true) {
                    ospfv2Packet = this.ospfv2PacketQueue.take();
                    domainId = (Inet4Address)Inet4Address.getByName("0.0.0.1");
                    this.TEDB.getReachabilityEntry().setDomainId(domainId);
                    if (this.TEDB.getReachabilityEntry().getDomainId() == null || !ospfv2Packet.getAreaID().toString().equalsIgnoreCase(this.TEDB.getReachabilityEntry().getDomainId().toString())) continue;
                    localInterfaceIPAddress = ospfv2Packet.getRouterID();
                    lsaList = ospfv2Packet.getLSAlist();
                    i = 0;
                    while (true) {
                        if (i < lsaList.size()) ** break;
                        continue block4;
                        if (((LSA)lsaList.get(i)).getLStype() == 10) {
                            lsa = (OSPFTEv2LSA)lsaList.get(i);
                            linkTLV = lsa.getLinkTLV();
                            if (linkTLV != null) {
                                if (localInterfaceIPAddress == null) {
                                    localInterfaceIPAddress = linkTLV.getLocalInterfaceIPAddress().getLocalInterfaceIPAddress(0);
                                }
                                this.log.debug("Local InterfaceIPAddress: " + localInterfaceIPAddress);
                                remoteInterfaceIPAddress = linkTLV.getLinkID().getLinkID();
                                this.log.debug("Remote InterfaceIPAddress: " + remoteInterfaceIPAddress);
                                newAvailableLabels = linkTLV.getAvailableLabels();
                                edge = null;
                                if (this.multilayer) {
                                    if (this.isCompletedAuxGraph) {
                                        if (newAvailableLabels != null) {
                                            lambda = 0;
                                            lambda = ((BitmapLabelSet)linkTLV.getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel().getN();
                                            ((MultiLayerTEDB)this.TEDB).notificationEdgeOPTICAL_AuxGraph((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, lambda);
                                        } else {
                                            informationTEDB = new TE_Information();
                                            maximumBandwidth = linkTLV.getMaximumBandwidth();
                                            if (maximumBandwidth != null) {
                                                informationTEDB.setMaximumBandwidth(maximumBandwidth);
                                            }
                                            if ((unreservedBandwidth = linkTLV.getUnreservedBandwidth()) != null) {
                                                informationTEDB.setUnreservedBandwidth(unreservedBandwidth);
                                            }
                                            maximumReservableBandwidth = new MaximumReservableBandwidth();
                                            maximumReservableBandwidth.setMaximumReservableBandwidth(unreservedBandwidth.getUnreservedBandwidth()[0]);
                                            if (maximumReservableBandwidth != null) {
                                                informationTEDB.setMaximumReservableBandwidth(maximumReservableBandwidth);
                                            }
                                            ((MultiLayerTEDB)this.TEDB).notificationEdgeIP_AuxGraph((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, informationTEDB);
                                        }
                                    } else if (newAvailableLabels == null) {
                                        edge = (IntraDomainEdge)((MultiLayerTEDB)this.TEDB).getUpperLayerGraph().getEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress);
                                        this.layer = 2;
                                    } else {
                                        edge = (IntraDomainEdge)((MultiLayerTEDB)this.TEDB).getLowerLayerGraph().getEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress);
                                        this.layer = 1;
                                    }
                                } else {
                                    edge = (IntraDomainEdge)((SimpleTEDB)this.TEDB).getNetworkGraph().getEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress);
                                    this.layer = 0;
                                }
                                newEdge = false;
                                newVertex = false;
                                newEdge_virtual = false;
                                changeWavelength = false;
                                lighpath_flag = false;
                                previousBitmapLabelSet = null;
                                newBitmapLabelSet = null;
                                if (edge != null) {
                                    // empty if block
                                }
                                if (edge == null && !this.isCompletedAuxGraph) {
                                    this.log.info("ADDING EDGE");
                                    edge = new IntraDomainEdge();
                                    if (this.layer == 0) {
                                        ((SimpleTEDB)this.TEDB).getNetworkGraph().addVertex((Object)localInterfaceIPAddress);
                                        ((SimpleTEDB)this.TEDB).getNetworkGraph().addVertex((Object)remoteInterfaceIPAddress);
                                        if (linkTLV.getLinkLocalRemoteIdentifiers() != null) {
                                            src_if_Id = linkTLV.getLinkLocalRemoteIdentifiers().getLinkLocalIdentifier();
                                            dst_if_Id = linkTLV.getLinkLocalRemoteIdentifiers().getLinkRemoteIdentifier();
                                            edge.setSrc_if_id(src_if_Id);
                                            edge.setDst_if_id(dst_if_Id);
                                        }
                                        ((SimpleTEDB)this.TEDB).getNetworkGraph().addEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, (Object)edge);
                                    } else if (this.layer == 1) {
                                        ((MultiLayerTEDB)this.TEDB).getLowerLayerGraph().addVertex((Object)localInterfaceIPAddress);
                                        ((MultiLayerTEDB)this.TEDB).getLowerLayerGraph().addVertex((Object)remoteInterfaceIPAddress);
                                        ((MultiLayerTEDB)this.TEDB).getLowerLayerGraph().addEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, (Object)edge);
                                    } else {
                                        newEdge_virtual = true;
                                        if (newEdge_virtual) {
                                            informationTEDB = new TE_Information();
                                            maximumBandwidth = linkTLV.getMaximumBandwidth();
                                            if (maximumBandwidth != null) {
                                                informationTEDB.setMaximumBandwidth(maximumBandwidth);
                                            }
                                            if ((unreservedBandwidth = linkTLV.getUnreservedBandwidth()) != null) {
                                                informationTEDB.setUnreservedBandwidth(unreservedBandwidth);
                                            }
                                            maximumReservableBandwidth = new MaximumReservableBandwidth();
                                            maximumReservableBandwidth.setMaximumReservableBandwidth(unreservedBandwidth.getUnreservedBandwidth()[0]);
                                            if (maximumReservableBandwidth != null) {
                                                informationTEDB.setMaximumReservableBandwidth(maximumReservableBandwidth);
                                            }
                                            ((MultiLayerTEDB)this.TEDB).notifyNewEdgeIP((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, informationTEDB);
                                            lighpath_flag = true;
                                        }
                                    }
                                    if (this.layer == 1 || this.layer == 0) {
                                        newVertex = true;
                                        newEdge = true;
                                    }
                                }
                                if (!lighpath_flag && !this.isCompletedAuxGraph) {
                                    informationTEDB = edge.getTE_info();
                                    if (informationTEDB == null) {
                                        informationTEDB = new TE_Information();
                                    }
                                    if (this.layer == 2) {
                                        if (newAvailableLabels == null) {
                                            maximumBandwidth = linkTLV.getMaximumBandwidth();
                                            if (maximumBandwidth != null) {
                                                informationTEDB.setMaximumBandwidth(maximumBandwidth);
                                            }
                                            if ((unreservedBandwidth = linkTLV.getUnreservedBandwidth()) != null) {
                                                informationTEDB.setUnreservedBandwidth(unreservedBandwidth);
                                            }
                                            maximumReservableBandwidth = new MaximumReservableBandwidth();
                                            maximumReservableBandwidth.setMaximumReservableBandwidth(unreservedBandwidth.getUnreservedBandwidth()[0]);
                                            if (maximumReservableBandwidth != null) {
                                                informationTEDB.setMaximumReservableBandwidth(maximumReservableBandwidth);
                                            }
                                        }
                                        edge.setTE_info(informationTEDB);
                                    } else if (newAvailableLabels != null) {
                                        if (newAvailableLabels.getLabelSet() != null) {
                                            if (newAvailableLabels.getLabelSet().getAction() == 4) {
                                                if (informationTEDB.getAvailableLabels() == null) {
                                                    informationTEDB.setAvailableLabels(new AvailableLabels());
                                                }
                                                if (informationTEDB.getAvailableLabels().getLabelSet() == null) {
                                                    previousBitmapLabelSet = newBitmapLabelSet = new BitmapLabelSet();
                                                    newBitmapLabelSet.createBytesBitMap(((BitmapLabelSet)newAvailableLabels.getLabelSet()).getBytesBitMap());
                                                    numLabels = linkTLV.getAvailableLabels().getLabelSet().getNumLabels();
                                                    numberBytes = this.getNumberBytes(numLabels);
                                                    this.log.info("NUM LABELS: " + numLabels + " NUMBER BYTES: " + numberBytes);
                                                    bytesBitMapReserved = new byte[numberBytes];
                                                    for (j = 0; j < numberBytes; ++j) {
                                                        bytesBitMapReserved[j] = 0;
                                                    }
                                                    newBitmapLabelSet.setBytesBitmap(bytesBitMapReserved);
                                                    newBitmapLabelSet.setBytesBitmapReserved(bytesBitMapReserved);
                                                    this.log.info("antes");
                                                    this.log.info("NUM LABELS: " + newBitmapLabelSet.getBytesBitMap().length);
                                                    newBitmapLabelSet.setNumLabels(numLabels);
                                                    informationTEDB.getAvailableLabels().setLabelSet((LabelSetField)newBitmapLabelSet);
                                                    newBitmapLabelSet.setDwdmWavelengthLabel(((BitmapLabelSet)linkTLV.getAvailableLabels().getLabelSet()).getDwdmWavelengthLabel());
                                                    changeWavelength = true;
                                                    edge.setTE_info(informationTEDB);
                                                } else {
                                                    previousBitmapLabelSet = new BitmapLabelSet();
                                                    previousBitmapLabelSet.createBytesBitMap(((BitmapLabelSet)informationTEDB.getAvailableLabels().getLabelSet()).getBytesBitMap());
                                                }
                                                if (!newEdge && this.hasChanged((LabelSetField)previousBitmapLabelSet, newAvailableLabels.getLabelSet())) {
                                                    if (this.lambdaEnd != 0x7FFFFFFF) {
                                                        ((BitmapLabelSet)informationTEDB.getAvailableLabels().getLabelSet()).arraycopyBytesBitMap(((BitmapLabelSet)newAvailableLabels.getLabelSet()).getBytesBitMap(), this.getNumberBytes(this.lambdaIni), this.getNumberBytes(this.lambdaEnd));
                                                    } else {
                                                        System.out.println("Actualizamos el nuevo bit map label set en la TEDB");
                                                        ((BitmapLabelSet)informationTEDB.getAvailableLabels().getLabelSet()).arraycopyBytesBitMap(((BitmapLabelSet)newAvailableLabels.getLabelSet()).getBytesBitMap());
                                                    }
                                                    changeWavelength = true;
                                                }
                                            }
                                        } else {
                                            this.log.info("TopologyUpdaterThread: El label set es null.");
                                        }
                                    }
                                    if (newVertex) {
                                        if (this.multilayer) {
                                            ((MultiLayerTEDB)this.TEDB).notifyNewVertex((Object)localInterfaceIPAddress);
                                            ((MultiLayerTEDB)this.TEDB).notifyNewVertex((Object)remoteInterfaceIPAddress);
                                        } else {
                                            this.TEDB.notifyNewVertex((Object)localInterfaceIPAddress);
                                            this.TEDB.notifyNewVertex((Object)remoteInterfaceIPAddress);
                                        }
                                    }
                                    if (newEdge) {
                                        if (this.multilayer) {
                                            ((MultiLayerTEDB)this.TEDB).notifyNewEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress);
                                        } else {
                                            this.TEDB.notifyNewEdge((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress);
                                        }
                                    }
                                    if (changeWavelength) {
                                        if (this.multilayer) {
                                            ((MultiLayerTEDB)this.TEDB).notifyWavelengthChange((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, previousBitmapLabelSet, (BitmapLabelSet)informationTEDB.getAvailableLabels().getLabelSet());
                                        } else {
                                            System.out.println("Entramos en el notifyWavelengthChange");
                                            this.TEDB.notifyWavelengthChange((Object)localInterfaceIPAddress, (Object)remoteInterfaceIPAddress, previousBitmapLabelSet, (BitmapLabelSet)informationTEDB.getAvailableLabels().getLabelSet());
                                        }
                                    }
                                }
                            } else {
                                this.log.debug("Link TLV de OSPFTEv2LSA esta a null");
                            }
                            this.log.debug("Processing LSA to update topology");
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void LSASDifferences(OSPFTEv2LSA lsaOriginal, OSPFTEv2LSA lsaReceived) {
        if (lsaOriginal.getLinkTLV().getLinkLocalRemoteIdentifiers() != null && lsaReceived.getLinkTLV().getLinkLocalRemoteIdentifiers() != null && !lsaOriginal.getLinkTLV().getLinkLocalRemoteIdentifiers().equals((Object)lsaReceived.getLinkTLV().getLinkLocalRemoteIdentifiers())) {
            this.log.info("Distinto el LinkLocalRemoteIdentifiers");
        }
        if (lsaOriginal.getLinkTLV().getLinkProtectionType() != null && lsaReceived.getLinkTLV().getLinkProtectionType() != null && !lsaOriginal.getLinkTLV().getLinkProtectionType().equals((Object)lsaReceived.getLinkTLV().getLinkProtectionType())) {
            this.log.info("Distinto el LinkProtectionType");
        }
        if (lsaOriginal.getLinkTLV().getInterfaceSwitchingCapabilityDescriptor() != null && lsaReceived.getLinkTLV().getInterfaceSwitchingCapabilityDescriptor() != null && !lsaOriginal.getLinkTLV().getInterfaceSwitchingCapabilityDescriptor().equals((Object)lsaReceived.getLinkTLV().getInterfaceSwitchingCapabilityDescriptor())) {
            this.log.info("Distinto el InterfaceSwitchingCapabilityDescriptor");
        }
        if (lsaOriginal.getLinkTLV().getSharedRiskLinkGroup() != null && lsaReceived.getLinkTLV().getSharedRiskLinkGroup() != null && !lsaOriginal.getLinkTLV().getSharedRiskLinkGroup().equals((Object)lsaReceived.getLinkTLV().getSharedRiskLinkGroup())) {
            this.log.info("Distinto el getSharedRiskLinkGroup");
        }
        if (lsaOriginal.getLinkTLV().getRemoteASNumber() != null && lsaReceived.getLinkTLV().getRemoteASNumber() != null && !lsaOriginal.getLinkTLV().getRemoteASNumber().equals((Object)lsaReceived.getLinkTLV().getRemoteASNumber())) {
            this.log.info("Distinto el getRemoteASNumber");
        }
        if (lsaOriginal.getLinkTLV().getiPv4RemoteASBRID() != null && lsaReceived.getLinkTLV().getiPv4RemoteASBRID() != null && !lsaOriginal.getLinkTLV().getiPv4RemoteASBRID().equals((Object)lsaReceived.getLinkTLV().getiPv4RemoteASBRID())) {
            this.log.info("Distinto el getiPv4RemoteASBRID");
        }
        if (lsaOriginal.getLinkTLV().getAvailableLabels() != null && lsaReceived.getLinkTLV().getAvailableLabels() != null && !lsaOriginal.getLinkTLV().getAvailableLabels().equals((Object)lsaReceived.getLinkTLV().getAvailableLabels())) {
            this.log.info("Distinto el LinkProtectionType");
        }
    }

    public int getNumberBytes(int lambda) {
        int numberBytes = lambda / 8;
        if (numberBytes * 8 < lambda) {
            ++numberBytes;
        }
        return numberBytes;
    }

    public boolean hasChanged(LabelSetField LabelTEinfo, LabelSetField LabelTElink) {
        byte[] bytesBitMapTElink;
        byte[] bytesBitMapTEinfo = ((BitmapLabelSet)LabelTEinfo).getBytesBitMap();
        if (bytesBitMapTEinfo.length != (bytesBitMapTElink = ((BitmapLabelSet)LabelTElink).getBytesBitMap()).length) {
            int nMin = ((SimpleTEDB)this.TEDB).getWSONinfo().getnMin();
            int numLambdas = ((SimpleTEDB)this.TEDB).getWSONinfo().getNumLambdas();
            int numberBytes = this.getNumberBytes(numLambdas);
            byte[] newBytes = new byte[bytesBitMapTElink.length];
            System.arraycopy(bytesBitMapTElink, nMin, newBytes, 0, numberBytes);
            for (int i = 0; i < bytesBitMapTEinfo.length; ++i) {
                if (bytesBitMapTEinfo[i] == newBytes[i]) continue;
                return true;
            }
        } else if (this.lambdaEnd != Integer.MAX_VALUE) {
            for (int i = this.getNumberBytes(this.lambdaIni); i < this.getNumberBytes(this.lambdaEnd); ++i) {
                if (bytesBitMapTEinfo[i] == bytesBitMapTElink[i]) continue;
                return true;
            }
        } else {
            for (int i = 0; i < bytesBitMapTEinfo.length; ++i) {
                if (bytesBitMapTEinfo[i] == bytesBitMapTElink[i]) continue;
                return true;
            }
        }
        return false;
    }
}

