/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.communicationpce;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.messages.PCEPClose;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.NotificationDispatcher;
import es.tid.pce.server.NotificationProcessorThread;
import es.tid.pce.server.communicationpce.CollaborationPCESessionManager;
import es.tid.tedb.TEDB;
import java.io.IOException;
import java.net.Socket;
import java.util.Timer;
import org.slf4j.LoggerFactory;

public class BackupPCESession
extends GenericPCEPSession {
    private String primaryPCE_IPaddress;
    private String localIPaddress;
    private int primaryPCE_port;
    private int localPort;
    private boolean running = true;
    private boolean no_delay = false;
    private NotificationDispatcher notificationDispatcher;
    NotificationProcessorThread npt;
    CollaborationPCESessionManager collaborationPCESessionManager;

    public BackupPCESession(String ip, int port, boolean no_delay, TEDB ted, CollaborationPCESessionManager collaborationPCESessionManager, NotificationDispatcher notificationDispatcher, Timer timer, PCEPSessionsInformation pcepSessionInformation) {
        super(pcepSessionInformation);
        this.setFSMstate(0);
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.primaryPCE_IPaddress = ip;
        this.primaryPCE_port = port;
        this.keepAliveLocal = 30;
        this.deadTimerLocal = 120;
        this.timer = timer;
        this.no_delay = no_delay;
        this.collaborationPCESessionManager = collaborationPCESessionManager;
        this.notificationDispatcher = notificationDispatcher;
    }

    @Override
    public void run() {
        this.running = true;
        this.log.info("Opening new PCEP Session with host " + this.primaryPCE_IPaddress + " on port " + this.primaryPCE_port);
        try {
            this.socket = new Socket(this.primaryPCE_IPaddress, this.primaryPCE_port);
            if (this.no_delay) {
                this.socket.setTcpNoDelay(true);
                this.log.info("No delay activated");
            }
            this.log.info("Socket opened");
        }
        catch (IOException e) {
            this.log.error("Couldn't get I/O for connection to " + this.primaryPCE_IPaddress + " in port " + this.primaryPCE_port);
            this.killSession();
            return;
        }
        this.initializePCEPSession(false, 15, 200, false, false, null, null, 0);
        this.collaborationPCESessionManager.getOpenedSessionsManager().registerNewSession(this.out, 2);
        this.deadTimerT = new DeadTimerThread(this, this.deadTimerLocal);
        this.startDeadTimer();
        this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveLocal);
        this.startKeepAlive();
        while (this.running) {
            try {
                this.msg = this.readMsg(this.in);
            }
            catch (IOException e) {
                this.cancelDeadTimer();
                this.cancelKeepAlive();
                this.timer.cancel();
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                this.log.error("Finishing PCEP Session abruptly");
                return;
            }
            if (this.msg == null) continue;
            boolean pceMsg = true;
            switch (PCEPMessage.getMessageType((byte[])this.msg)) {
                case 1: {
                    this.log.debug("OPEN message received");
                    this.log.warn("OPEN message ignored");
                    break;
                }
                case 2: {
                    this.log.debug("KEEPALIVE message received");
                    break;
                }
                case 7: {
                    this.log.debug("CLOSE message received");
                    try {
                        PCEPClose m_close = new PCEPClose(this.msg);
                        this.log.warn("Closing due to reason " + m_close.getReason());
                        this.killSession();
                    }
                    catch (PCEPProtocolViolationException e1) {
                        this.log.warn("Problem decoding message, closing session" + e1.getMessage());
                        this.killSession();
                        return;
                    }
                    return;
                }
                case 6: {
                    this.log.debug("ERROR message received");
                    break;
                }
                case 5: {
                    this.log.debug("Received NOTIFY message");
                    try {
                        PCEPNotification m_not = new PCEPNotification(this.msg);
                        this.notificationDispatcher.dispatchNotification(m_not);
                    }
                    catch (PCEPProtocolViolationException e1) {
                        this.log.warn("Problem decoding notify message, ignoring message" + e1.getMessage());
                        e1.printStackTrace();
                    }
                    break;
                }
                default: {
                    this.log.warn("ERROR: unexpected message");
                    pceMsg = false;
                }
            }
            if (!pceMsg) continue;
            this.log.debug("Reseting Dead Timer as PCEP Message has arrived");
            this.resetDeadTimer();
        }
    }

    public CollaborationPCESessionManager getCollaborationPCESessionManager() {
        return this.collaborationPCESessionManager;
    }

    public void setCollaborationPCESessionManager(CollaborationPCESessionManager collaborationPCESessionManager) {
        this.collaborationPCESessionManager = collaborationPCESessionManager;
    }

    @Override
    protected void endSession() {
    }
}

